/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.platform;

import cn.imkarl.core.common.log.LogLevel;
import cn.imkarl.core.common.platform.AndroidPlatform;
import cn.imkarl.core.common.platform.ConsoleColors;
import cn.imkarl.core.common.platform.LinuxPlatform;
import cn.imkarl.core.common.platform.MacOSPlatform;
import cn.imkarl.core.common.platform.WindowsPlatform;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 \f2\u00020\u0001:\u0002\u000b\fB\t\b\u0000\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\tH\u0016\u00a8\u0006\r"}, d2={"Lcn/imkarl/core/common/platform/Platform;", "", "<init>", "()V", "console", "", "level", "Lcn/imkarl/core/common/log/LogLevel;", "tag", "", "message", "OSType", "Companion", "Common"})
public abstract class Platform {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private static final Lazy<Platform> instance$delegate = LazyKt.lazy(Platform::instance_delegate$lambda$0);

    public void console(@NotNull LogLevel level, @NotNull String tag, @NotNull String message) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        switch (WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                string = ConsoleColors.Black.getAnsi();
                break;
            }
            case 2: {
                string = ConsoleColors.Green.getAnsi();
                break;
            }
            case 3: {
                string = ConsoleColors.Blue.getAnsi();
                break;
            }
            case 4: {
                string = ConsoleColors.Yellow.getAnsi();
                break;
            }
            case 5: {
                string = ConsoleColors.Red.getAnsi();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String colorAnsi = string;
        System.out.println((Object)(ConsoleColors.Purple.getAnsi() + '[' + level.name() + "] " + colorAnsi + tag + ": " + message + ConsoleColors.Default.getAnsi()));
    }

    private static final Platform instance_delegate$lambda$0() {
        Platform platform;
        OSType oSType = Companion.getOsType();
        switch (oSType == null ? -1 : WhenMappings.$EnumSwitchMapping$1[oSType.ordinal()]) {
            case 1: {
                platform = new WindowsPlatform();
                break;
            }
            case 2: {
                platform = new MacOSPlatform();
                break;
            }
            case 3: {
                platform = new LinuxPlatform();
                break;
            }
            case 4: {
                platform = new AndroidPlatform();
                break;
            }
            default: {
                throw new UnknownError("\u4e0d\u652f\u6301\u7684\u5e73\u53f0");
            }
        }
        return platform;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001b\u0010\u0004\u001a\u00020\u00058FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\b\u0010\t\u001a\u0004\b\u0006\u0010\u0007R\u0013\u0010\n\u001a\u0004\u0018\u00010\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\r\u00a8\u0006\u000e"}, d2={"Lcn/imkarl/core/common/platform/Platform$Companion;", "", "<init>", "()V", "instance", "Lcn/imkarl/core/common/platform/Platform;", "getInstance", "()Lcn/imkarl/core/common/platform/Platform;", "instance$delegate", "Lkotlin/Lazy;", "osType", "Lcn/imkarl/core/common/platform/Platform$OSType;", "getOsType", "()Lcn/imkarl/core/common/platform/Platform$OSType;", "Common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Platform getInstance() {
            Lazy lazy = instance$delegate;
            return (Platform)lazy.getValue();
        }

        @Nullable
        public final OSType getOsType() {
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Windows", (boolean)false, (int)2, null)) {
                    return OSType.WINDOWS;
                }
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Linux", (boolean)false, (int)2, null)) {
                    String httpAgent;
                    String string = System.getProperty("http.agent");
                    if (string == null) {
                        string = "";
                    }
                    if (StringsKt.contains$default((CharSequence)(httpAgent = string), (CharSequence)"Android", (boolean)false, (int)2, null) && Class.forName("android.os.Build") != null) {
                        return OSType.ANDROID;
                    }
                    return OSType.LINUX;
                }
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Solaris", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"SunOS", (boolean)false, (int)2, null)) {
                    return OSType.SOLARIS;
                }
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"OS X", (boolean)false, (int)2, null)) {
                    return OSType.MACOSX;
                }
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"AIX", (boolean)false, (int)2, null)) {
                    return OSType.AIX;
                }
            }
            return OSType.UNKNOWN;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\n\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\tj\u0002\b\n\u00a8\u0006\u000b"}, d2={"Lcn/imkarl/core/common/platform/Platform$OSType;", "", "<init>", "(Ljava/lang/String;I)V", "WINDOWS", "LINUX", "ANDROID", "SOLARIS", "MACOSX", "AIX", "UNKNOWN", "Common"})
    public static final class OSType
    extends Enum<OSType> {
        public static final /* enum */ OSType WINDOWS = new OSType();
        public static final /* enum */ OSType LINUX = new OSType();
        public static final /* enum */ OSType ANDROID = new OSType();
        public static final /* enum */ OSType SOLARIS = new OSType();
        public static final /* enum */ OSType MACOSX = new OSType();
        public static final /* enum */ OSType AIX = new OSType();
        public static final /* enum */ OSType UNKNOWN = new OSType();
        private static final /* synthetic */ OSType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static OSType[] values() {
            return (OSType[])$VALUES.clone();
        }

        public static OSType valueOf(String value) {
            return Enum.valueOf(OSType.class, value);
        }

        @NotNull
        public static EnumEntries<OSType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = oSTypeArray = new OSType[]{OSType.WINDOWS, OSType.LINUX, OSType.ANDROID, OSType.SOLARIS, OSType.MACOSX, OSType.AIX, OSType.UNKNOWN};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[LogLevel.values().length];
            try {
                nArray[LogLevel.VERBOSE.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.INFO.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.DEBUG.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.WARN.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LogLevel.ERROR.ordinal()] = 5;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[OSType.values().length];
            try {
                nArray[OSType.WINDOWS.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSType.MACOSX.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSType.LINUX.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[OSType.ANDROID.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

