/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.log;

import cn.imkarl.core.common.app.AppUtils;
import cn.imkarl.core.common.log.LogLevel;
import cn.imkarl.core.common.platform.Platform;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0007J\u0010\u0010\u000b\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u0007H\u0007J\u0012\u0010\r\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010\r\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010\u000f\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010\u0010\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010\u0010\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010\u0011\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010\u0011\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010\u0012\u001a\u00020\t2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010\u0012\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0007J\"\u0010\u0013\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u0016\u001a\u0004\u0018\u00010\u0007H\u0007J\"\u0010\u0017\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002J \u0010\u0018\u001a\u00020\t2\u0006\u0010\u0014\u001a\u00020\u00152\u0006\u0010\f\u001a\u00020\u00072\u0006\u0010\u0016\u001a\u00020\u0007H\u0002J\u0012\u0010\u0019\u001a\u00020\u00072\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcn/imkarl/core/common/log/LogUtils;", "", "<init>", "()V", "_maxOnceLength", "", "_globalTag", "", "setMaxOnceLength", "", "length", "setGlobalTag", "tag", "v", "message", "d", "i", "w", "e", "println", "level", "Lcn/imkarl/core/common/log/LogLevel;", "msg", "log", "console", "toString", "Common"})
public final class LogUtils {
    @NotNull
    public static final LogUtils INSTANCE = new LogUtils();
    private static int _maxOnceLength = 3000;
    @NotNull
    private static String _globalTag = AppUtils.getAppName();

    private LogUtils() {
    }

    @JvmStatic
    public static final void setMaxOnceLength(int length) {
        _maxOnceLength = length;
    }

    @JvmStatic
    public static final void setGlobalTag(@NotNull String tag) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        _globalTag = tag;
    }

    @JvmStatic
    public static final void v(@Nullable Object message) {
        INSTANCE.log(LogLevel.VERBOSE, _globalTag, message);
    }

    @JvmStatic
    public static final void v(@NotNull String tag, @Nullable Object message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        INSTANCE.log(LogLevel.VERBOSE, tag, message);
    }

    @JvmStatic
    public static final void d(@Nullable Object message) {
        INSTANCE.log(LogLevel.DEBUG, _globalTag, message);
    }

    @JvmStatic
    public static final void d(@NotNull String tag, @Nullable Object message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        INSTANCE.log(LogLevel.DEBUG, tag, message);
    }

    @JvmStatic
    public static final void i(@Nullable Object message) {
        INSTANCE.log(LogLevel.INFO, _globalTag, message);
    }

    @JvmStatic
    public static final void i(@NotNull String tag, @Nullable Object message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        INSTANCE.log(LogLevel.INFO, tag, message);
    }

    @JvmStatic
    public static final void w(@Nullable Object message) {
        INSTANCE.log(LogLevel.WARN, _globalTag, message);
    }

    @JvmStatic
    public static final void w(@NotNull String tag, @Nullable Object message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        INSTANCE.log(LogLevel.WARN, tag, message);
    }

    @JvmStatic
    public static final void e(@Nullable Object message) {
        INSTANCE.log(LogLevel.ERROR, _globalTag, message);
    }

    @JvmStatic
    public static final void e(@NotNull String tag, @Nullable Object message) {
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        INSTANCE.log(LogLevel.ERROR, tag, message);
    }

    @JvmStatic
    public static final void println(@NotNull LogLevel level, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        if (!AppUtils.isDebug()) {
            return;
        }
        INSTANCE.console(level, _globalTag, INSTANCE.toString(msg));
    }

    @JvmStatic
    public static final void println(@NotNull LogLevel level, @NotNull String tag, @Nullable String msg) {
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        if (!AppUtils.isDebug()) {
            return;
        }
        INSTANCE.console(level, tag, INSTANCE.toString(msg));
    }

    private final void log(LogLevel level, String tag, Object message) {
        String className;
        if (!AppUtils.isDebug()) {
            return;
        }
        StackTraceElement element = new Throwable().getStackTrace()[2];
        String string = className = element.getClassName();
        Intrinsics.checkNotNull((Object)string);
        String string2 = className;
        Intrinsics.checkNotNull((Object)string2);
        int n = StringsKt.lastIndexOf$default((CharSequence)string2, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
        String string3 = string.substring(n);
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"substring(...)");
        className = string3;
        String codeLine = className + '.' + element.getMethodName() + '(' + element.getFileName() + ':' + element.getLineNumber() + ')';
        this.console(level, tag, codeLine + "\n\t" + this.toString(message));
    }

    private final void console(LogLevel level, String tag, String msg) {
        if (msg.length() <= _maxOnceLength) {
            Platform.Companion.getInstance().console(level, tag, msg);
            return;
        }
        int startIndex = 0;
        int endIndex = _maxOnceLength;
        while (endIndex > startIndex) {
            Platform platform = Platform.Companion.getInstance();
            StringBuilder stringBuilder = new StringBuilder().append(startIndex == 0 ? "" : "\t\u2191\u2191\u2191\u2191\n");
            String string = msg.substring(startIndex, endIndex);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            platform.console(level, tag, stringBuilder.append(string).toString());
            startIndex = endIndex;
            endIndex = Math.min(msg.length(), startIndex + _maxOnceLength);
        }
    }

    private final String toString(Object message) {
        if (message == null) {
            return "[NULL]";
        }
        if (message instanceof Throwable) {
            for (Throwable t = (Throwable)message; t != null; t = t.getCause()) {
                if (!(t instanceof UnknownHostException)) continue;
                return ((UnknownHostException)t).toString();
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, false);
            ((Throwable)message).printStackTrace(pw);
            pw.flush();
            String string = sw.toString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
            return string;
        }
        return message.toString();
    }
}

