/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.io.file;

import cn.imkarl.core.common.io.file.FileExtensionsKt;
import cn.imkarl.core.common.io.file.FileUtils;
import cn.imkarl.core.common.json.JsonUtils;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.Charset;
import java.util.Properties;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.properties.ReadWriteProperty;
import kotlin.reflect.KClass;
import kotlin.reflect.KProperty;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001:\u0001\u001dB\u0019\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000bJ\u001a\u0010\n\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\r\u001a\u0004\u0018\u00010\u000bJ\n\u0010\u000e\u001a\u00060\u000fR\u00020\u0000J\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000b2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0001J\u0011\u0010\u0013\u001a\u00020\u00142\u0006\u0010\f\u001a\u00020\u000bH\u0086\u0002J\u000e\u0010\u0015\u001a\u00020\u00112\u0006\u0010\f\u001a\u00020\u000bJ\u0006\u0010\u0016\u001a\u00020\u0011J*\u0010\u0017\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\u00190\u0018\"\u0006\b\u0000\u0010\u0019\u0018\u00012\u0006\u0010\r\u001a\u0002H\u0019H\u0086\b\u00a2\u0006\u0002\u0010\u001aJ2\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0001\u0012\u0004\u0012\u0002H\u00190\u0018\"\u0006\b\u0000\u0010\u0019\u0018\u00012\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u0002H\u0019H\u0086\b\u00a2\u0006\u0002\u0010\u001cR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcn/imkarl/core/common/io/file/PropertiesUtils;", "", "file", "Ljava/io/File;", "charset", "Ljava/nio/charset/Charset;", "<init>", "(Ljava/io/File;Ljava/nio/charset/Charset;)V", "properties", "Ljava/util/Properties;", "getString", "", "key", "defValue", "edit", "Lcn/imkarl/core/common/io/file/PropertiesUtils$Editor;", "put", "", "value", "contains", "", "remove", "clear", "field", "Lkotlin/properties/ReadWriteProperty;", "T", "(Ljava/lang/Object;)Lkotlin/properties/ReadWriteProperty;", "fieldByKey", "(Ljava/lang/String;Ljava/lang/Object;)Lkotlin/properties/ReadWriteProperty;", "Editor", "Common"})
public final class PropertiesUtils {
    @NotNull
    private final File file;
    @NotNull
    private final Charset charset;
    @NotNull
    private final Properties properties;

    public PropertiesUtils(@NotNull File file, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.file = file;
        this.charset = charset;
        if (!this.file.exists()) {
            FileUtils.createNewFile(this.file);
        }
        this.properties = new Properties();
        this.properties.load(new InputStreamReader((InputStream)new FileInputStream(this.file), this.charset));
    }

    public /* synthetic */ PropertiesUtils(File file, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(file, charset);
    }

    @Nullable
    public final String getString(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.getString(key, null);
    }

    @Nullable
    public final String getString(@NotNull String key, @Nullable String defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return this.properties.getProperty(key, defValue);
    }

    @NotNull
    public final Editor edit() {
        return new Editor(this.properties, this.file);
    }

    public final void put(@NotNull String key, @Nullable Object value) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        this.edit().put(key, value).commit();
    }

    public final boolean contains(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        return ((CharSequence)key).length() > 0 && this.properties.contains(key);
    }

    public final void remove(@NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (((CharSequence)key).length() == 0) {
            return;
        }
        this.edit().remove(key).commit();
    }

    public final void clear() {
        this.edit().clear().commit();
    }

    public final /* synthetic */ <T> ReadWriteProperty<Object, T> field(T defValue) {
        boolean $i$f$field = false;
        Intrinsics.needClassReification();
        return new ReadWriteProperty<Object, T>(this, defValue){
            final /* synthetic */ PropertiesUtils this$0;
            final /* synthetic */ T $defValue;
            {
                this.this$0 = $receiver;
                this.$defValue = $defValue;
            }

            /*
             * WARNING - void declaration
             */
            public T getValue(Object thisRef, KProperty<?> property) {
                Object object;
                void $this$cast$iv;
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                String key = property.getName();
                String string = this.this$0.getString(key);
                T defValue$iv = this.$defValue;
                boolean $i$f$cast = false;
                if ($this$cast$iv == null) {
                    object = defValue$iv;
                } else {
                    Comparable<Boolean> comparable;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                        comparable = $this$cast$iv;
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                        comparable = StringsKt.equals((String)$this$cast$iv, (String)"true", (boolean)true) || StringsKt.equals((String)$this$cast$iv, (String)"yes", (boolean)true) || StringsKt.equals((String)$this$cast$iv, (String)"y", (boolean)true) || Intrinsics.areEqual((Object)$this$cast$iv, (Object)"1");
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                        comparable = StringsKt.toDoubleOrNull((String)$this$cast$iv);
                        if (comparable == null) {
                            comparable = defValue$iv;
                        }
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                        comparable = StringsKt.toFloatOrNull((String)$this$cast$iv);
                        if (comparable == null) {
                            comparable = defValue$iv;
                        }
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                        comparable = StringsKt.toIntOrNull((String)$this$cast$iv);
                        if (comparable == null) {
                            comparable = defValue$iv;
                        }
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                        comparable = StringsKt.toLongOrNull((String)$this$cast$iv);
                        if (comparable == null) {
                            comparable = defValue$iv;
                        }
                    } else {
                        T t;
                        try {
                            boolean $i$f$fromJson = false;
                            Intrinsics.needClassReification();
                            t = JsonUtils.fromJson((String)$this$cast$iv, (TypeToken)new TypeToken<T>(){});
                        }
                        catch (Throwable throwable$iv) {
                            t = defValue$iv;
                        }
                        comparable = t;
                    }
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    object = comparable;
                }
                return object;
            }

            public void setValue(Object thisRef, KProperty<?> property, T value) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                String key = property.getName();
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class)) || Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)) || Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE)) || Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)) || Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) || Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    this.this$0.put(key, value);
                } else {
                    String string;
                    PropertiesUtils propertiesUtils = this.this$0;
                    String string2 = key;
                    T t = value;
                    if (t != null) {
                        T t2 = t;
                        String string3 = string2;
                        PropertiesUtils propertiesUtils2 = propertiesUtils;
                        boolean bl = false;
                        String string4 = JsonUtils.toJson(value);
                        propertiesUtils = propertiesUtils2;
                        string2 = string3;
                        string = string4;
                    } else {
                        string = null;
                    }
                    propertiesUtils.put(string2, string);
                }
            }
        };
    }

    public final /* synthetic */ <T> ReadWriteProperty<Object, T> fieldByKey(String key, T defValue) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        boolean $i$f$fieldByKey = false;
        Intrinsics.needClassReification();
        return new ReadWriteProperty<Object, T>(this, key, defValue){
            final /* synthetic */ PropertiesUtils this$0;
            final /* synthetic */ String $key;
            final /* synthetic */ T $defValue;
            {
                this.this$0 = $receiver;
                this.$key = $key;
                this.$defValue = $defValue;
            }

            /*
             * WARNING - void declaration
             */
            public T getValue(Object thisRef, KProperty<?> property) {
                Object object;
                void $this$cast$iv;
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                String string = this.this$0.getString(this.$key);
                T defValue$iv = this.$defValue;
                boolean $i$f$cast = false;
                if ($this$cast$iv == null) {
                    object = defValue$iv;
                } else {
                    Comparable<Boolean> comparable;
                    Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                    KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
                    if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class))) {
                        comparable = $this$cast$iv;
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE))) {
                        comparable = StringsKt.equals((String)$this$cast$iv, (String)"true", (boolean)true) || StringsKt.equals((String)$this$cast$iv, (String)"yes", (boolean)true) || StringsKt.equals((String)$this$cast$iv, (String)"y", (boolean)true) || Intrinsics.areEqual((Object)$this$cast$iv, (Object)"1");
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE))) {
                        comparable = StringsKt.toDoubleOrNull((String)$this$cast$iv);
                        if (comparable == null) {
                            comparable = defValue$iv;
                        }
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE))) {
                        comparable = StringsKt.toFloatOrNull((String)$this$cast$iv);
                        if (comparable == null) {
                            comparable = defValue$iv;
                        }
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE))) {
                        comparable = StringsKt.toIntOrNull((String)$this$cast$iv);
                        if (comparable == null) {
                            comparable = defValue$iv;
                        }
                    } else if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                        comparable = StringsKt.toLongOrNull((String)$this$cast$iv);
                        if (comparable == null) {
                            comparable = defValue$iv;
                        }
                    } else {
                        T t;
                        try {
                            boolean $i$f$fromJson = false;
                            Intrinsics.needClassReification();
                            t = JsonUtils.fromJson((String)$this$cast$iv, (TypeToken)new TypeToken<T>(){});
                        }
                        catch (Throwable throwable$iv) {
                            t = defValue$iv;
                        }
                        comparable = t;
                    }
                    Intrinsics.reifiedOperationMarker((int)1, (String)"T");
                    object = comparable;
                }
                return object;
            }

            public void setValue(Object thisRef, KProperty<?> property, T value) {
                Intrinsics.checkNotNullParameter((Object)thisRef, (String)"thisRef");
                Intrinsics.checkNotNullParameter(property, (String)"property");
                Intrinsics.reifiedOperationMarker((int)4, (String)"T");
                KClass kClass = Reflection.getOrCreateKotlinClass(Object.class);
                if (Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(String.class)) || Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Boolean.TYPE)) || Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Double.TYPE)) || Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Float.TYPE)) || Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Integer.TYPE)) || Intrinsics.areEqual((Object)kClass, (Object)Reflection.getOrCreateKotlinClass(Long.TYPE))) {
                    this.this$0.put(this.$key, value);
                } else {
                    String string;
                    PropertiesUtils propertiesUtils = this.this$0;
                    String string2 = this.$key;
                    T t = value;
                    if (t != null) {
                        T t2 = t;
                        String string3 = string2;
                        PropertiesUtils propertiesUtils2 = propertiesUtils;
                        boolean bl = false;
                        String string4 = JsonUtils.toJson(value);
                        propertiesUtils = propertiesUtils2;
                        string2 = string3;
                        string = string4;
                    } else {
                        string = null;
                    }
                    propertiesUtils.put(string2, string);
                }
            }
        };
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\b\u0086\u0004\u0018\u00002\u00020\u0001B\u0019\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u001c\u0010\b\u001a\u00060\u0000R\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\u0001J\u0012\u0010\r\u001a\u00060\u0000R\u00020\t2\u0006\u0010\n\u001a\u00020\u000bJ\n\u0010\u000e\u001a\u00060\u0000R\u00020\tJ\u0006\u0010\u000f\u001a\u00020\u0010R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcn/imkarl/core/common/io/file/PropertiesUtils$Editor;", "", "properties", "Ljava/util/Properties;", "file", "Ljava/io/File;", "<init>", "(Lcn/imkarl/core/common/io/file/PropertiesUtils;Ljava/util/Properties;Ljava/io/File;)V", "put", "Lcn/imkarl/core/common/io/file/PropertiesUtils;", "key", "", "value", "remove", "clear", "commit", "", "Common"})
    public final class Editor {
        @NotNull
        private final Properties properties;
        @NotNull
        private final File file;

        public Editor(@NotNull Properties properties, File file) {
            Intrinsics.checkNotNullParameter((Object)properties, (String)"properties");
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            this.properties = properties;
            this.file = file;
        }

        @NotNull
        public final Editor put(@NotNull String key, @Nullable Object value) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (((CharSequence)key).length() == 0) {
                return this;
            }
            if (value == null) {
                return this.remove(key);
            }
            this.properties.setProperty(key, value.toString());
            return this;
        }

        @NotNull
        public final Editor remove(@NotNull String key) {
            Intrinsics.checkNotNullParameter((Object)key, (String)"key");
            if (((CharSequence)key).length() > 0) {
                this.properties.remove(key);
            }
            return this;
        }

        @NotNull
        public final Editor clear() {
            this.properties.clear();
            return this;
        }

        public final void commit() {
            this.properties.store(new OutputStreamWriter((OutputStream)FileExtensionsKt.outputStream$default(this.file, false, 1, null), PropertiesUtils.this.charset), null);
        }
    }
}

