/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.io.file;

import cn.imkarl.core.common.app.AppUtils;
import cn.imkarl.core.common.io.BytesExtensionsKt;
import cn.imkarl.core.common.io.StreamsExtensionsKt;
import cn.imkarl.core.common.log.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import java.util.Iterator;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.collections.ArraysKt;
import kotlin.enums.EnumEntries;
import kotlin.enums.EnumEntriesKt;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.ArrayIteratorKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u000e\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001-B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\n\u001a\u00020\u000b2\b\b\u0002\u0010\f\u001a\u00020\rH\u0007J\b\u0010\u000e\u001a\u00020\u000bH\u0007J\u0012\u0010\u000f\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0007J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0011\u001a\u00020\u0012J\b\u0010\u0015\u001a\u00020\u000bH\u0007J\b\u0010\u0016\u001a\u00020\u000bH\u0007J\b\u0010\u0017\u001a\u00020\u000bH\u0007J\u0010\u0010\u0018\u001a\u00020\u000b2\u0006\u0010\u0019\u001a\u00020\u0012H\u0007J\u0010\u0010\u001a\u001a\u00020\u00052\u0006\u0010\u001b\u001a\u00020\u000bH\u0007J\u0010\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u000bH\u0007J\u0010\u0010\u001e\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u000bH\u0007J\u001a\u0010\u001f\u001a\u00020 2\u0006\u0010!\u001a\u00020\u000b2\b\u0010\"\u001a\u0004\u0018\u00010\u000bH\u0007J\u0012\u0010#\u001a\u00020 2\b\u0010\u001d\u001a\u0004\u0018\u00010\u000bH\u0007J\u0010\u0010$\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u000bH\u0007J\u0010\u0010%\u001a\u00020 2\u0006\u0010\u001b\u001a\u00020\u000bH\u0007J\u0010\u0010&\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u000bH\u0007J\u0018\u0010'\u001a\u00020 2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000bH\u0007J\u0018\u0010*\u001a\u00020 2\u0006\u0010(\u001a\u00020\u000b2\u0006\u0010)\u001a\u00020\u000bH\u0003J\u0018\u0010'\u001a\u00020 2\u0006\u0010+\u001a\u00020\u00102\u0006\u0010)\u001a\u00020\u000bH\u0007J\u0010\u0010,\u001a\u00020\u00122\u0006\u0010\u001a\u001a\u00020\u0005H\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcn/imkarl/core/common/io/file/FileUtils;", "", "<init>", "()V", "FILE_SIZE_KB", "", "FILE_SIZE_MB", "FILE_SIZE_GB", "fileSizeFormat", "Ljava/text/DecimalFormat;", "getClassRootDir", "Ljava/io/File;", "sourceType", "Lcn/imkarl/core/common/io/file/FileUtils$SourceType;", "getResourceRootDir", "getResourceAsStream", "Ljava/io/InputStream;", "filePath", "", "getResource", "Ljava/net/URL;", "getUserHomeDir", "getCurrentDir", "getAppStorageRootDir", "getAbsoluteFile", "path", "size", "file", "getTotalSpace", "dir", "getFreeSpace", "rename", "", "from", "to", "mkdirs", "createNewFile", "deleteFile", "deleteDir", "copy", "source", "target", "copyFile", "stream", "formatSize", "SourceType", "Common"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    private static final long FILE_SIZE_KB = 1024L;
    private static final long FILE_SIZE_MB = 0x100000L;
    private static final long FILE_SIZE_GB = 0x40000000L;
    @NotNull
    private static final DecimalFormat fileSizeFormat = new DecimalFormat("0.00");

    private FileUtils() {
    }

    @JvmStatic
    @NotNull
    public static final File getClassRootDir(@NotNull SourceType sourceType) {
        File file;
        Intrinsics.checkNotNullParameter((Object)((Object)sourceType), (String)"sourceType");
        ClassLoader classLoader = FileUtils.class.getClassLoader();
        if (AppUtils.isJarRun) {
            StackTraceElement[] stackTraceElementArray = new Throwable().getStackTrace();
            Intrinsics.checkNotNullExpressionValue((Object)stackTraceElementArray, (String)"getStackTrace(...)");
            String callClassName = ((StackTraceElement)ArraysKt.last((Object[])stackTraceElementArray)).getClassName();
            String codeSourcePath = FileUtils.class.getClassLoader().loadClass(callClassName).getProtectionDomain().getCodeSource().getLocation().getPath();
            File jarFile = new File(codeSourcePath);
            if (!jarFile.exists()) {
                String string = FileUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
                codeSourcePath = StringsKt.removePrefix((String)string, (CharSequence)"file:");
                jarFile = new File(StringsKt.substringBeforeLast$default((String)codeSourcePath, (String)"!", null, (int)2, null));
                while (!jarFile.exists()) {
                    if (Intrinsics.areEqual((Object)jarFile, (Object)jarFile.getParentFile())) {
                        jarFile = new File(codeSourcePath);
                        break;
                    }
                    jarFile = jarFile.getParentFile();
                }
            }
            return jarFile;
        }
        URL uRL = classLoader.getResource("");
        Intrinsics.checkNotNull((Object)uRL);
        String classRootPath = uRL.getFile();
        switch (WhenMappings.$EnumSwitchMapping$0[sourceType.ordinal()]) {
            case 1: {
                String string = classRootPath;
                Intrinsics.checkNotNull((Object)string);
                if (StringsKt.endsWith$default((String)string, (String)"/build/classes/java/main/", (boolean)false, (int)2, null)) {
                    StringBuilder stringBuilder = new StringBuilder();
                    string = classRootPath;
                    Intrinsics.checkNotNull((Object)string);
                    classRootPath = stringBuilder.append(StringsKt.removeSuffix((String)string, (CharSequence)"java/main/")).append("kotlin/main").toString();
                }
                file = new File(classRootPath);
                break;
            }
            case 2: {
                file = new File(classRootPath, "java/main");
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return file;
    }

    public static /* synthetic */ File getClassRootDir$default(SourceType sourceType, int n, Object object) {
        if ((n & 1) != 0) {
            sourceType = SourceType.Kotlin;
        }
        return FileUtils.getClassRootDir(sourceType);
    }

    @JvmStatic
    @NotNull
    public static final File getResourceRootDir() {
        if (AppUtils.isJarRun) {
            return FileUtils.getClassRootDir$default(null, 1, null);
        }
        String string = FileUtils.getClassRootDir$default(null, 1, null).getAbsolutePath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
        String classRootDir = StringsKt.substringBeforeLast$default((String)string, (String)"/classes", null, (int)2, null);
        File resourceDir = new File(classRootDir, "processedResources/jvm/main");
        if (resourceDir.exists()) {
            return resourceDir;
        }
        resourceDir = new File(classRootDir, "resources/main");
        if (resourceDir.exists()) {
            return resourceDir;
        }
        resourceDir = new File(classRootDir, "resources");
        if (resourceDir.exists()) {
            return resourceDir;
        }
        return new File(classRootDir);
    }

    @JvmStatic
    @Nullable
    public static final InputStream getResourceAsStream(@NotNull String filePath) {
        InputStream inputStream;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        try {
            URL uRL = INSTANCE.getResource(filePath);
            inputStream = uRL != null ? uRL.openStream() : null;
        }
        catch (Throwable throwable) {
            inputStream = null;
        }
        return inputStream;
    }

    @Nullable
    public final URL getResource(@NotNull String filePath) {
        URL uRL;
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        String filePath2 = StringsKt.removePrefix((String)((Object)StringsKt.trim((CharSequence)filePath)).toString(), (CharSequence)"/");
        try {
            URL uRL2;
            if (AppUtils.isJarRun) {
                uRL2 = this.getClass().getClassLoader().getResource(filePath2);
            } else {
                File classResourceDir = FileUtils.getResourceRootDir();
                File file = new File(classResourceDir, filePath2);
                if (!file.exists()) {
                    file = new File(FileUtils.getClassRootDir$default(null, 1, null), "classes");
                }
                uRL2 = file.exists() ? file.toURI().toURL() : null;
            }
            uRL = uRL2;
        }
        catch (Throwable throwable) {
            uRL = null;
        }
        return uRL;
    }

    @JvmStatic
    @NotNull
    public static final File getUserHomeDir() {
        return new File(System.getProperty("user.home"));
    }

    @JvmStatic
    @NotNull
    public static final File getCurrentDir() {
        return new File(System.getProperty("user.dir"));
    }

    @JvmStatic
    @NotNull
    public static final File getAppStorageRootDir() {
        return new File(INSTANCE.getUserHomeDir(), ".AppData/" + StringsKt.removePrefix((String)AppUtils.getPackageName(), (CharSequence)"/"));
    }

    @JvmStatic
    @NotNull
    public static final File getAbsoluteFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String absolutePath = ((Object)StringsKt.trim((CharSequence)path)).toString();
        File file = Intrinsics.areEqual((Object)absolutePath, (Object)"~") ? INSTANCE.getUserHomeDir() : (StringsKt.startsWith$default((String)absolutePath, (String)"~/", (boolean)false, (int)2, null) ? new File(INSTANCE.getUserHomeDir(), StringsKt.removePrefix((String)absolutePath, (CharSequence)"~/")) : (StringsKt.startsWith$default((String)absolutePath, (String)"~\\", (boolean)false, (int)2, null) ? new File(INSTANCE.getUserHomeDir(), StringsKt.removePrefix((String)absolutePath, (CharSequence)"~\\")) : (Intrinsics.areEqual((Object)absolutePath, (Object)".") ? INSTANCE.getCurrentDir() : (StringsKt.startsWith$default((String)absolutePath, (String)"./", (boolean)false, (int)2, null) ? new File(INSTANCE.getCurrentDir(), StringsKt.removePrefix((String)absolutePath, (CharSequence)"./")) : (StringsKt.startsWith$default((String)absolutePath, (String)".\\", (boolean)false, (int)2, null) ? new File(INSTANCE.getCurrentDir(), StringsKt.removePrefix((String)absolutePath, (CharSequence)".\\")) : (!StringsKt.startsWith$default((String)absolutePath, (String)"/", (boolean)false, (int)2, null) ? new File(INSTANCE.getCurrentDir(), absolutePath) : new File(absolutePath)))))));
        File file2 = file.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAbsoluteFile(...)");
        return file2;
    }

    @JvmStatic
    public static final long size(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists()) {
            return 0L;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return 0L;
            }
            File[] children = fileArray;
            long sum = 0L;
            for (File child : children) {
                Intrinsics.checkNotNull((Object)child);
                sum += FileUtils.size(child);
            }
            return sum;
        }
        return file.length();
    }

    @JvmStatic
    public static final long getTotalSpace(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return dir.exists() ? dir.getTotalSpace() : 0L;
    }

    @JvmStatic
    public static final long getFreeSpace(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return dir.exists() ? dir.getFreeSpace() : 0L;
    }

    @JvmStatic
    public static final boolean rename(@NotNull File from, @Nullable File to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (!from.exists()) {
            LogUtils.w("File not found, 'from' is: " + from);
            return false;
        }
        if (to == null) {
            LogUtils.w("File not found, 'to' is: " + to);
            return false;
        }
        FileUtils.deleteFile(to);
        return from.renameTo(to);
    }

    @JvmStatic
    public static final boolean mkdirs(@Nullable File dir) {
        if (dir == null) {
            return false;
        }
        return dir.exists() ? dir.isDirectory() : dir.mkdirs() || dir.isDirectory();
    }

    @JvmStatic
    public static final boolean createNewFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.exists() && file.isFile()) {
            FileUtils.deleteFile(file);
        }
        try {
            if (!FileUtils.mkdirs(file.getParentFile())) {
                LogUtils.w("mkdirs 'NewFile' parent failed: " + file.getParentFile().getAbsolutePath());
                return false;
            }
            return file.createNewFile();
        }
        catch (IOException e) {
            LogUtils.w(e);
            return false;
        }
    }

    @JvmStatic
    public static final boolean deleteFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists()) {
            return true;
        }
        if (!file.isFile()) {
            LogUtils.w("deleteFile 'file' is not a file");
            return true;
        }
        return file.delete() || !file.exists();
    }

    @JvmStatic
    public static final boolean deleteDir(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.exists()) {
            LogUtils.w("deleteDir 'dir' not exist: " + dir);
            return true;
        }
        if (!dir.isDirectory()) {
            LogUtils.w("deleteDir 'dir' is not a directory");
            return true;
        }
        Object[] files = dir.listFiles();
        if (files == null) {
            LogUtils.w("deleteDir 'dir' not a readable directory: " + dir);
            return false;
        }
        Iterator iterator = ArrayIteratorKt.iterator((Object[])files);
        while (iterator.hasNext()) {
            File file = (File)iterator.next();
            boolean delete = false;
            if (file.isDirectory()) {
                Intrinsics.checkNotNull((Object)file);
                delete = FileUtils.deleteDir(file);
            } else {
                Intrinsics.checkNotNull((Object)file);
                delete = FileUtils.deleteFile(file);
            }
            if (delete) continue;
            LogUtils.w("delete failed : " + (file.isDirectory() ? "dir " : "file ") + file);
            return false;
        }
        return dir.delete() || !dir.exists();
    }

    @JvmStatic
    public static final boolean copy(@NotNull File source, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!source.exists()) {
            LogUtils.w("copy source not exists : " + source + " to " + target);
            return true;
        }
        if (source.isDirectory()) {
            boolean mkdir = FileUtils.mkdirs(target);
            if (!mkdir) {
                LogUtils.w("mkdir dir failed : " + target);
                return false;
            }
            Object[] childs = source.listFiles();
            if (childs == null) {
                LogUtils.w("copy source not a readable directory: " + source);
                return false;
            }
            if (childs.length == 0) {
                return true;
            }
            Iterator iterator = ArrayIteratorKt.iterator((Object[])childs);
            while (iterator.hasNext()) {
                File child = (File)iterator.next();
                Intrinsics.checkNotNull((Object)child);
                boolean copy = FileUtils.copy(child, new File(target, child.getName()));
                if (copy) continue;
                LogUtils.w("copy failed : " + source + " to " + target);
                return false;
            }
            return true;
        }
        if (source.isFile()) {
            File targetTempFile = new File(target.getParentFile(), target.getName() + "" + System.currentTimeMillis());
            if (!FileUtils.copyFile(source, targetTempFile)) {
                LogUtils.w("copy failed : " + source + " to " + target);
                return false;
            }
            return FileUtils.rename(targetTempFile, target);
        }
        LogUtils.w("copy source failed : " + source.getPath());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    private static final boolean copyFile(File source, File target) {
        if (!source.exists()) {
            LogUtils.i("copyFile source not exists : " + source + " to " + target);
            return true;
        }
        if (source.length() == 0L) {
            return FileUtils.createNewFile(target);
        }
        boolean mkdir = FileUtils.mkdirs(target.getParentFile());
        if (!mkdir) {
            LogUtils.w("mkdir dir failed : " + target.getParentFile());
            return false;
        }
        boolean result = false;
        FileChannel fileChannel = null;
        FileChannel out = null;
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(source);
            outStream = new FileOutputStream(target);
            fileChannel = inStream.getChannel();
            out = outStream.getChannel();
            FileChannel fileChannel2 = fileChannel;
            Intrinsics.checkNotNull((Object)fileChannel2);
            long length = fileChannel2.transferTo(0L, fileChannel.size(), out);
            if (length >= 0L) {
                result = true;
            } else {
                LogUtils.w("copyFile transferTo failed : " + source + " to " + target);
                result = false;
            }
        }
        catch (IOException e) {
            LogUtils.w(e);
        }
        finally {
            StreamsExtensionsKt.closeQuietly(fileChannel);
            StreamsExtensionsKt.closeQuietly(out);
            StreamsExtensionsKt.closeQuietly(inStream);
            StreamsExtensionsKt.closeQuietly(outStream);
        }
        if (!result) {
            target.delete();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean copy(@NotNull InputStream stream, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean mkdir = FileUtils.mkdirs(target.getParentFile());
        if (!mkdir) {
            return false;
        }
        boolean result = false;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(target);
            ByteStreamsKt.copyTo$default((InputStream)stream, (OutputStream)fos, (int)0, (int)2, null);
            result = true;
        }
        catch (IOException e) {
            LogUtils.e(e);
        }
        finally {
            StreamsExtensionsKt.closeQuietly(fos);
        }
        if (!result) {
            target.delete();
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static final String formatSize(long size) {
        if (size > BytesExtensionsKt.getGBytes(1.2)) {
            return fileSizeFormat.format((double)size * 100.0 / (double)BytesExtensionsKt.getGBytes(1) * 0.01) + "GB";
        }
        if (size > BytesExtensionsKt.getMBytes(1.2)) {
            return fileSizeFormat.format((double)size * 100.0 / (double)BytesExtensionsKt.getMBytes(1) * 0.01) + "MB";
        }
        if (size > BytesExtensionsKt.getKBytes(1)) {
            return fileSizeFormat.format((double)size * 100.0 / (double)BytesExtensionsKt.getKBytes(1) * 0.01) + "KB";
        }
        return "" + size + 'B';
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0005\b\u0086\u0081\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003j\u0002\b\u0004j\u0002\b\u0005\u00a8\u0006\u0006"}, d2={"Lcn/imkarl/core/common/io/file/FileUtils$SourceType;", "", "<init>", "(Ljava/lang/String;I)V", "Java", "Kotlin", "Common"})
    public static final class SourceType
    extends Enum<SourceType> {
        public static final /* enum */ SourceType Java = new SourceType();
        public static final /* enum */ SourceType Kotlin = new SourceType();
        private static final /* synthetic */ SourceType[] $VALUES;
        private static final /* synthetic */ EnumEntries $ENTRIES;

        public static SourceType[] values() {
            return (SourceType[])$VALUES.clone();
        }

        public static SourceType valueOf(String value) {
            return Enum.valueOf(SourceType.class, value);
        }

        @NotNull
        public static EnumEntries<SourceType> getEntries() {
            return $ENTRIES;
        }

        static {
            $VALUES = sourceTypeArray = new SourceType[]{SourceType.Java, SourceType.Kotlin};
            $ENTRIES = EnumEntriesKt.enumEntries((Enum[])$VALUES);
        }
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceType.values().length];
            try {
                nArray[SourceType.Kotlin.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[SourceType.Java.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

