/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.io.file;

import cn.imkarl.core.common.security.EncryptExtensionsKt;
import cn.imkarl.core.common.security.EncryptUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileTime;
import kotlin.Metadata;
import kotlin.io.FilesKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000,\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\t\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\r\u001a\u00020\u000e*\u00020\u0002\u001a\n\u0010\u000f\u001a\u00020\u0010*\u00020\u0002\u001a\n\u0010\u0011\u001a\u00020\u0010*\u00020\u0002\u001a\u0014\u0010\u0012\u001a\u00020\u0013*\u00020\u00022\b\b\u0002\u0010\u0014\u001a\u00020\u0001\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\"\u0017\u0010\t\u001a\u0004\u0018\u00010\n*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0015"}, d2={"isLinkFile", "", "Ljava/io/File;", "(Ljava/io/File;)Z", "isLinkDirectory", "isLink", "linkTargetFile", "getLinkTargetFile", "(Ljava/io/File;)Ljava/io/File;", "attributes", "Ljava/nio/file/attribute/BasicFileAttributes;", "getAttributes", "(Ljava/io/File;)Ljava/nio/file/attribute/BasicFileAttributes;", "creationTime", "", "sha1", "", "md5", "outputStream", "Ljava/io/FileOutputStream;", "append", "Common"})
public final class FileExtensionsKt {
    public static final boolean isLinkFile(@NotNull File $this$isLinkFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkFile, (String)"<this>");
        if (!FileExtensionsKt.isLink($this$isLinkFile)) {
            return false;
        }
        return !Files.isDirectory($this$isLinkFile.toPath(), new LinkOption[0]) && $this$isLinkFile.exists();
    }

    public static final boolean isLinkDirectory(@NotNull File $this$isLinkDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkDirectory, (String)"<this>");
        if (!FileExtensionsKt.isLink($this$isLinkDirectory)) {
            return false;
        }
        return Files.isDirectory($this$isLinkDirectory.toPath(), new LinkOption[0]);
    }

    public static final boolean isLink(@NotNull File $this$isLink) {
        Intrinsics.checkNotNullParameter((Object)$this$isLink, (String)"<this>");
        return Files.isSymbolicLink($this$isLink.toPath());
    }

    @NotNull
    public static final File getLinkTargetFile(@NotNull File $this$linkTargetFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$linkTargetFile, (String)"<this>");
        if (FileExtensionsKt.isLinkDirectory($this$linkTargetFile)) {
            File file2 = $this$linkTargetFile.getAbsoluteFile();
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"getAbsoluteFile(...)");
        } else if (FileExtensionsKt.isLinkFile($this$linkTargetFile)) {
            File file3 = $this$linkTargetFile.getCanonicalFile();
            file = file3;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"getCanonicalFile(...)");
        } else {
            file = $this$linkTargetFile;
        }
        return file;
    }

    @Nullable
    public static final BasicFileAttributes getAttributes(@NotNull File $this$attributes) {
        BasicFileAttributes basicFileAttributes;
        Intrinsics.checkNotNullParameter((Object)$this$attributes, (String)"<this>");
        try {
            basicFileAttributes = Files.readAttributes($this$attributes.toPath(), BasicFileAttributes.class, new LinkOption[0]);
        }
        catch (Throwable throwable) {
            basicFileAttributes = null;
        }
        return basicFileAttributes;
    }

    public static final long creationTime(@NotNull File $this$creationTime) {
        Intrinsics.checkNotNullParameter((Object)$this$creationTime, (String)"<this>");
        Object object = FileExtensionsKt.getAttributes($this$creationTime);
        return object != null && (object = object.creationTime()) != null ? ((FileTime)object).toMillis() : -1L;
    }

    @NotNull
    public static final String sha1(@NotNull File $this$sha1) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$sha1, (String)"<this>");
        if ($this$sha1.isDirectory() || FileExtensionsKt.isLinkDirectory($this$sha1) || !$this$sha1.exists() || !$this$sha1.canRead()) {
            return "";
        }
        try {
            string = EncryptExtensionsKt.sha1(FilesKt.readBytes((File)$this$sha1));
        }
        catch (Throwable throwable) {
            string = "";
        }
        return string;
    }

    @NotNull
    public static final String md5(@NotNull File $this$md5) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$md5, (String)"<this>");
        if ($this$md5.isDirectory() || FileExtensionsKt.isLinkDirectory($this$md5) || !$this$md5.exists() || !$this$md5.canRead()) {
            return "";
        }
        try {
            String string2 = EncryptUtils.INSTANCE.md5($this$md5);
            Intrinsics.checkNotNull((Object)string2);
            string = string2;
        }
        catch (Throwable throwable) {
            string = "";
        }
        return string;
    }

    @NotNull
    public static final FileOutputStream outputStream(@NotNull File $this$outputStream, boolean append) {
        Intrinsics.checkNotNullParameter((Object)$this$outputStream, (String)"<this>");
        return new FileOutputStream($this$outputStream, append);
    }

    public static /* synthetic */ FileOutputStream outputStream$default(File file, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = false;
        }
        return FileExtensionsKt.outputStream(file, bl);
    }
}

