/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.io.compress;

import cn.imkarl.core.common.io.StreamsExtensionsKt;
import cn.imkarl.core.common.io.compress.ZipOutputStream;
import cn.imkarl.core.common.io.file.FileUtils;
import java.io.Closeable;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.zip.ZipEntry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000J\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0011\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u001b\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0004\b\u0004\u0010\nJ'\u0010\r\u001a\u00020\u00002\u0006\u0010\u000e\u001a\u00020\u00072\u0012\u0010\u000f\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00070\u0010\"\u00020\u0007\u00a2\u0006\u0002\u0010\u0011J\"\u0010\r\u001a\u00020\u00002\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00072\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u0016J\u001a\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0018\u001a\u00020\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0007H\u0002J\u001a\u0010\u0017\u001a\u00020\u00002\u0006\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u0002J\b\u0010\u001d\u001a\u00020\u001eH\u0016R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001f"}, d2={"Lcn/imkarl/core/common/io/compress/ZipWriter;", "Ljava/io/Closeable;", "out", "Lcn/imkarl/core/common/io/compress/ZipOutputStream;", "<init>", "(Lcn/imkarl/core/common/io/compress/ZipOutputStream;)V", "zipFile", "Ljava/io/File;", "charset", "Ljava/nio/charset/Charset;", "(Ljava/io/File;Ljava/nio/charset/Charset;)V", "getOut", "()Lcn/imkarl/core/common/io/compress/ZipOutputStream;", "write", "srcRootDir", "files", "", "(Ljava/io/File;[Ljava/io/File;)Lcn/imkarl/core/common/io/compress/ZipWriter;", "subPath", "", "file", "filter", "Ljava/io/FileFilter;", "putEntry", "path", "entry", "Ljava/util/zip/ZipEntry;", "stream", "Ljava/io/InputStream;", "close", "", "Common"})
@SourceDebugExtension(value={"SMAP\nZipWriter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipWriter.kt\ncn/imkarl/core/common/io/compress/ZipWriter\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,130:1\n13409#2,2:131\n13409#2,2:133\n*S KotlinDebug\n*F\n+ 1 ZipWriter.kt\ncn/imkarl/core/common/io/compress/ZipWriter\n*L\n32#1:131,2\n62#1:133,2\n*E\n"})
public final class ZipWriter
implements Closeable {
    @NotNull
    private final ZipOutputStream out;
    @Nullable
    private File zipFile;

    public ZipWriter(@NotNull ZipOutputStream out) {
        Intrinsics.checkNotNullParameter((Object)out, (String)"out");
        this.out = out;
    }

    @NotNull
    public final ZipOutputStream getOut() {
        return this.out;
    }

    public ZipWriter(@NotNull File zipFile, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this(new ZipOutputStream(new FileOutputStream(zipFile)));
        this.zipFile = zipFile;
        this.out.setEncoding(charset.name());
    }

    public /* synthetic */ ZipWriter(File file, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(file, charset);
    }

    @NotNull
    public final ZipWriter write(@NotNull File srcRootDir, File ... files) {
        Intrinsics.checkNotNullParameter((Object)srcRootDir, (String)"srcRootDir");
        Intrinsics.checkNotNullParameter((Object)files, (String)"files");
        String rootPath = srcRootDir.getCanonicalFile().getAbsolutePath();
        File[] $this$forEach$iv = files;
        boolean $i$f$forEach = false;
        int n = $this$forEach$iv.length;
        for (int i = 0; i < n; ++i) {
            File element$iv;
            File file = element$iv = $this$forEach$iv[i];
            boolean bl = false;
            String string = file.getCanonicalFile().getAbsolutePath();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getAbsolutePath(...)");
            String subPath = StringsKt.removeSuffix((String)string, (CharSequence)"/");
            Intrinsics.checkNotNull((Object)rootPath);
            subPath = StringsKt.removePrefix((String)StringsKt.removePrefix((String)subPath, (CharSequence)StringsKt.removeSuffix((String)rootPath, (CharSequence)"/")), (CharSequence)"/");
            ZipWriter.write$default(this, "", file, null, 4, null);
        }
        return this;
    }

    @NotNull
    public final ZipWriter write(@NotNull String subPath, @NotNull File file, @Nullable FileFilter filter) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)subPath, (String)"subPath");
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (filter != null && !filter.accept(file)) {
            return this;
        }
        if (file.isDirectory()) {
            File[] files = file.listFiles();
            Intrinsics.checkNotNull((Object)files);
            if (files.length == 0) {
                object = this.putEntry(StringsKt.removePrefix((String)(StringsKt.removePrefix((String)subPath, (CharSequence)"/") + '/' + file.getName() + '/'), (CharSequence)"/"), null);
            } else {
                File[] $this$forEach$iv = files;
                boolean $i$f$forEach = false;
                int n = $this$forEach$iv.length;
                for (int i = 0; i < n; ++i) {
                    File element$iv;
                    File childFile = element$iv = $this$forEach$iv[i];
                    boolean bl = false;
                    String string = StringsKt.removePrefix((String)subPath, (CharSequence)"/") + '/' + file.getName();
                    Intrinsics.checkNotNull((Object)childFile);
                    this.write(string, childFile, filter);
                }
                object = Unit.INSTANCE;
            }
        } else {
            if (Intrinsics.areEqual((Object)this.zipFile, (Object)file)) {
                return this;
            }
            object = this.putEntry(StringsKt.removePrefix((String)(StringsKt.removePrefix((String)subPath, (CharSequence)"/") + '/' + file.getName()), (CharSequence)"/"), file);
        }
        return this;
    }

    public static /* synthetic */ ZipWriter write$default(ZipWriter zipWriter, String string, File file, FileFilter fileFilter, int n, Object object) {
        if ((n & 4) != 0) {
            fileFilter = null;
        }
        return zipWriter.write(string, file, fileFilter);
    }

    private final ZipWriter putEntry(String path, File file) {
        String string = File.separator;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"separator");
        String entryName = StringsKt.removeSuffix((String)path, (CharSequence)string);
        if (file == null || StringsKt.endsWith$default((String)path, (String)"/", (boolean)false, (int)2, null)) {
            entryName = entryName + File.separator;
        }
        ZipEntry entry = new ZipEntry("\u6d4b\u8bd5" + entryName);
        if (file != null) {
            entry.setTime(file.lastModified());
            entry.setSize(FileUtils.size(file));
        } else {
            entry.setTime(System.currentTimeMillis());
            entry.setSize(0L);
        }
        this.putEntry(entry, file != null ? new FileInputStream(file) : null);
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final ZipWriter putEntry(ZipEntry entry, InputStream stream) {
        try {
            this.out.putNextEntry(entry);
            InputStream inputStream = stream;
            if (inputStream != null) {
                ByteStreamsKt.copyTo$default((InputStream)inputStream, (OutputStream)this.out, (int)0, (int)2, null);
            }
            this.out.closeEntry();
        }
        finally {
            StreamsExtensionsKt.closeQuietly(stream);
        }
        this.out.flush();
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.out.flush();
        }
        finally {
            StreamsExtensionsKt.closeQuietly(this.out);
        }
    }
}

