/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.io.compress;

import cn.imkarl.core.common.io.LimitedInputStream;
import cn.imkarl.core.common.io.StreamsExtensionsKt;
import cn.imkarl.core.common.io.file.FileUtils;
import cn.imkarl.core.common.platform.Platform;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterInputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.ByteStreamsKt;
import kotlin.io.CloseableKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0007\u0018\u0000 -2\u00020\u0001:\u0001-B\u001b\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007B\u0011\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\b\u00a2\u0006\u0004\b\u0006\u0010\tB\u001b\b\u0016\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\fB\u0011\b\u0016\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0006\u0010\u000fJ\u000e\u0010\u0012\u001a\u00020\u00002\u0006\u0010\u0010\u001a\u00020\u0011J\u0010\u0010\u0013\u001a\u0004\u0018\u00010\u000b2\u0006\u0010\u0014\u001a\u00020\u0015J(\u0010\u0016\u001a\u0004\u0018\u00010\u00032\u0006\u0010\u0017\u001a\u00020\u00032\u0016\b\u0002\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020\u001b\u0018\u00010\u0019J\u000e\u0010\u001c\u001a\u00020\u001b2\u0006\u0010\u0017\u001a\u00020\u0003J\u0018\u0010\u001d\u001a\u00020\u00032\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\u0014\u001a\u00020\u0015H\u0002J\u0018\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020\u00032\u0006\u0010\u001d\u001a\u00020\u0003H\u0002J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\u00032\u0006\u0010\"\u001a\u00020\u0003H\u0002J\u0018\u0010!\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020#2\u0006\u0010\"\u001a\u00020#H\u0002J\u0010\u0010$\u001a\u00020#2\u0006\u0010\u0014\u001a\u00020#H\u0002J\u001a\u0010%\u001a\u00020\u00002\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020'0\u0019J\b\u0010(\u001a\u00020'H\u0016J\u001c\u0010)\u001a\u00020'2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020'0\u0019H\u0002J\u001c\u0010*\u001a\u00020'2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u001a\u0012\u0004\u0012\u00020'0\u0019H\u0002J\u0014\u0010+\u001a\u0004\u0018\u00010\u001a2\b\u0010,\u001a\u0004\u0018\u00010\u001aH\u0002R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006."}, d2={"Lcn/imkarl/core/common/io/compress/ZipReader;", "Ljava/io/Closeable;", "zipFile", "Ljava/io/File;", "charset", "Ljava/nio/charset/Charset;", "<init>", "(Ljava/io/File;Ljava/nio/charset/Charset;)V", "Ljava/util/zip/ZipFile;", "(Ljava/util/zip/ZipFile;)V", "in", "Ljava/io/InputStream;", "(Ljava/io/InputStream;Ljava/nio/charset/Charset;)V", "zin", "Ljava/util/zip/ZipInputStream;", "(Ljava/util/zip/ZipInputStream;)V", "maxSizeDiff", "", "setMaxSizeDiff", "get", "path", "", "readTo", "outFile", "entryFilter", "Lkotlin/Function1;", "Ljava/util/zip/ZipEntry;", "", "unzip", "file", "parent", "checkSlip", "parentFile", "isSub", "sub", "Ljava/nio/file/Path;", "toAbsNormal", "read", "consumer", "", "close", "readFromZipFile", "readFromStream", "checkZipBomb", "entry", "Companion", "Common"})
@SourceDebugExtension(value={"SMAP\nZipReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ZipReader.kt\ncn/imkarl/core/common/io/compress/ZipReader\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,328:1\n1#2:329\n*E\n"})
public final class ZipReader
implements Closeable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ZipFile zipFile;
    @Nullable
    private ZipInputStream in;
    private int maxSizeDiff;
    private static final int DEFAULT_MAX_SIZE_DIFF = 100;

    public ZipReader(@NotNull File zipFile, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.maxSizeDiff = 100;
        this.zipFile = new ZipFile(zipFile, charset);
    }

    public /* synthetic */ ZipReader(File file, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(file, charset);
    }

    public ZipReader(@NotNull ZipFile zipFile) {
        Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
        this.maxSizeDiff = 100;
        this.zipFile = zipFile;
    }

    public ZipReader(@NotNull InputStream in, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)in, (String)"in");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        this.maxSizeDiff = 100;
        this.in = new ZipInputStream(in, charset);
    }

    public /* synthetic */ ZipReader(InputStream inputStream, Charset charset, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            charset = Charsets.UTF_8;
        }
        this(inputStream, charset);
    }

    public ZipReader(@NotNull ZipInputStream zin) {
        Intrinsics.checkNotNullParameter((Object)zin, (String)"zin");
        this.maxSizeDiff = 100;
        this.in = zin;
    }

    @NotNull
    public final ZipReader setMaxSizeDiff(int maxSizeDiff) {
        this.maxSizeDiff = maxSizeDiff;
        return this;
    }

    @Nullable
    public final InputStream get(@NotNull String path) {
        block4: {
            Intrinsics.checkNotNullParameter((Object)path, (String)"path");
            if (this.zipFile != null) {
                ZipFile zipFile;
                ZipFile zipFile2 = zipFile = this.zipFile;
                Intrinsics.checkNotNull((Object)zipFile2);
                ZipEntry entry = zipFile2.getEntry(path);
                if (entry != null) {
                    InputStream inputStream = zipFile.getInputStream(entry);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    return new LimitedInputStream(inputStream, entry.getSize());
                }
            } else {
                ZipEntry zipEntry;
                ZipEntry zipEntry2 = null;
                do {
                    ZipEntry zipEntry3;
                    ZipInputStream zipInputStream = this.in;
                    Intrinsics.checkNotNull((Object)zipInputStream);
                    ZipEntry it = zipEntry3 = zipInputStream.getNextEntry();
                    boolean bl = false;
                    zipEntry2 = it;
                    if (zipEntry3 == null) break block4;
                    zipEntry = zipEntry2;
                    Intrinsics.checkNotNull((Object)zipEntry);
                } while (!Intrinsics.areEqual((Object)zipEntry.getName(), (Object)path));
                return this.in;
            }
        }
        return null;
    }

    @Nullable
    public final File readTo(@NotNull File outFile, @Nullable Function1<? super ZipEntry, Boolean> entryFilter) {
        Intrinsics.checkNotNullParameter((Object)outFile, (String)"outFile");
        this.read((Function1<? super ZipEntry, Unit>)((Function1)arg_0 -> ZipReader.readTo$lambda$2(entryFilter, this, outFile, arg_0)));
        return outFile;
    }

    public static /* synthetic */ File readTo$default(ZipReader zipReader, File file, Function1 function1, int n, Object object) {
        if ((n & 2) != 0) {
            function1 = null;
        }
        return zipReader.readTo(file, (Function1<? super ZipEntry, Boolean>)function1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean unzip(@NotNull File outFile) {
        Intrinsics.checkNotNullParameter((Object)outFile, (String)"outFile");
        if (outFile.exists() && outFile.isFile()) {
            throw new IllegalArgumentException("Target path [" + outFile.getAbsolutePath() + "] exist!");
        }
        try {
            ZipReader.readTo$default(this, outFile, null, 2, null);
            boolean bl = true;
            return bl;
        }
        finally {
            StreamsExtensionsKt.closeQuietly(this);
        }
    }

    private final File file(File parent, String path) {
        if (StringsKt.isBlank((CharSequence)path)) {
            throw new NullPointerException("File path is blank!");
        }
        return this.checkSlip(parent, new File(parent, path));
    }

    private final File checkSlip(File parentFile, File file) {
        if (!this.isSub(parentFile, file)) {
            throw new IllegalArgumentException("New file is outside of the parent dir: " + file.getName());
        }
        return file;
    }

    private final boolean isSub(File parent, File sub) {
        Path path = parent.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"toPath(...)");
        Path path2 = sub.toPath();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"toPath(...)");
        return this.isSub(path, path2);
    }

    private final boolean isSub(Path parent, Path sub) {
        return this.toAbsNormal(sub).startsWith(this.toAbsNormal(parent));
    }

    private final Path toAbsNormal(Path path) {
        Path path2 = path.toAbsolutePath().normalize();
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"normalize(...)");
        return path2;
    }

    @NotNull
    public final ZipReader read(@NotNull Function1<? super ZipEntry, Unit> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        if (this.zipFile != null) {
            this.readFromZipFile(consumer);
        } else {
            this.readFromStream(consumer);
        }
        return this;
    }

    @Override
    public void close() {
        block1: {
            block0: {
                if (this.zipFile == null) break block0;
                ZipFile zipFile = this.zipFile;
                if (zipFile == null) break block1;
                StreamsExtensionsKt.closeQuietly(zipFile);
                break block1;
            }
            ZipInputStream zipInputStream = this.in;
            if (zipInputStream == null) break block1;
            StreamsExtensionsKt.closeQuietly(zipInputStream);
        }
    }

    private final void readFromZipFile(Function1<? super ZipEntry, Unit> consumer) {
        ZipFile zipFile = this.zipFile;
        Intrinsics.checkNotNull((Object)zipFile);
        Enumeration<? extends ZipEntry> em = zipFile.entries();
        while (em.hasMoreElements()) {
            ZipEntry it;
            if (this.checkZipBomb(em.nextElement()) == null) continue;
            boolean bl = false;
            consumer.invoke((Object)it);
        }
    }

    private final void readFromStream(Function1<? super ZipEntry, Unit> consumer) {
        ZipEntry zipEntry = null;
        while (true) {
            ZipEntry zipEntry2;
            ZipInputStream zipInputStream = this.in;
            Intrinsics.checkNotNull((Object)zipInputStream);
            ZipEntry it = zipEntry2 = zipInputStream.getNextEntry();
            boolean bl = false;
            zipEntry = it;
            if (zipEntry2 == null) break;
            if (zipEntry != null) {
                ZipEntry it2;
                boolean bl2 = false;
                consumer.invoke((Object)it2);
            }
            this.checkZipBomb(zipEntry);
        }
    }

    private final ZipEntry checkZipBomb(ZipEntry entry) {
        if (entry == null) {
            return null;
        }
        if (this.maxSizeDiff < 0 || entry.isDirectory()) {
            return entry;
        }
        long compressedSize = entry.getCompressedSize();
        long uncompressedSize = entry.getSize();
        if (compressedSize < 0L || uncompressedSize < 0L || compressedSize * (long)this.maxSizeDiff < uncompressedSize) {
            throw new IllegalStateException("Zip bomb attack detected, invalid sizes: compressed " + compressedSize + ", uncompressed " + uncompressedSize + ", name " + entry.getName());
        }
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Unit readTo$lambda$2(Function1 $entryFilter, ZipReader this$0, File $outFile, ZipEntry zipEntry) {
        Intrinsics.checkNotNullParameter((Object)zipEntry, (String)"zipEntry");
        if ($entryFilter == null || ((Boolean)$entryFilter.invoke((Object)zipEntry)).booleanValue()) {
            String path = zipEntry.getName();
            if (Platform.Companion.getOsType() == Platform.OSType.WINDOWS) {
                String string = path;
                Intrinsics.checkNotNull((Object)string);
                path = StringsKt.replace$default((String)string, (String)"*", (String)"_", (boolean)false, (int)4, null);
            }
            String string = path;
            Intrinsics.checkNotNull((Object)string);
            File outItemFile = this$0.file($outFile, string);
            if (zipEntry.isDirectory()) {
                outItemFile.mkdirs();
            } else {
                InputStream in = null;
                if (this$0.zipFile != null) {
                    ZipFile zipFile = this$0.zipFile;
                    Intrinsics.checkNotNull((Object)zipFile);
                    InputStream inputStream = zipFile.getInputStream(zipEntry);
                    Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getInputStream(...)");
                    in = new LimitedInputStream(inputStream, zipEntry.getSize());
                } else {
                    in = this$0.in;
                }
                FileUtils.createNewFile(outItemFile);
                Closeable closeable = new FileOutputStream(outItemFile);
                Throwable throwable = null;
                try {
                    FileOutputStream it = (FileOutputStream)closeable;
                    boolean bl = false;
                    FilterInputStream filterInputStream = (FilterInputStream)in;
                    if (filterInputStream != null) {
                        ByteStreamsKt.copyTo$default((InputStream)filterInputStream, (OutputStream)it, (int)0, (int)2, null);
                    }
                    Unit unit = Unit.INSTANCE;
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
                finally {
                    CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
                }
            }
        }
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\b\u0002\u0010\n\u001a\u00020\u000bJ\u0018\u0010\u0006\u001a\u00020\u00072\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\n\u001a\u00020\u000bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcn/imkarl/core/common/io/compress/ZipReader$Companion;", "", "<init>", "()V", "DEFAULT_MAX_SIZE_DIFF", "", "of", "Lcn/imkarl/core/common/io/compress/ZipReader;", "zipFile", "Ljava/io/File;", "charset", "Ljava/nio/charset/Charset;", "stream", "Ljava/io/InputStream;", "Common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ZipReader of(@NotNull File zipFile, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)zipFile, (String)"zipFile");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return new ZipReader(zipFile, charset);
        }

        public static /* synthetic */ ZipReader of$default(Companion companion, File file, Charset charset, int n, Object object) {
            if ((n & 2) != 0) {
                charset = Charsets.UTF_8;
            }
            return companion.of(file, charset);
        }

        @NotNull
        public final ZipReader of(@NotNull InputStream stream, @NotNull Charset charset) {
            Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
            Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
            return new ZipReader(stream, charset);
        }

        public static /* synthetic */ ZipReader of$default(Companion companion, InputStream inputStream, Charset charset, int n, Object object) {
            if ((n & 2) != 0) {
                charset = Charsets.UTF_8;
            }
            return companion.of(inputStream, charset);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

