/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.io.compress;

import cn.imkarl.core.common.io.compress.ZipLong;
import cn.imkarl.core.common.io.compress.ZipOutputStreamKt;
import cn.imkarl.core.common.io.compress.ZipShort;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.RandomAccessFile;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Date;
import java.util.Hashtable;
import java.util.Vector;
import java.util.zip.CRC32;
import java.util.zip.Deflater;
import java.util.zip.ZipEntry;
import java.util.zip.ZipException;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000x\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0017\u0018\u0000 K2\u00020\u0001:\u0001KB\u0013\b\u0016\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005B\u0011\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\u0004\u0010\bJ\u0006\u00104\u001a\u000205J\u0006\u00106\u001a\u000205J\u0010\u00107\u001a\u0002052\b\u00108\u001a\u0004\u0018\u00010\nJ\u000e\u00109\u001a\u0002052\u0006\u0010\u000b\u001a\u00020\fJ\u000e\u0010:\u001a\u0002052\u0006\u0010\r\u001a\u00020\u000eJ\u000e\u0010;\u001a\u0002052\u0006\u0010\u0011\u001a\u00020\u000eJ \u0010<\u001a\u0002052\u0006\u0010=\u001a\u00020+2\u0006\u0010>\u001a\u00020\u000e2\u0006\u0010?\u001a\u00020\u000eH\u0016J\u0010\u0010<\u001a\u0002052\u0006\u0010=\u001a\u00020\u000eH\u0016J\b\u0010@\u001a\u000205H\u0016J\b\u0010A\u001a\u000205H\u0016J\b\u0010B\u001a\u000205H\u0004J\u0010\u0010C\u001a\u0002052\u0006\u00108\u001a\u00020\nH\u0004J\u0010\u0010D\u001a\u0002052\u0006\u00108\u001a\u00020\nH\u0004J\u0010\u0010E\u001a\u0002052\u0006\u00108\u001a\u00020\nH\u0004J\b\u0010F\u001a\u000205H\u0004J\u0010\u0010G\u001a\u00020+2\u0006\u0010H\u001a\u00020\fH\u0004J$\u0010I\u001a\u0002052\u0006\u0010J\u001a\u00020+2\b\b\u0002\u0010>\u001a\u00020\u000e2\b\b\u0002\u0010?\u001a\u00020\u000eH\u0004R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000f\u001a\u00020\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u000eX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\n0\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0019\u001a\u00020\u0017X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001a\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u001c\u001a\u00020\u001bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u001d\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u001b0\u001eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u001f\u001a\u0004\u0018\u00010\fX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b \u0010!\"\u0004\b\"\u0010#R\u001a\u0010$\u001a\u00020%X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b&\u0010'\"\u0004\b(\u0010)R\u001a\u0010*\u001a\u00020+X\u0084\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b,\u0010-\"\u0004\b.\u0010/R\u0010\u00100\u001a\u0004\u0018\u000101X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u00102\u001a\u00020\u00108F\u00a2\u0006\u0006\u001a\u0004\b2\u00103\u00a8\u0006L"}, d2={"Lcn/imkarl/core/common/io/compress/ZipOutputStream;", "Ljava/io/FilterOutputStream;", "out", "Ljava/io/OutputStream;", "<init>", "(Ljava/io/OutputStream;)V", "file", "Ljava/io/File;", "(Ljava/io/File;)V", "entry", "Ljava/util/zip/ZipEntry;", "comment", "", "level", "", "hasCompressionLevelChanged", "", "method", "entries", "Ljava/util/Vector;", "crc", "Ljava/util/zip/CRC32;", "written", "", "dataStart", "localDataStart", "cdOffset", "Lcn/imkarl/core/common/io/compress/ZipLong;", "cdLength", "offsets", "Ljava/util/Hashtable;", "encoding", "getEncoding", "()Ljava/lang/String;", "setEncoding", "(Ljava/lang/String;)V", "def", "Ljava/util/zip/Deflater;", "getDef", "()Ljava/util/zip/Deflater;", "setDef", "(Ljava/util/zip/Deflater;)V", "buf", "", "getBuf", "()[B", "setBuf", "([B)V", "raf", "Ljava/io/RandomAccessFile;", "isSeekable", "()Z", "finish", "", "closeEntry", "putNextEntry", "ze", "setComment", "setLevel", "setMethod", "write", "b", "offset", "length", "close", "flush", "deflate", "writeLocalFileHeader", "writeDataDescriptor", "writeCentralFileHeader", "writeCentralDirectoryEnd", "getBytes", "name", "writeOut", "data", "Companion", "Common"})
public final class ZipOutputStream
extends FilterOutputStream {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private ZipEntry entry;
    @NotNull
    private String comment;
    private int level;
    private boolean hasCompressionLevelChanged;
    private int method;
    @NotNull
    private final Vector<ZipEntry> entries;
    @NotNull
    private final CRC32 crc;
    private long written;
    private long dataStart;
    private long localDataStart;
    @NotNull
    private ZipLong cdOffset;
    @NotNull
    private ZipLong cdLength;
    @NotNull
    private final Hashtable<ZipEntry, ZipLong> offsets;
    @Nullable
    private String encoding;
    @NotNull
    private Deflater def;
    @NotNull
    private byte[] buf;
    @Nullable
    private RandomAccessFile raf;
    @NotNull
    private static final byte[] ZERO;
    @NotNull
    private static final byte[] LZERO;
    private static final int DEFLATED;
    private static final int STORED;
    @NotNull
    private static final ZipLong LFH_SIG;
    @NotNull
    private static final ZipLong DD_SIG;
    @NotNull
    private static final ZipLong CFH_SIG;
    @NotNull
    private static final ZipLong EOCD_SIG;
    @NotNull
    private static final ZipLong DOS_TIME_MIN;

    @Nullable
    public final String getEncoding() {
        return this.encoding;
    }

    public final void setEncoding(@Nullable String string) {
        this.encoding = string;
    }

    @NotNull
    protected final Deflater getDef() {
        return this.def;
    }

    protected final void setDef(@NotNull Deflater deflater) {
        Intrinsics.checkNotNullParameter((Object)deflater, (String)"<set-?>");
        this.def = deflater;
    }

    @NotNull
    protected final byte[] getBuf() {
        return this.buf;
    }

    protected final void setBuf(@NotNull byte[] byArray) {
        Intrinsics.checkNotNullParameter((Object)byArray, (String)"<set-?>");
        this.buf = byArray;
    }

    public ZipOutputStream(@Nullable OutputStream out) {
        super(out);
        this.comment = "";
        this.level = -1;
        this.method = DEFLATED;
        this.entries = new Vector();
        this.crc = new CRC32();
        this.cdOffset = new ZipLong(0L);
        this.cdLength = new ZipLong(0L);
        this.offsets = new Hashtable();
        this.def = new Deflater(-1, true);
        this.buf = new byte[512];
    }

    public ZipOutputStream(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        super(null);
        this.comment = "";
        this.level = -1;
        this.method = DEFLATED;
        this.entries = new Vector();
        this.crc = new CRC32();
        this.cdOffset = new ZipLong(0L);
        this.cdLength = new ZipLong(0L);
        this.offsets = new Hashtable();
        this.def = new Deflater(-1, true);
        this.buf = new byte[512];
        try {
            RandomAccessFile randomAccessFile = this.raf = new RandomAccessFile(file, "rw");
            Intrinsics.checkNotNull((Object)randomAccessFile);
            randomAccessFile.setLength(0L);
        }
        catch (IOException e) {
            if (this.raf != null) {
                try {
                    RandomAccessFile randomAccessFile = this.raf;
                    Intrinsics.checkNotNull((Object)randomAccessFile);
                    randomAccessFile.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                this.raf = null;
            }
            this.out = new FileOutputStream(file);
        }
    }

    public final boolean isSeekable() {
        return this.raf != null;
    }

    public final void finish() throws IOException {
        this.closeEntry();
        this.cdOffset = new ZipLong(this.written);
        int n = ((Collection)this.entries).size();
        for (int i = 0; i < n; ++i) {
            ZipEntry zipEntry = this.entries.elementAt(i);
            Intrinsics.checkNotNull((Object)zipEntry);
            this.writeCentralFileHeader(zipEntry);
        }
        this.cdLength = new ZipLong(this.written - this.cdOffset.getValue());
        this.writeCentralDirectoryEnd();
        this.offsets.clear();
        this.entries.removeAllElements();
    }

    public final void closeEntry() throws IOException {
        if (this.entry == null) {
            return;
        }
        long realCrc = this.crc.getValue();
        this.crc.reset();
        ZipEntry zipEntry = this.entry;
        Intrinsics.checkNotNull((Object)zipEntry);
        if (zipEntry.getMethod() == DEFLATED) {
            this.def.finish();
            while (!this.def.finished()) {
                this.deflate();
            }
            ZipEntry zipEntry2 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry2);
            zipEntry2.setSize(Companion.adjustToLong(this.def.getTotalIn()));
            ZipEntry zipEntry3 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry3);
            zipEntry3.setCompressedSize(Companion.adjustToLong(this.def.getTotalOut()));
            ZipEntry zipEntry4 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry4);
            zipEntry4.setCrc(realCrc);
            this.def.reset();
            ZipEntry zipEntry5 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry5);
            this.written += zipEntry5.getCompressedSize();
        } else if (this.raf == null) {
            ZipEntry zipEntry6 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry6);
            if (zipEntry6.getCrc() != realCrc) {
                StringBuilder stringBuilder = new StringBuilder().append("bad CRC checksum for entry ");
                ZipEntry zipEntry7 = this.entry;
                Intrinsics.checkNotNull((Object)zipEntry7);
                StringBuilder stringBuilder2 = stringBuilder.append(zipEntry7.getName()).append(": ");
                ZipEntry zipEntry8 = this.entry;
                Intrinsics.checkNotNull((Object)zipEntry8);
                throw new ZipException(stringBuilder2.append(Long.toHexString(zipEntry8.getCrc())).append(" instead of ").append(Long.toHexString(realCrc)).toString());
            }
            ZipEntry zipEntry9 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry9);
            if (zipEntry9.getSize() != this.written - this.dataStart) {
                StringBuilder stringBuilder = new StringBuilder().append("bad size for entry ");
                ZipEntry zipEntry10 = this.entry;
                Intrinsics.checkNotNull((Object)zipEntry10);
                StringBuilder stringBuilder3 = stringBuilder.append(zipEntry10.getName()).append(": ");
                ZipEntry zipEntry11 = this.entry;
                Intrinsics.checkNotNull((Object)zipEntry11);
                throw new ZipException(stringBuilder3.append(zipEntry11.getSize()).append(" instead of ").append(this.written - this.dataStart).toString());
            }
        } else {
            long size = this.written - this.dataStart;
            ZipEntry zipEntry12 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry12);
            zipEntry12.setSize(size);
            ZipEntry zipEntry13 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry13);
            zipEntry13.setCompressedSize(size);
            ZipEntry zipEntry14 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry14);
            zipEntry14.setCrc(realCrc);
        }
        if (this.raf != null) {
            RandomAccessFile randomAccessFile = this.raf;
            Intrinsics.checkNotNull((Object)randomAccessFile);
            long save = randomAccessFile.getFilePointer();
            RandomAccessFile randomAccessFile2 = this.raf;
            Intrinsics.checkNotNull((Object)randomAccessFile2);
            randomAccessFile2.seek(this.localDataStart);
            ZipEntry zipEntry15 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry15);
            ZipOutputStream.writeOut$default(this, new ZipLong(zipEntry15.getCrc()).getBytes(), 0, 0, 6, null);
            ZipEntry zipEntry16 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry16);
            ZipOutputStream.writeOut$default(this, new ZipLong(zipEntry16.getCompressedSize()).getBytes(), 0, 0, 6, null);
            ZipEntry zipEntry17 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry17);
            ZipOutputStream.writeOut$default(this, new ZipLong(zipEntry17.getSize()).getBytes(), 0, 0, 6, null);
            RandomAccessFile randomAccessFile3 = this.raf;
            Intrinsics.checkNotNull((Object)randomAccessFile3);
            randomAccessFile3.seek(save);
        }
        ZipEntry zipEntry18 = this.entry;
        Intrinsics.checkNotNull((Object)zipEntry18);
        this.writeDataDescriptor(zipEntry18);
        this.entry = null;
    }

    public final void putNextEntry(@Nullable ZipEntry ze) throws IOException {
        this.closeEntry();
        this.entry = ze;
        this.entries.addElement(this.entry);
        ZipEntry zipEntry = this.entry;
        Intrinsics.checkNotNull((Object)zipEntry);
        if (zipEntry.getMethod() == -1) {
            ZipEntry zipEntry2 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry2);
            zipEntry2.setMethod(this.method);
        }
        ZipEntry zipEntry3 = this.entry;
        Intrinsics.checkNotNull((Object)zipEntry3);
        if (zipEntry3.getTime() == -1L) {
            ZipEntry zipEntry4 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry4);
            zipEntry4.setTime(System.currentTimeMillis());
        }
        ZipEntry zipEntry5 = this.entry;
        Intrinsics.checkNotNull((Object)zipEntry5);
        if (zipEntry5.getMethod() == STORED && this.raf == null) {
            ZipEntry zipEntry6 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry6);
            if (zipEntry6.getSize() == -1L) {
                throw new ZipException("uncompressed size is required for STORED method when not writing to a file");
            }
            ZipEntry zipEntry7 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry7);
            if (zipEntry7.getCrc() == -1L) {
                throw new ZipException("crc checksum is required for STORED method when not writing to a file");
            }
            ZipEntry zipEntry8 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry8);
            ZipEntry zipEntry9 = this.entry;
            Intrinsics.checkNotNull((Object)zipEntry9);
            zipEntry8.setCompressedSize(zipEntry9.getSize());
        }
        ZipEntry zipEntry10 = this.entry;
        Intrinsics.checkNotNull((Object)zipEntry10);
        if (zipEntry10.getMethod() == DEFLATED && this.hasCompressionLevelChanged) {
            this.def.setLevel(this.level);
            this.hasCompressionLevelChanged = false;
        }
        ZipEntry zipEntry11 = this.entry;
        Intrinsics.checkNotNull((Object)zipEntry11);
        this.writeLocalFileHeader(zipEntry11);
    }

    public final void setComment(@NotNull String comment) {
        Intrinsics.checkNotNullParameter((Object)comment, (String)"comment");
        this.comment = comment;
    }

    public final void setLevel(int level) {
        this.hasCompressionLevelChanged = this.level != level;
        this.level = level;
    }

    public final void setMethod(int method) {
        this.method = method;
    }

    @Override
    public void write(@NotNull byte[] b, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        ZipEntry zipEntry = this.entry;
        Intrinsics.checkNotNull((Object)zipEntry);
        if (zipEntry.getMethod() == DEFLATED) {
            if (length > 0 && !this.def.finished()) {
                this.def.setInput(b, offset, length);
                while (!this.def.needsInput()) {
                    this.deflate();
                }
            }
        } else {
            this.writeOut(b, offset, length);
            this.written += (long)length;
        }
        this.crc.update(b, offset, length);
    }

    @Override
    public void write(int b) throws IOException {
        byte[] buf = new byte[]{(byte)(b & 0xFF)};
        this.write(buf, 0, 1);
    }

    @Override
    public void close() throws IOException {
        this.finish();
        if (this.raf != null) {
            RandomAccessFile randomAccessFile = this.raf;
            Intrinsics.checkNotNull((Object)randomAccessFile);
            randomAccessFile.close();
        }
        if (this.out != null) {
            this.out.close();
        }
    }

    @Override
    public void flush() throws IOException {
        if (this.out != null) {
            this.out.flush();
        }
    }

    protected final void deflate() throws IOException {
        int len = this.def.deflate(this.buf, 0, this.buf.length);
        if (len > 0) {
            this.writeOut(this.buf, 0, len);
        }
    }

    protected final void writeLocalFileHeader(@NotNull ZipEntry ze) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ze, (String)"ze");
        this.offsets.put(ze, new ZipLong(this.written));
        ZipOutputStream.writeOut$default(this, LFH_SIG.getBytes(), 0, 0, 6, null);
        this.written += (long)4;
        if (ze.getMethod() == DEFLATED && this.raf == null) {
            ZipOutputStream.writeOut$default(this, new ZipShort(20).getBytes(), 0, 0, 6, null);
            ZipOutputStream.writeOut$default(this, new ZipShort(8).getBytes(), 0, 0, 6, null);
        } else {
            ZipOutputStream.writeOut$default(this, new ZipShort(10).getBytes(), 0, 0, 6, null);
            ZipOutputStream.writeOut$default(this, ZERO, 0, 0, 6, null);
        }
        this.written += (long)4;
        ZipOutputStream.writeOut$default(this, new ZipShort(ze.getMethod()).getBytes(), 0, 0, 6, null);
        this.written += (long)2;
        ZipOutputStream.writeOut$default(this, Companion.toDosTime(new Date(ze.getTime())).getBytes(), 0, 0, 6, null);
        this.written += (long)4;
        this.localDataStart = this.written;
        if (ze.getMethod() == DEFLATED || this.raf != null) {
            ZipOutputStream.writeOut$default(this, LZERO, 0, 0, 6, null);
            ZipOutputStream.writeOut$default(this, LZERO, 0, 0, 6, null);
            ZipOutputStream.writeOut$default(this, LZERO, 0, 0, 6, null);
        } else {
            ZipOutputStream.writeOut$default(this, new ZipLong(ze.getCrc()).getBytes(), 0, 0, 6, null);
            ZipOutputStream.writeOut$default(this, new ZipLong(ze.getSize()).getBytes(), 0, 0, 6, null);
            ZipOutputStream.writeOut$default(this, new ZipLong(ze.getSize()).getBytes(), 0, 0, 6, null);
        }
        this.written += (long)12;
        String string = ze.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        byte[] name = this.getBytes(string);
        ZipOutputStream.writeOut$default(this, new ZipShort(name.length).getBytes(), 0, 0, 6, null);
        this.written += (long)2;
        byte[] extra = ZipOutputStreamKt.access$getLocalFileDataExtra(ze);
        ZipOutputStream.writeOut$default(this, new ZipShort(extra.length).getBytes(), 0, 0, 6, null);
        this.written += (long)2;
        ZipOutputStream.writeOut$default(this, name, 0, 0, 6, null);
        this.written += (long)name.length;
        ZipOutputStream.writeOut$default(this, extra, 0, 0, 6, null);
        this.written += (long)extra.length;
        this.dataStart = this.written;
    }

    protected final void writeDataDescriptor(@NotNull ZipEntry ze) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ze, (String)"ze");
        if (ze.getMethod() != DEFLATED || this.raf != null) {
            return;
        }
        ZipOutputStream.writeOut$default(this, DD_SIG.getBytes(), 0, 0, 6, null);
        ZipEntry zipEntry = this.entry;
        Intrinsics.checkNotNull((Object)zipEntry);
        ZipOutputStream.writeOut$default(this, new ZipLong(zipEntry.getCrc()).getBytes(), 0, 0, 6, null);
        ZipEntry zipEntry2 = this.entry;
        Intrinsics.checkNotNull((Object)zipEntry2);
        ZipOutputStream.writeOut$default(this, new ZipLong(zipEntry2.getCompressedSize()).getBytes(), 0, 0, 6, null);
        ZipEntry zipEntry3 = this.entry;
        Intrinsics.checkNotNull((Object)zipEntry3);
        ZipOutputStream.writeOut$default(this, new ZipLong(zipEntry3.getSize()).getBytes(), 0, 0, 6, null);
        this.written += (long)16;
    }

    protected final void writeCentralFileHeader(@NotNull ZipEntry ze) throws IOException {
        Intrinsics.checkNotNullParameter((Object)ze, (String)"ze");
        ZipOutputStream.writeOut$default(this, CFH_SIG.getBytes(), 0, 0, 6, null);
        this.written += (long)4;
        ZipOutputStream.writeOut$default(this, new ZipShort(20).getBytes(), 0, 0, 6, null);
        this.written += (long)2;
        if (ze.getMethod() == DEFLATED && this.raf == null) {
            ZipOutputStream.writeOut$default(this, new ZipShort(20).getBytes(), 0, 0, 6, null);
            ZipOutputStream.writeOut$default(this, new ZipShort(8).getBytes(), 0, 0, 6, null);
        } else {
            ZipOutputStream.writeOut$default(this, new ZipShort(10).getBytes(), 0, 0, 6, null);
            ZipOutputStream.writeOut$default(this, ZERO, 0, 0, 6, null);
        }
        this.written += (long)4;
        ZipOutputStream.writeOut$default(this, new ZipShort(ze.getMethod()).getBytes(), 0, 0, 6, null);
        this.written += (long)2;
        ZipOutputStream.writeOut$default(this, Companion.toDosTime(new Date(ze.getTime())).getBytes(), 0, 0, 6, null);
        this.written += (long)4;
        ZipOutputStream.writeOut$default(this, new ZipLong(ze.getCrc()).getBytes(), 0, 0, 6, null);
        ZipOutputStream.writeOut$default(this, new ZipLong(ze.getCompressedSize()).getBytes(), 0, 0, 6, null);
        ZipOutputStream.writeOut$default(this, new ZipLong(ze.getSize()).getBytes(), 0, 0, 6, null);
        this.written += (long)12;
        String string = ze.getName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
        byte[] name = this.getBytes(string);
        ZipOutputStream.writeOut$default(this, new ZipShort(name.length).getBytes(), 0, 0, 6, null);
        this.written += (long)2;
        byte[] extra = ZipOutputStreamKt.access$getCentralDirectoryExtra(ze);
        ZipOutputStream.writeOut$default(this, new ZipShort(extra.length).getBytes(), 0, 0, 6, null);
        this.written += (long)2;
        String comm = ze.getComment();
        if (comm == null) {
            comm = "";
        }
        byte[] comment = this.getBytes(comm);
        ZipOutputStream.writeOut$default(this, new ZipShort(comment.length).getBytes(), 0, 0, 6, null);
        this.written += (long)2;
        ZipOutputStream.writeOut$default(this, ZERO, 0, 0, 6, null);
        this.written += (long)2;
        ZipOutputStream.writeOut$default(this, new ZipShort(0).getBytes(), 0, 0, 6, null);
        this.written += (long)2;
        ZipOutputStream.writeOut$default(this, new ZipLong(0L).getBytes(), 0, 0, 6, null);
        this.written += (long)4;
        ZipLong zipLong = this.offsets.get(ze);
        Intrinsics.checkNotNull((Object)zipLong, (String)"null cannot be cast to non-null type cn.imkarl.core.common.io.compress.ZipLong");
        ZipOutputStream.writeOut$default(this, zipLong.getBytes(), 0, 0, 6, null);
        this.written += (long)4;
        ZipOutputStream.writeOut$default(this, name, 0, 0, 6, null);
        this.written += (long)name.length;
        ZipOutputStream.writeOut$default(this, extra, 0, 0, 6, null);
        this.written += (long)extra.length;
        ZipOutputStream.writeOut$default(this, comment, 0, 0, 6, null);
        this.written += (long)comment.length;
    }

    protected final void writeCentralDirectoryEnd() throws IOException {
        ZipOutputStream.writeOut$default(this, EOCD_SIG.getBytes(), 0, 0, 6, null);
        ZipOutputStream.writeOut$default(this, ZERO, 0, 0, 6, null);
        ZipOutputStream.writeOut$default(this, ZERO, 0, 0, 6, null);
        byte[] num = new ZipShort(this.entries.size()).getBytes();
        ZipOutputStream.writeOut$default(this, num, 0, 0, 6, null);
        ZipOutputStream.writeOut$default(this, num, 0, 0, 6, null);
        ZipOutputStream.writeOut$default(this, this.cdLength.getBytes(), 0, 0, 6, null);
        ZipOutputStream.writeOut$default(this, this.cdOffset.getBytes(), 0, 0, 6, null);
        byte[] data = this.getBytes(this.comment);
        ZipOutputStream.writeOut$default(this, new ZipShort(data.length).getBytes(), 0, 0, 6, null);
        ZipOutputStream.writeOut$default(this, data, 0, 0, 6, null);
    }

    @NotNull
    protected final byte[] getBytes(@NotNull String name) throws ZipException {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (this.encoding == null) {
            String string = name;
            byte[] byArray = string.getBytes(Charsets.UTF_8);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return byArray;
        }
        try {
            String string = this.encoding;
            Intrinsics.checkNotNull((Object)string);
            Charset charset = Charset.forName(string);
            Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"forName(...)");
            byte[] byArray = name.getBytes(charset);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"getBytes(...)");
            return byArray;
        }
        catch (UnsupportedEncodingException uee) {
            throw new ZipException(uee.getMessage());
        }
    }

    protected final void writeOut(@NotNull byte[] data, int offset, int length) throws IOException {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        if (this.raf != null) {
            RandomAccessFile randomAccessFile = this.raf;
            Intrinsics.checkNotNull((Object)randomAccessFile);
            randomAccessFile.write(data, offset, length);
        } else {
            this.out.write(data, offset, length);
        }
    }

    public static /* synthetic */ void writeOut$default(ZipOutputStream zipOutputStream, byte[] byArray, int n, int n2, int n3, Object object) throws IOException {
        if ((n3 & 2) != 0) {
            n = 0;
        }
        if ((n3 & 4) != 0) {
            n2 = byArray.length;
        }
        zipOutputStream.writeOut(byArray, n, n2);
    }

    static {
        byte[] byArray = new byte[]{0, 0};
        ZERO = byArray;
        byArray = new byte[]{0, 0, 0, 0};
        LZERO = byArray;
        DEFLATED = 8;
        LFH_SIG = new ZipLong(67324752L);
        DD_SIG = new ZipLong(134695760L);
        CFH_SIG = new ZipLong(33639248L);
        EOCD_SIG = new ZipLong(101010256L);
        DOS_TIME_MIN = new ZipLong(8448L);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0018\u001a\u00020\u000e2\u0006\u0010\u0019\u001a\u00020\u001aH\u0004J\u0010\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u001d\u001a\u00020\bH\u0004R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\bX\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR\u0014\u0010\r\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0010R\u0014\u0010\u0013\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0010R\u0014\u0010\u0015\u001a\u00020\u000eX\u0084\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0010R\u000e\u0010\u0017\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcn/imkarl/core/common/io/compress/ZipOutputStream$Companion;", "", "<init>", "()V", "ZERO", "", "LZERO", "DEFLATED", "", "getDEFLATED", "()I", "STORED", "getSTORED", "LFH_SIG", "Lcn/imkarl/core/common/io/compress/ZipLong;", "getLFH_SIG", "()Lcn/imkarl/core/common/io/compress/ZipLong;", "DD_SIG", "getDD_SIG", "CFH_SIG", "getCFH_SIG", "EOCD_SIG", "getEOCD_SIG", "DOS_TIME_MIN", "toDosTime", "time", "Ljava/util/Date;", "adjustToLong", "", "i", "Common"})
    public static final class Companion {
        private Companion() {
        }

        public final int getDEFLATED() {
            return DEFLATED;
        }

        public final int getSTORED() {
            return STORED;
        }

        @NotNull
        protected final ZipLong getLFH_SIG() {
            return LFH_SIG;
        }

        @NotNull
        protected final ZipLong getDD_SIG() {
            return DD_SIG;
        }

        @NotNull
        protected final ZipLong getCFH_SIG() {
            return CFH_SIG;
        }

        @NotNull
        protected final ZipLong getEOCD_SIG() {
            return EOCD_SIG;
        }

        @NotNull
        protected final ZipLong toDosTime(@NotNull Date time) {
            Intrinsics.checkNotNullParameter((Object)time, (String)"time");
            int year = time.getYear() + 1900;
            int month = time.getMonth() + 1;
            if (year < 1980) {
                return DOS_TIME_MIN;
            }
            long value = year - 1980 << 25 | month << 21 | time.getDate() << 16 | time.getHours() << 11 | time.getMinutes() << 5 | time.getSeconds() >> 1;
            byte[] result = new byte[]{(byte)(value & 0xFFL), (byte)((value & 0xFF00L) >> 8), (byte)((value & 0xFF0000L) >> 16), (byte)((value & 0xFF000000L) >> 24)};
            return new ZipLong(result, 0, 2, null);
        }

        protected final long adjustToLong(int i) {
            if (i < 0) {
                return 0x100000000L + (long)i;
            }
            return i;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

