/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.io;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\b\u0010\t\u001a\u00020\nH\u0016J \u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\nH\u0016J\u0010\u0010\u000f\u001a\u00020\u00052\u0006\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\u0012H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcn/imkarl/core/common/io/LimitedInputStream;", "Ljava/io/FilterInputStream;", "stream", "Ljava/io/InputStream;", "maxSize", "", "<init>", "(Ljava/io/InputStream;J)V", "currentPos", "read", "", "b", "", "off", "len", "skip", "n", "checkPos", "", "Common"})
@SourceDebugExtension(value={"SMAP\nLimitedInputStream.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LimitedInputStream.kt\ncn/imkarl/core/common/io/LimitedInputStream\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,53:1\n1#2:54\n*E\n"})
public final class LimitedInputStream
extends FilterInputStream {
    private final long maxSize;
    private long currentPos;

    public LimitedInputStream(@NotNull InputStream stream, long maxSize) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        super(stream);
        this.maxSize = maxSize;
    }

    @Override
    public int read() throws IOException {
        int data = super.read();
        if (data != -1) {
            long l = this.currentPos;
            this.currentPos = l + 1L;
            this.checkPos();
        }
        return data;
    }

    @Override
    public int read(@NotNull byte[] b, int off, int len) throws IOException {
        Intrinsics.checkNotNullParameter((Object)b, (String)"b");
        int count = super.read(b, off, len);
        if (count > 0) {
            this.currentPos += (long)count;
            this.checkPos();
        }
        return count;
    }

    @Override
    public long skip(long n) throws IOException {
        long skipped = super.skip(n);
        if (skipped != 0L) {
            this.currentPos += skipped;
            this.checkPos();
        }
        return skipped;
    }

    private final void checkPos() {
        if (!(this.currentPos <= this.maxSize)) {
            boolean bl = false;
            String string = "Read limit exceeded";
            throw new IllegalStateException(string.toString());
        }
    }
}

