/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.http;

import cn.imkarl.core.common.http.ContentTypesKt;
import io.ktor.http.ContentType;
import io.ktor.http.FileContentTypeKt;
import io.ktor.util.CharsetKt;
import java.util.List;
import java.util.Locale;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\b\u0010\u0007\u001a\u0004\u0018\u00010\bJ\u0014\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\n\u001a\u00020\b\u00a8\u0006\u000b"}, d2={"Lcn/imkarl/core/common/http/ContentTypes;", "", "<init>", "()V", "fromFileExtension", "", "Lio/ktor/http/ContentType;", "extension", "", "fromFilePath", "path", "Common"})
@SourceDebugExtension(value={"SMAP\nContentTypes.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ContentTypes.kt\ncn/imkarl/core/common/http/ContentTypes\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,83:1\n1#2:84\n*E\n"})
public final class ContentTypes {
    @NotNull
    public static final ContentTypes INSTANCE = new ContentTypes();

    private ContentTypes() {
    }

    @NotNull
    public final List<ContentType> fromFileExtension(@Nullable String extension) {
        Object object;
        ContentType contentType;
        CharSequence charSequence = extension;
        if (charSequence == null || charSequence.length() == 0) {
            return CollectionsKt.listOf((Object)ContentType.Companion.getAny());
        }
        String string = extension.toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        switch (string) {
            case "ini": 
            case "plain": {
                ContentType contentType2 = ContentType.Text.INSTANCE.getPlain();
                break;
            }
            case "md": {
                ContentType contentType2 = ContentTypesKt.getMarkdown(ContentType.Text.INSTANCE);
                break;
            }
            case "apng": {
                ContentType contentType2 = ContentType.Image.INSTANCE.getAny();
                break;
            }
            case "psd": {
                ContentType contentType2 = ContentTypesKt.getPSD(ContentType.Image.INSTANCE);
                break;
            }
            case "m4p": 
            case "m4b": {
                ContentType contentType2 = ContentType.Video.INSTANCE.getMPEG();
                break;
            }
            case "flac": {
                ContentType contentType2 = ContentType.Audio.INSTANCE.getAny();
                break;
            }
            case "proto": {
                ContentType contentType2 = ContentType.Application.INSTANCE.getProtoBuf();
                break;
            }
            default: {
                ContentType contentType2 = contentType = null;
            }
        }
        if (contentType != null) {
            return CollectionsKt.listOf((Object)contentType);
        }
        Object object2 = FileContentTypeKt.fromFileExtension((ContentType.Companion)ContentType.Companion, (String)extension);
        if (object2.isEmpty()) {
            boolean bl = false;
            object = CollectionsKt.listOf((Object)ContentType.Companion.getAny());
        } else {
            object = object2;
        }
        return (List)object;
    }

    @NotNull
    public final List<ContentType> fromFilePath(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        int slashIndex = StringsKt.lastIndexOfAny$default((CharSequence)path, (char[])CharsetKt.toCharArray((String)"/\\"), (int)0, (boolean)false, (int)6, null);
        int index = StringsKt.indexOf$default((CharSequence)path, (char)'.', (int)(slashIndex + 1), (boolean)false, (int)4, null);
        if (index == -1) {
            return CollectionsKt.listOf((Object)ContentType.Companion.getAny());
        }
        String string = path.substring(index + 1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
        return this.fromFileExtension(string);
    }
}

