/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.encode;

import cn.imkarl.core.common.log.LogUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u001e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\f\u0010\u0004\u001a\u0004\u0018\u00010\u0005*\u00020\u0006\u001a\f\u0010\u0007\u001a\u0004\u0018\u00010\u0006*\u00020\u0005\u001a\u0014\u0010\b\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n\u001a\u0014\u0010\u000b\u001a\u00020\u0005*\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n\u001a\n\u0010\f\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\r\u001a\u00020\u0005*\u00020\u0005\u001a\n\u0010\u000e\u001a\u00020\u0005*\u00020\u0006\u001a\n\u0010\u000f\u001a\u00020\u0006*\u00020\u0005\"\u0018\u0010\u0000\u001a\n \u0002*\u0004\u0018\u00010\u00010\u0001X\u0082\u0004\u00a2\u0006\u0004\n\u0002\u0010\u0003\u00a8\u0006\u0010"}, d2={"PATTERN_UNICODE", "Ljava/util/regex/Pattern;", "kotlin.jvm.PlatformType", "Ljava/util/regex/Pattern;", "encodeBase64", "", "", "decodeBase64", "encodeUrl", "charset", "Ljava/nio/charset/Charset;", "decodeUrl", "encodeUnicode", "decodeUnicode", "bytesToHexString", "hexStringToBytes", "Common"})
public final class EncodeExtensionsKt {
    private static final Pattern PATTERN_UNICODE = Pattern.compile("\\\\u([0-9A-Fa-f]{4})");

    @Nullable
    public static final String encodeBase64(@NotNull byte[] $this$encodeBase64) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$encodeBase64, (String)"<this>");
        try {
            string = Base64.getEncoder().encodeToString($this$encodeBase64);
        }
        catch (Exception e) {
            LogUtils.e(e);
            string = null;
        }
        return string;
    }

    @Nullable
    public static final byte[] decodeBase64(@NotNull String $this$decodeBase64) {
        byte[] byArray;
        Intrinsics.checkNotNullParameter((Object)$this$decodeBase64, (String)"<this>");
        try {
            byArray = Base64.getDecoder().decode($this$decodeBase64);
        }
        catch (Exception e) {
            LogUtils.e(e);
            byArray = null;
        }
        return byArray;
    }

    @NotNull
    public static final String encodeUrl(@NotNull String $this$encodeUrl, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        try {
            String string = URLEncoder.encode($this$encodeUrl, charset.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"encode(...)");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            return $this$encodeUrl;
        }
    }

    public static /* synthetic */ String encodeUrl$default(String string, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return EncodeExtensionsKt.encodeUrl(string, charset);
    }

    @NotNull
    public static final String decodeUrl(@NotNull String $this$decodeUrl, @NotNull Charset charset) {
        String string;
        Intrinsics.checkNotNullParameter((Object)$this$decodeUrl, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        try {
            string = URLDecoder.decode($this$decodeUrl, charset.name());
        }
        catch (UnsupportedEncodingException e) {
            string = $this$decodeUrl;
        }
        return string;
    }

    public static /* synthetic */ String decodeUrl$default(String string, Charset charset, int n, Object object) {
        if ((n & 1) != 0) {
            charset = Charsets.UTF_8;
        }
        return EncodeExtensionsKt.decodeUrl(string, charset);
    }

    @NotNull
    public static final String encodeUnicode(@NotNull String $this$encodeUnicode) {
        Intrinsics.checkNotNullParameter((Object)$this$encodeUnicode, (String)"<this>");
        if (StringsKt.isBlank((CharSequence)$this$encodeUnicode)) {
            return $this$encodeUnicode;
        }
        StringBuilder unicodeBytes = new StringBuilder();
        char[] cArray = $this$encodeUnicode.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"toCharArray(...)");
        for (char ch : cArray) {
            if (ch < '\n') {
                unicodeBytes.append("\\u000").append(Integer.toHexString(ch));
                continue;
            }
            if (Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.BASIC_LATIN) {
                unicodeBytes.append(ch);
                continue;
            }
            String hex = Integer.toHexString(ch);
            if (hex.length() == 1) {
                unicodeBytes.append("\\u000").append(hex);
                continue;
            }
            if (hex.length() == 2) {
                unicodeBytes.append("\\u00").append(hex);
                continue;
            }
            if (hex.length() == 3) {
                unicodeBytes.append("\\u0").append(hex);
                continue;
            }
            if (hex.length() != 4) continue;
            unicodeBytes.append("\\u").append(hex);
        }
        String string = unicodeBytes.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String decodeUnicode(@NotNull String $this$decodeUnicode) {
        Intrinsics.checkNotNullParameter((Object)$this$decodeUnicode, (String)"<this>");
        if (StringsKt.isBlank((CharSequence)$this$decodeUnicode) || !StringsKt.contains$default((CharSequence)$this$decodeUnicode, (CharSequence)"\\u", (boolean)false, (int)2, null)) {
            return $this$decodeUnicode;
        }
        StringBuffer buf = new StringBuffer();
        Matcher matcher = PATTERN_UNICODE.matcher($this$decodeUnicode);
        while (matcher.find()) {
            try {
                matcher.appendReplacement(buf, "");
                buf.appendCodePoint(Integer.parseInt(matcher.group(1), 16));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        matcher.appendTail(buf);
        String string = buf.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final String bytesToHexString(@NotNull byte[] $this$bytesToHexString) {
        Intrinsics.checkNotNullParameter((Object)$this$bytesToHexString, (String)"<this>");
        if ($this$bytesToHexString.length == 0) {
            return "";
        }
        StringBuilder hexBuilder = new StringBuilder();
        for (byte b : $this$bytesToHexString) {
            String hv = Integer.toHexString(b & 0xFF);
            if (hv.length() < 2) {
                hexBuilder.append(0);
            }
            hexBuilder.append(hv);
        }
        String string = hexBuilder.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    @NotNull
    public static final byte[] hexStringToBytes(@NotNull String $this$hexStringToBytes) {
        Intrinsics.checkNotNullParameter((Object)$this$hexStringToBytes, (String)"<this>");
        int length = $this$hexStringToBytes.length() / 2;
        byte[] bytes2 = new byte[length];
        for (int i = 0; i < length; ++i) {
            String string = $this$hexStringToBytes.substring(i * 2, i * 2 + 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            bytes2[i] = (byte)Integer.valueOf(string, 16).intValue();
        }
        return bytes2;
    }
}

