/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.IntRange;
import kotlin.sequences.Sequence;
import kotlin.text.MatchResult;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\u0002\u0018\u0000 \u000f*\u0004\b\u0000\u0010\u00012\b\u0012\u0004\u0012\u0002H\u00010\u0002:\u0001\u000fB\u001b\u0012\u0012\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J!\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00018\u00002\b\u0010\u000b\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\fJ\u0012\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00050\u000e*\u00020\u0005H\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcn/imkarl/core/common/collections/AlphanumComparator;", "T", "Ljava/util/Comparator;", "transform", "Lkotlin/Function1;", "", "<init>", "(Lkotlin/jvm/functions/Function1;)V", "compare", "", "o1", "o2", "(Ljava/lang/Object;Ljava/lang/Object;)I", "splitAlphanum", "", "Companion", "Common"})
@SourceDebugExtension(value={"SMAP\nAlphanumComparator.kt\nKotlin\n*S Kotlin\n*F\n+ 1 AlphanumComparator.kt\ncn/imkarl/core/common/collections/AlphanumComparator\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,82:1\n1557#2:83\n1628#2,3:84\n*S KotlinDebug\n*F\n+ 1 AlphanumComparator.kt\ncn/imkarl/core/common/collections/AlphanumComparator\n*L\n79#1:83\n79#1:84,3\n*E\n"})
public final class AlphanumComparator<T>
implements Comparator<T> {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Function1<T, String> transform;
    @NotNull
    private static final Regex alphanumRegex = new Regex("[0-9]+");

    public AlphanumComparator(@NotNull Function1<? super T, String> transform) {
        Intrinsics.checkNotNullParameter(transform, (String)"transform");
        this.transform = transform;
    }

    @Override
    public int compare(@Nullable T o1, @Nullable T o2) {
        if (o1 == null && o2 == null) {
            return 0;
        }
        if (o1 == null) {
            return -1;
        }
        if (o2 == null) {
            return 1;
        }
        String str1 = (String)this.transform.invoke(o1);
        String str2 = (String)this.transform.invoke(o2);
        List<String> strNodeArr1 = this.splitAlphanum(str1);
        List<String> strNodeArr2 = this.splitAlphanum(str2);
        if (strNodeArr1.isEmpty() || strNodeArr2.isEmpty()) {
            return str1.compareTo(str2);
        }
        int minLen = Math.min(strNodeArr1.size(), strNodeArr2.size());
        for (int i = 0; i < minLen; ++i) {
            Integer strNode1 = StringsKt.toIntOrNull((String)strNodeArr1.get(i));
            Integer strNode2 = StringsKt.toIntOrNull((String)strNodeArr2.get(i));
            if (Intrinsics.areEqual((Object)strNodeArr1.get(i), (Object)strNodeArr2.get(i))) continue;
            if (strNode1 != null && strNode2 != null) {
                return Intrinsics.areEqual((Object)strNode1, (Object)strNode2) ? (strNodeArr1.get(i).length() < strNodeArr2.get(i).length() ? -1 : (strNodeArr1.get(i).length() == strNodeArr2.get(i).length() ? 0 : 1)) : (strNode1 > strNode2 ? 1 : -1);
            }
            return strNodeArr1.get(i).compareTo(strNodeArr2.get(i));
        }
        return str1.compareTo(str2);
    }

    /*
     * WARNING - void declaration
     */
    private final List<String> splitAlphanum(String $this$splitAlphanum) {
        void $this$mapTo$iv$iv;
        Sequence mathResults = Regex.findAll$default((Regex)alphanumRegex, (CharSequence)$this$splitAlphanum, (int)0, (int)2, null);
        List ranges = new ArrayList();
        int index = 0;
        for (MatchResult matchResult : mathResults) {
            if (matchResult.getRange().getFirst() != index) {
                ranges.add(new IntRange(index, matchResult.getRange().getFirst()));
            }
            ranges.add(new IntRange(matchResult.getRange().getFirst(), matchResult.getRange().getLast() + 1));
            index = matchResult.getRange().getLast() + 1;
        }
        Iterable $this$map$iv = ranges;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            IntRange intRange = (IntRange)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String string = $this$splitAlphanum.substring(it.getFirst(), it.getLast());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            collection.add(string);
        }
        return (List)destination$iv$iv;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0006"}, d2={"Lcn/imkarl/core/common/collections/AlphanumComparator$Companion;", "", "<init>", "()V", "alphanumRegex", "Lkotlin/text/Regex;", "Common"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

