/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.security;

import cn.imkarl.core.common.encode.EncodeUtils;
import cn.imkarl.core.common.file.IOUtilsKt;
import cn.imkarl.core.common.log.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.security.DigestInputStream;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Cipher;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.DESKeySpec;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004J\u0018\u0010\b\u001a\u00020\u00042\u0006\u0010\u0006\u001a\u00020\u00042\b\b\u0002\u0010\u0007\u001a\u00020\u0004J\u001c\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\nH\u0002J\u001a\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\nJ\u001a\u0010\f\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\nJ\u001a\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u000e\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\nJ\u001a\u0010\u000f\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0007\u001a\u00020\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J$\u0010\u0010\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\n2\b\u0010\u0006\u001a\u0004\u0018\u00010\nH\u0002J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\nJ\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00042\b\u0010\u0006\u001a\u0004\u0018\u00010\u0004R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcn/imkarl/core/common/security/EncryptUtils;", "", "()V", "defaultKey", "", "decryptDES", "data", "key", "encryptDES", "hashTemplate", "", "algorithm", "hmacMD5", "hmacMD5ToString", "hmacSHA1", "hmacSHA1ToString", "hmacTemplate", "md5", "file", "Ljava/io/File;", "sha1", "Common"})
public final class EncryptUtils {
    @NotNull
    public static final EncryptUtils INSTANCE = new EncryptUtils();
    @NotNull
    private static final String defaultKey = "e99a18c428cb38d5f260853678922e03";

    private EncryptUtils() {
    }

    @Nullable
    public final String md5(@Nullable String data) {
        if (data == null) {
            return null;
        }
        String string = data;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.md5(byArray);
    }

    @Nullable
    public final String md5(@Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hashTemplate("MD5", data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String md5(@Nullable File file) {
        if (file == null) {
            return null;
        }
        FileInputStream fis = null;
        DigestInputStream digestInputStream = null;
        try {
            fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            digestInputStream = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (digestInputStream.read(buffer) > 0) {
            }
            md = digestInputStream.getMessageDigest();
            String string = EncodeUtils.bytesToHexString(md.digest());
            return string;
        }
        catch (Exception e) {
            LogUtils.e(e);
            String string = null;
            return string;
        }
        finally {
            IOUtilsKt.closeQuietly(fis);
        }
    }

    @Nullable
    public final String sha1(@Nullable String data) {
        if (data == null) {
            return null;
        }
        String string = data;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        return this.sha1(byArray);
    }

    @Nullable
    public final String sha1(@Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hashTemplate("SHA1", data));
    }

    @Nullable
    public final String hmacMD5ToString(@NotNull String key, @Nullable String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        string = data;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        return this.hmacMD5ToString(byArray, byArray2);
    }

    @Nullable
    public final String hmacMD5ToString(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hmacMD5(key, data));
    }

    @Nullable
    public final byte[] hmacMD5(@NotNull String key, @Nullable String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        string = data;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        return this.hmacMD5(byArray, byArray2);
    }

    @Nullable
    public final byte[] hmacMD5(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return this.hmacTemplate("HmacMD5", key, data);
    }

    @Nullable
    public final String hmacSHA1ToString(@NotNull String key, @Nullable String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        string = data;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        return this.hmacSHA1ToString(byArray, byArray2);
    }

    @Nullable
    public final String hmacSHA1ToString(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hmacSHA1(key, data));
    }

    @Nullable
    public final byte[] hmacSHA1(@NotNull String key, @Nullable String data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        string = data;
        byte[] byArray2 = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        return this.hmacSHA1(byArray, byArray2);
    }

    @Nullable
    public final byte[] hmacSHA1(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return this.hmacTemplate("HmacSHA1", key, data);
    }

    private final byte[] hashTemplate(String algorithm, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            if (data.length > 0) {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                md.update(data);
                return md.digest();
            }
        }
        catch (NoSuchAlgorithmException e) {
            LogUtils.e(e);
        }
        return null;
    }

    private final byte[] hmacTemplate(String algorithm, byte[] key, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            if (key.length > 0 && data.length > 0) {
                Mac mac = Mac.getInstance(algorithm);
                SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
                mac.init(secretKey);
                return mac.doFinal(data);
            }
        }
        catch (InvalidKeyException e) {
            LogUtils.e(e);
        }
        catch (NoSuchAlgorithmException e) {
            LogUtils.e(e);
        }
        return null;
    }

    @NotNull
    public final String encryptDES(@NotNull String data, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Cipher cipher = Cipher.getInstance("DES");
        SecretKeyFactory kf = SecretKeyFactory.getInstance("DES");
        String string = defaultKey + key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        DESKeySpec keySpec = new DESKeySpec(byArray);
        SecretKey secretKey = kf.generateSecret(keySpec);
        cipher.init(1, secretKey);
        String string2 = data;
        byte[] byArray2 = string2.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray2, (String)"this as java.lang.String).getBytes(charset)");
        byte[] encrypt = cipher.doFinal(byArray2);
        Intrinsics.checkNotNullExpressionValue((Object)encrypt, (String)"encrypt");
        String string3 = EncodeUtils.encodeBase64(encrypt);
        Intrinsics.checkNotNull((Object)string3);
        return string3;
    }

    public static /* synthetic */ String encryptDES$default(EncryptUtils encryptUtils, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return encryptUtils.encryptDES(string, string2);
    }

    @NotNull
    public final String decryptDES(@NotNull String data, @NotNull String key) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)key, (String)"key");
        Cipher cipher = Cipher.getInstance("DES");
        SecretKeyFactory kf = SecretKeyFactory.getInstance("DES");
        String string = defaultKey + key;
        byte[] byArray = string.getBytes(Charsets.UTF_8);
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"this as java.lang.String).getBytes(charset)");
        DESKeySpec keySpec = new DESKeySpec(byArray);
        SecretKey secretKey = kf.generateSecret(keySpec);
        Intrinsics.checkNotNullExpressionValue((Object)secretKey, (String)"kf.generateSecret(keySpec)");
        Key secretKey2 = secretKey;
        cipher.init(2, secretKey2);
        byte[] decrypt = cipher.doFinal(EncodeUtils.decodeBase64(data));
        Intrinsics.checkNotNullExpressionValue((Object)decrypt, (String)"decrypt");
        return new String(decrypt, Charsets.UTF_8);
    }

    public static /* synthetic */ String decryptDES$default(EncryptUtils encryptUtils, String string, String string2, int n, Object object) {
        if ((n & 2) != 0) {
            string2 = "";
        }
        return encryptUtils.decryptDES(string, string2);
    }
}

