/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.file;

import cn.imkarl.core.common.app.AppUtils;
import cn.imkarl.core.common.file.IOUtils;
import cn.imkarl.core.common.file.IOUtilsKt;
import cn.imkarl.core.common.log.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.channels.FileChannel;
import java.text.DecimalFormat;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000e\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001(B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\r\u001a\u00020\fH\u0007J\u0018\u0010\u0010\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\fH\u0003J\u0010\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0010\u0010\u0013\u001a\u00020\n2\u0006\u0010\u0014\u001a\u00020\fH\u0007J\u0010\u0010\u0015\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\fH\u0007J\u0010\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0004H\u0007J\u0010\u0010\u0019\u001a\u00020\f2\u0006\u0010\u001a\u001a\u00020\u0017H\u0007J\b\u0010\u001b\u001a\u00020\fH\u0007J\u0014\u0010\u001c\u001a\u00020\f2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001eH\u0007J\b\u0010\u001f\u001a\u00020\fH\u0007J\u0010\u0010 \u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\fH\u0007J\b\u0010!\u001a\u00020\fH\u0007J\u0010\u0010\"\u001a\u00020\u00042\u0006\u0010\u0014\u001a\u00020\fH\u0007J\b\u0010#\u001a\u00020\fH\u0007J\u0012\u0010$\u001a\u00020\n2\b\u0010\u0014\u001a\u0004\u0018\u00010\fH\u0007J\u001a\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\f2\b\u0010'\u001a\u0004\u0018\u00010\fH\u0007J\u0010\u0010\u0018\u001a\u00020\u00042\u0006\u0010\u0012\u001a\u00020\fH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcn/imkarl/core/common/file/FileUtils;", "", "()V", "FILE_SIZE_GB", "", "FILE_SIZE_KB", "FILE_SIZE_MB", "fileSizeFormat", "Ljava/text/DecimalFormat;", "copy", "", "source", "Ljava/io/File;", "target", "stream", "Ljava/io/InputStream;", "copyFile", "createNewFile", "file", "deleteDir", "dir", "deleteFile", "formatFileSize", "", "size", "getAbsoluteFile", "path", "getAppStorageRootDir", "getClassRootDir", "sourceType", "Lcn/imkarl/core/common/file/FileUtils$SourceType;", "getCurrentDir", "getFreeSpace", "getResourceRootDir", "getTotalSpace", "getUserHomeDir", "mkdirs", "rename", "from", "to", "SourceType", "Common"})
public final class FileUtils {
    @NotNull
    public static final FileUtils INSTANCE = new FileUtils();
    private static final long FILE_SIZE_KB = 1024L;
    private static final long FILE_SIZE_MB = 0x100000L;
    private static final long FILE_SIZE_GB = 0x40000000L;
    @NotNull
    private static final DecimalFormat fileSizeFormat = new DecimalFormat("0.00");

    private FileUtils() {
    }

    @JvmStatic
    @NotNull
    public static final File getClassRootDir(@Nullable SourceType sourceType) {
        File file;
        String classRootPath;
        ClassLoader classLoader = FileUtils.class.getClassLoader();
        if (AppUtils.isJarRun) {
            String codeSourcePath = FileUtils.class.getProtectionDomain().getCodeSource().getLocation().getPath();
            return new File(codeSourcePath);
        }
        URL uRL = classLoader.getResource("");
        Intrinsics.checkNotNull((Object)uRL);
        String string = classRootPath = uRL.getFile();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"classRootPath");
        if (StringsKt.endsWith$default((String)string, (String)"/build/classes/java/main/", (boolean)false, (int)2, null)) {
            String string2 = classRootPath;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"classRootPath");
            classRootPath = StringsKt.removeSuffix((String)string2, (CharSequence)"java/main/");
        } else {
            String string3 = classRootPath;
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"classRootPath");
            if (StringsKt.endsWith$default((String)string3, (String)"/build/classes/kotlin/main/", (boolean)false, (int)2, null)) {
                String string4 = classRootPath;
                Intrinsics.checkNotNullExpressionValue((Object)string4, (String)"classRootPath");
                classRootPath = StringsKt.removeSuffix((String)string4, (CharSequence)"kotlin/main/");
            }
        }
        SourceType sourceType2 = sourceType;
        switch (sourceType2 == null ? -1 : WhenMappings.$EnumSwitchMapping$0[sourceType2.ordinal()]) {
            case 1: {
                file = new File(classRootPath, "kotlin/main");
                break;
            }
            case 2: {
                file = new File(classRootPath, "java/main");
                break;
            }
            default: {
                file = new File(classRootPath);
            }
        }
        return file;
    }

    public static /* synthetic */ File getClassRootDir$default(SourceType sourceType, int n, Object object) {
        if ((n & 1) != 0) {
            sourceType = null;
        }
        return FileUtils.getClassRootDir(sourceType);
    }

    @JvmStatic
    @NotNull
    public static final File getResourceRootDir() {
        if (AppUtils.isJarRun) {
            return FileUtils.getClassRootDir$default(null, 1, null);
        }
        File resourceRootFile = null;
        resourceRootFile = new File(FileUtils.getClassRootDir$default(null, 1, null).getParent(), "resources");
        File it = new File(resourceRootFile, "main");
        boolean bl = false;
        if (it.exists()) {
            resourceRootFile = it;
        }
        return resourceRootFile;
    }

    @JvmStatic
    @NotNull
    public static final File getUserHomeDir() {
        return new File(System.getProperty("user.home"));
    }

    @JvmStatic
    @NotNull
    public static final File getCurrentDir() {
        return new File(System.getProperty("user.dir"));
    }

    @JvmStatic
    @NotNull
    public static final File getAppStorageRootDir() {
        return new File(INSTANCE.getUserHomeDir(), ".AppData/" + StringsKt.removePrefix((String)AppUtils.getPackageName(), (CharSequence)"/"));
    }

    @JvmStatic
    @NotNull
    public static final File getAbsoluteFile(@NotNull String path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        String absolutePath = ((Object)StringsKt.trim((CharSequence)path)).toString();
        File file = Intrinsics.areEqual((Object)absolutePath, (Object)"~") ? INSTANCE.getUserHomeDir() : (StringsKt.startsWith$default((String)absolutePath, (String)"~/", (boolean)false, (int)2, null) ? new File(INSTANCE.getUserHomeDir(), StringsKt.removePrefix((String)absolutePath, (CharSequence)"~/")) : (StringsKt.startsWith$default((String)absolutePath, (String)"~\\", (boolean)false, (int)2, null) ? new File(INSTANCE.getUserHomeDir(), StringsKt.removePrefix((String)absolutePath, (CharSequence)"~\\")) : (Intrinsics.areEqual((Object)absolutePath, (Object)".") ? INSTANCE.getCurrentDir() : (StringsKt.startsWith$default((String)absolutePath, (String)"./", (boolean)false, (int)2, null) ? new File(INSTANCE.getCurrentDir(), StringsKt.removePrefix((String)absolutePath, (CharSequence)"./")) : (StringsKt.startsWith$default((String)absolutePath, (String)".\\", (boolean)false, (int)2, null) ? new File(INSTANCE.getCurrentDir(), StringsKt.removePrefix((String)absolutePath, (CharSequence)".\\")) : (!StringsKt.startsWith$default((String)absolutePath, (String)"/", (boolean)false, (int)2, null) ? new File(INSTANCE.getCurrentDir(), absolutePath) : new File(absolutePath)))))));
        File file2 = file.getAbsoluteFile();
        Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"file.absoluteFile");
        return file2;
    }

    @JvmStatic
    public static final long size(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists()) {
            return 0L;
        }
        if (file.isDirectory()) {
            File[] fileArray = file.listFiles();
            if (fileArray == null) {
                return 0L;
            }
            File[] children = fileArray;
            long sum = 0L;
            for (File child : children) {
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                sum += FileUtils.size(child);
            }
            return sum;
        }
        return file.length();
    }

    @JvmStatic
    public static final long getTotalSpace(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return dir.exists() ? dir.getTotalSpace() : 0L;
    }

    @JvmStatic
    public static final long getFreeSpace(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return dir.exists() ? dir.getFreeSpace() : 0L;
    }

    @JvmStatic
    public static final boolean rename(@NotNull File from, @Nullable File to) {
        Intrinsics.checkNotNullParameter((Object)from, (String)"from");
        if (!from.exists()) {
            LogUtils.w("File not found, 'from' is: " + from);
            return false;
        }
        if (to == null) {
            LogUtils.w("File not found, 'to' is: " + to);
            return false;
        }
        FileUtils.deleteFile(to);
        return from.renameTo(to);
    }

    @JvmStatic
    public static final boolean mkdirs(@Nullable File dir) {
        if (dir == null) {
            return false;
        }
        return dir.exists() ? dir.isDirectory() : dir.mkdirs() || dir.isDirectory();
    }

    @JvmStatic
    public static final boolean createNewFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (file.exists() && file.isFile()) {
            FileUtils.deleteFile(file);
        }
        try {
            if (!FileUtils.mkdirs(file.getParentFile())) {
                LogUtils.w("mkdirs 'NewFile' parent failed: " + file.getParentFile().getAbsolutePath());
                return false;
            }
            return file.createNewFile();
        }
        catch (IOException e) {
            LogUtils.w(e);
            return false;
        }
    }

    @JvmStatic
    public static final boolean deleteFile(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        if (!file.exists()) {
            return true;
        }
        if (!file.isFile()) {
            LogUtils.w("deleteFile 'file' is not a file");
            return true;
        }
        return file.delete() || !file.exists();
    }

    @JvmStatic
    public static final boolean deleteDir(@NotNull File dir) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        if (!dir.exists()) {
            LogUtils.w("deleteDir 'dir' not exist: " + dir);
            return true;
        }
        if (!dir.isDirectory()) {
            LogUtils.w("deleteDir 'dir' is not a directory");
            return true;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            LogUtils.w("deleteDir 'dir' not a readable directory: " + dir);
            return false;
        }
        for (File file : files) {
            boolean delete = false;
            if (file.isDirectory()) {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                delete = FileUtils.deleteDir(file);
            } else {
                Intrinsics.checkNotNullExpressionValue((Object)file, (String)"file");
                delete = FileUtils.deleteFile(file);
            }
            if (delete) continue;
            LogUtils.w("delete failed : " + (file.isDirectory() ? "dir " : "file ") + file);
            return false;
        }
        return dir.delete() || !dir.exists();
    }

    @JvmStatic
    public static final boolean copy(@NotNull File source, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        if (!source.exists()) {
            LogUtils.w("copy source not exists : " + source + " to " + target);
            return true;
        }
        if (source.isDirectory()) {
            boolean mkdir = FileUtils.mkdirs(target);
            if (!mkdir) {
                LogUtils.w("mkdir dir failed : " + target);
                return false;
            }
            File[] childs = source.listFiles();
            if (childs == null) {
                LogUtils.w("copy source not a readable directory: " + source);
                return false;
            }
            if (childs.length == 0) {
                return true;
            }
            for (File child : childs) {
                Intrinsics.checkNotNullExpressionValue((Object)child, (String)"child");
                boolean copy = FileUtils.copy(child, new File(target, child.getName()));
                if (copy) continue;
                LogUtils.w("copy failed : " + source + " to " + target);
                return false;
            }
            return true;
        }
        if (source.isFile()) {
            File targetTempFile = new File(target.getParentFile(), target.getName() + "" + System.currentTimeMillis());
            if (!FileUtils.copyFile(source, targetTempFile)) {
                LogUtils.w("copy failed : " + source + " to " + target);
                return false;
            }
            return FileUtils.rename(targetTempFile, target);
        }
        LogUtils.w("copy source failed : " + source.getPath());
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    private static final boolean copyFile(File source, File target) {
        if (!source.exists()) {
            LogUtils.i("copyFile source not exists : " + source + " to " + target);
            return true;
        }
        if (source.length() == 0L) {
            return FileUtils.createNewFile(target);
        }
        boolean mkdir = FileUtils.mkdirs(target.getParentFile());
        if (!mkdir) {
            LogUtils.w("mkdir dir failed : " + target.getParentFile());
            return false;
        }
        boolean result = false;
        FileChannel fileChannel = null;
        FileChannel out = null;
        FileInputStream inStream = null;
        FileOutputStream outStream = null;
        try {
            inStream = new FileInputStream(source);
            outStream = new FileOutputStream(target);
            fileChannel = inStream.getChannel();
            out = outStream.getChannel();
            FileChannel fileChannel2 = fileChannel;
            Intrinsics.checkNotNull((Object)fileChannel2);
            long length = fileChannel2.transferTo(0L, fileChannel.size(), out);
            if (length >= 0L) {
                result = true;
            } else {
                LogUtils.w("copyFile transferTo failed : " + source + " to " + target);
                result = false;
            }
        }
        catch (IOException e) {
            LogUtils.w(e);
        }
        finally {
            IOUtilsKt.closeQuietly(fileChannel);
            IOUtilsKt.closeQuietly(out);
            IOUtilsKt.closeQuietly(inStream);
            IOUtilsKt.closeQuietly(outStream);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @JvmStatic
    public static final boolean copy(@NotNull InputStream stream, @NotNull File target) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        boolean mkdir = FileUtils.mkdirs(target.getParentFile());
        if (!mkdir) {
            return false;
        }
        boolean result = false;
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(target);
            IOUtils.copy(stream, fos);
            result = true;
        }
        catch (IOException e) {
            LogUtils.e(e);
        }
        finally {
            IOUtilsKt.closeQuietly(fos);
        }
        return result;
    }

    @JvmStatic
    @NotNull
    public static final String formatFileSize(long size) {
        if ((double)size > (double)0x40000000L * 1.2) {
            return fileSizeFormat.format((double)(size * (long)100 / 0x40000000L) * 0.01) + "GB";
        }
        if ((double)size > (double)0x100000L * 1.2) {
            return fileSizeFormat.format((double)(size * (long)100 / 0x100000L) * 0.01) + "MB";
        }
        if (size > 1024L) {
            return fileSizeFormat.format((double)(size * (long)100 / 1024L) * 0.01) + "KB";
        }
        return fileSizeFormat.format(size) + 'B';
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\u0004\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004\u00a8\u0006\u0005"}, d2={"Lcn/imkarl/core/common/file/FileUtils$SourceType;", "", "(Ljava/lang/String;I)V", "Java", "Kotlin", "Common"})
    public static final class SourceType
    extends Enum<SourceType> {
        public static final /* enum */ SourceType Java = new SourceType();
        public static final /* enum */ SourceType Kotlin = new SourceType();
        private static final /* synthetic */ SourceType[] $VALUES;

        public static SourceType[] values() {
            return (SourceType[])$VALUES.clone();
        }

        public static SourceType valueOf(String value) {
            return Enum.valueOf(SourceType.class, value);
        }

        static {
            $VALUES = sourceTypeArray = new SourceType[]{SourceType.Java, SourceType.Kotlin};
        }
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[SourceType.values().length];
            nArray[SourceType.Kotlin.ordinal()] = 1;
            nArray[SourceType.Java.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

