/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.file;

import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 1}, k=2, xi=48, d1={"\u0000\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0007\"\u0015\u0010\u0000\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0000\u0010\u0003\"\u0015\u0010\u0004\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0004\u0010\u0003\"\u0015\u0010\u0005\u001a\u00020\u0001*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0005\u0010\u0003\"\u0015\u0010\u0006\u001a\u00020\u0002*\u00020\u00028F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"isLink", "", "Ljava/io/File;", "(Ljava/io/File;)Z", "isLinkDirectory", "isLinkFile", "linkTargetFile", "getLinkTargetFile", "(Ljava/io/File;)Ljava/io/File;", "Common"})
public final class FileExtensionsKt {
    public static final boolean isLinkFile(@NotNull File $this$isLinkFile) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkFile, (String)"<this>");
        if (!FileExtensionsKt.isLink($this$isLinkFile)) {
            return false;
        }
        return !Files.isDirectory($this$isLinkFile.toPath(), new LinkOption[0]) && $this$isLinkFile.exists();
    }

    public static final boolean isLinkDirectory(@NotNull File $this$isLinkDirectory) {
        Intrinsics.checkNotNullParameter((Object)$this$isLinkDirectory, (String)"<this>");
        if (!FileExtensionsKt.isLink($this$isLinkDirectory)) {
            return false;
        }
        return Files.isDirectory($this$isLinkDirectory.toPath(), new LinkOption[0]);
    }

    public static final boolean isLink(@NotNull File $this$isLink) {
        Intrinsics.checkNotNullParameter((Object)$this$isLink, (String)"<this>");
        return Files.isSymbolicLink($this$isLink.toPath());
    }

    @NotNull
    public static final File getLinkTargetFile(@NotNull File $this$linkTargetFile) {
        File file;
        Intrinsics.checkNotNullParameter((Object)$this$linkTargetFile, (String)"<this>");
        if (FileExtensionsKt.isLinkDirectory($this$linkTargetFile)) {
            File file2 = $this$linkTargetFile.getAbsoluteFile();
            file = file2;
            Intrinsics.checkNotNullExpressionValue((Object)file2, (String)"this.absoluteFile");
        } else if (FileExtensionsKt.isLinkFile($this$linkTargetFile)) {
            File file3 = $this$linkTargetFile.getCanonicalFile();
            file = file3;
            Intrinsics.checkNotNullExpressionValue((Object)file3, (String)"this.canonicalFile");
        } else {
            file = $this$linkTargetFile;
        }
        return file;
    }
}

