/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.platform;

import cn.imkarl.core.common.log.LogLevel;
import cn.imkarl.core.common.platform.ConsoleColors;
import cn.imkarl.core.common.platform.Platform;
import cn.imkarl.core.common.platform.Platform$WhenMappings;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\b&\u0018\u0000 \n2\u00020\u0001:\u0002\n\u000bB\u0007\b\u0000\u00a2\u0006\u0002\u0010\u0002J \u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\bH\u0016\u00a8\u0006\f"}, d2={"Lcn/imkarl/core/common/platform/Platform;", "", "()V", "console", "", "level", "Lcn/imkarl/core/common/log/LogLevel;", "tag", "", "message", "Companion", "OSType", "Common"})
public abstract class Platform {
    @NotNull
    private static final Lazy instance$delegate;
    public static final Companion Companion;

    public void console(@NotNull LogLevel level, @NotNull String tag, @NotNull String message) {
        String string;
        Intrinsics.checkNotNullParameter((Object)((Object)level), (String)"level");
        Intrinsics.checkNotNullParameter((Object)tag, (String)"tag");
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        switch (Platform$WhenMappings.$EnumSwitchMapping$0[level.ordinal()]) {
            case 1: {
                string = ConsoleColors.Black.getAnsi();
                break;
            }
            case 2: {
                string = ConsoleColors.Green.getAnsi();
                break;
            }
            case 3: {
                string = ConsoleColors.Blue.getAnsi();
                break;
            }
            case 4: {
                string = ConsoleColors.Yellow.getAnsi();
                break;
            }
            case 5: {
                string = ConsoleColors.Red.getAnsi();
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        String colorAnsi = string;
        String string2 = ConsoleColors.Purple.getAnsi() + '[' + level.name() + "] " + colorAnsi + tag + ": " + message + ConsoleColors.Default.getAnsi();
        boolean bl = false;
        System.out.println((Object)string2);
    }

    static {
        Companion = new Companion(null);
        instance$delegate = LazyKt.lazy((Function0)Companion.instance.2.INSTANCE);
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\f\n\u0002\u0018\u0002\n\u0002\u0010\u0010\n\u0002\b\t\b\u0086\u0001\u0018\u00002\b\u0012\u0004\u0012\u00020\u00000\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002j\u0002\b\u0003j\u0002\b\u0004j\u0002\b\u0005j\u0002\b\u0006j\u0002\b\u0007j\u0002\b\bj\u0002\b\t\u00a8\u0006\n"}, d2={"Lcn/imkarl/core/common/platform/Platform$OSType;", "", "(Ljava/lang/String;I)V", "WINDOWS", "LINUX", "ANDROID", "SOLARIS", "MACOSX", "AIX", "UNKNOWN", "Common"})
    public static final class OSType
    extends Enum<OSType> {
        public static final /* enum */ OSType WINDOWS;
        public static final /* enum */ OSType LINUX;
        public static final /* enum */ OSType ANDROID;
        public static final /* enum */ OSType SOLARIS;
        public static final /* enum */ OSType MACOSX;
        public static final /* enum */ OSType AIX;
        public static final /* enum */ OSType UNKNOWN;
        private static final /* synthetic */ OSType[] $VALUES;

        static {
            OSType[] oSTypeArray = new OSType[7];
            OSType[] oSTypeArray2 = oSTypeArray;
            oSTypeArray[0] = WINDOWS = new OSType();
            oSTypeArray[1] = LINUX = new OSType();
            oSTypeArray[2] = ANDROID = new OSType();
            oSTypeArray[3] = SOLARIS = new OSType();
            oSTypeArray[4] = MACOSX = new OSType();
            oSTypeArray[5] = AIX = new OSType();
            oSTypeArray[6] = UNKNOWN = new OSType();
            $VALUES = oSTypeArray;
        }

        public static OSType[] values() {
            return (OSType[])$VALUES.clone();
        }

        public static OSType valueOf(String string) {
            return Enum.valueOf(OSType.class, string);
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006R\u0013\u0010\t\u001a\u0004\u0018\u00010\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcn/imkarl/core/common/platform/Platform$Companion;", "", "()V", "instance", "Lcn/imkarl/core/common/platform/Platform;", "getInstance", "()Lcn/imkarl/core/common/platform/Platform;", "instance$delegate", "Lkotlin/Lazy;", "osType", "Lcn/imkarl/core/common/platform/Platform$OSType;", "getOsType", "()Lcn/imkarl/core/common/platform/Platform$OSType;", "Common"})
    public static final class Companion {
        @NotNull
        public final Platform getInstance() {
            Lazy lazy = instance$delegate;
            Companion companion = Companion;
            Object var3_3 = null;
            boolean bl = false;
            return (Platform)lazy.getValue();
        }

        @Nullable
        public final OSType getOsType() {
            String osName = System.getProperty("os.name");
            if (osName != null) {
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Windows", (boolean)false, (int)2, null)) {
                    return OSType.WINDOWS;
                }
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Linux", (boolean)false, (int)2, null)) {
                    String httpAgent;
                    String string = System.getProperty("http.agent");
                    if (string == null) {
                        string = httpAgent = "";
                    }
                    if (StringsKt.contains$default((CharSequence)httpAgent, (CharSequence)"Android", (boolean)false, (int)2, null) && Class.forName("android.os.Build") != null) {
                        return OSType.ANDROID;
                    }
                    return OSType.LINUX;
                }
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"Solaris", (boolean)false, (int)2, null) || StringsKt.contains$default((CharSequence)osName, (CharSequence)"SunOS", (boolean)false, (int)2, null)) {
                    return OSType.SOLARIS;
                }
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"OS X", (boolean)false, (int)2, null)) {
                    return OSType.MACOSX;
                }
                if (StringsKt.contains$default((CharSequence)osName, (CharSequence)"AIX", (boolean)false, (int)2, null)) {
                    return OSType.AIX;
                }
            }
            return OSType.UNKNOWN;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

