/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.encode;

import cn.imkarl.core.common.log.LogUtils;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.Base64;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0012\n\u0002\b\n\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0015H\u0007J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\u00152\u0006\u0010\u0014\u001a\u00020\u0013H\u0007J\u0014\u0010\u0017\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u001a\u0010\u0018\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0004H\u0007J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\u00132\u0006\u0010\u0014\u001a\u00020\u0015H\u0007J\u0014\u0010\u001b\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013H\u0007J\u001a\u0010\u001c\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u00132\b\b\u0002\u0010\u0019\u001a\u00020\u0004H\u0007J\u0012\u0010\u001d\u001a\u0004\u0018\u00010\u00152\b\u0010\u001e\u001a\u0004\u0018\u00010\u0013R\u0019\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0016\u0010\b\u001a\n \u0005*\u0004\u0018\u00010\t0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0019\u0010\n\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\u0007R\u0019\u0010\f\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u0007R\u0019\u0010\u000e\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0007R\u0019\u0010\u0010\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0007\u00a8\u0006\u001f"}, d2={"Lcn/imkarl/core/common/encode/EncodeUtils;", "", "()V", "ISO_8859_1", "Ljava/nio/charset/Charset;", "kotlin.jvm.PlatformType", "getISO_8859_1", "()Ljava/nio/charset/Charset;", "PATTERN_UNICODE", "Ljava/util/regex/Pattern;", "UTF_16", "getUTF_16", "UTF_16BE", "getUTF_16BE", "UTF_16LE", "getUTF_16LE", "UTF_8", "getUTF_8", "bytesToHexString", "", "data", "", "decodeBase64", "decodeUnicode", "decodeUrl", "charset", "encodeBase64", "encodeUnicode", "encodeUrl", "hexStringToBytes", "str", "Common"})
public final class EncodeUtils {
    private static final Charset ISO_8859_1;
    private static final Charset UTF_8;
    private static final Charset UTF_16BE;
    private static final Charset UTF_16LE;
    private static final Charset UTF_16;
    private static final Pattern PATTERN_UNICODE;
    public static final EncodeUtils INSTANCE;

    public final Charset getISO_8859_1() {
        return ISO_8859_1;
    }

    public final Charset getUTF_8() {
        return UTF_8;
    }

    public final Charset getUTF_16BE() {
        return UTF_16BE;
    }

    public final Charset getUTF_16LE() {
        return UTF_16LE;
    }

    public final Charset getUTF_16() {
        return UTF_16;
    }

    @JvmStatic
    @Nullable
    public static final String encodeBase64(@NotNull byte[] data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            return Base64.getEncoder().encodeToString(data);
        }
        catch (Exception e) {
            LogUtils.e(e);
            return null;
        }
    }

    @JvmStatic
    @Nullable
    public static final byte[] decodeBase64(@NotNull String data) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        try {
            return Base64.getDecoder().decode(data);
        }
        catch (Exception e) {
            LogUtils.e(e);
            return null;
        }
    }

    @JvmStatic
    @NotNull
    public static final String encodeUrl(@NotNull String data, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        try {
            String string = URLEncoder.encode(data, charset.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLEncoder.encode(data, charset.name())");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            return data;
        }
    }

    public static /* synthetic */ String encodeUrl$default(String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset2 = UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        return EncodeUtils.encodeUrl(string, charset);
    }

    @JvmStatic
    @NotNull
    public static final String decodeUrl(@NotNull String data, @NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)charset, (String)"charset");
        try {
            String string = URLDecoder.decode(data, charset.name());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"URLDecoder.decode(data, charset.name())");
            return string;
        }
        catch (UnsupportedEncodingException e) {
            return data;
        }
    }

    public static /* synthetic */ String decodeUrl$default(String string, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset2 = UTF_8;
            Intrinsics.checkNotNullExpressionValue((Object)charset2, (String)"UTF_8");
            charset = charset2;
        }
        return EncodeUtils.decodeUrl(string, charset);
    }

    @JvmStatic
    @Nullable
    public static final String encodeUnicode(@Nullable String data) {
        if (data == null) {
            return null;
        }
        if (StringsKt.isBlank((CharSequence)data)) {
            return "";
        }
        StringBuilder unicodeBytes = new StringBuilder();
        String string = data;
        boolean bl = false;
        char[] cArray = string.toCharArray();
        Intrinsics.checkNotNullExpressionValue((Object)cArray, (String)"(this as java.lang.String).toCharArray()");
        for (char ch : cArray) {
            if (ch < '\n') {
                unicodeBytes.append("\\u000").append(Integer.toHexString(ch));
                continue;
            }
            if (Character.UnicodeBlock.of(ch) == Character.UnicodeBlock.BASIC_LATIN) {
                unicodeBytes.append(ch);
                continue;
            }
            String hex = Integer.toHexString(ch);
            if (hex.length() == 1) {
                unicodeBytes.append("\\u000").append(hex);
                continue;
            }
            if (hex.length() == 2) {
                unicodeBytes.append("\\u00").append(hex);
                continue;
            }
            if (hex.length() == 3) {
                unicodeBytes.append("\\u0").append(hex);
                continue;
            }
            if (hex.length() != 4) continue;
            unicodeBytes.append("\\u").append(hex);
        }
        return unicodeBytes.toString();
    }

    @JvmStatic
    @Nullable
    public static final String decodeUnicode(@Nullable String data) {
        if (data == null) {
            return null;
        }
        if (!StringsKt.contains$default((CharSequence)data, (CharSequence)"\\u", (boolean)false, (int)2, null)) {
            return data;
        }
        StringBuffer buf = new StringBuffer();
        Matcher matcher = PATTERN_UNICODE.matcher(data);
        while (matcher.find()) {
            try {
                matcher.appendReplacement(buf, "");
                buf.appendCodePoint(Integer.parseInt(matcher.group(1), 16));
            }
            catch (NumberFormatException numberFormatException) {}
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    @JvmStatic
    @Nullable
    public static final String bytesToHexString(@Nullable byte[] data) {
        block6: {
            block5: {
                if (data == null) break block5;
                byte[] byArray = data;
                boolean bl = false;
                if (!(byArray.length == 0)) break block6;
            }
            return null;
        }
        StringBuilder hexBuilder = new StringBuilder();
        for (byte b : data) {
            String hv = Integer.toHexString(b & 0xFF);
            if (hv.length() < 2) {
                hexBuilder.append(0);
            }
            hexBuilder.append(hv);
        }
        return hexBuilder.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Nullable
    public final byte[] hexStringToBytes(@Nullable String str) {
        CharSequence charSequence = str;
        boolean bl = false;
        int n = 0;
        if (charSequence == null || StringsKt.isBlank((CharSequence)charSequence)) {
            return null;
        }
        String string = str;
        Intrinsics.checkNotNull((Object)string);
        int length = string.length() / 2;
        byte[] bytes = new byte[length];
        n = 0;
        int n2 = length;
        while (n < n2) {
            void i;
            String string2 = str;
            void var7_9 = i * 2;
            void var8_10 = i * 2 + 2;
            boolean bl2 = false;
            String string3 = string2.substring((int)var7_9, (int)var8_10);
            Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            bytes[i] = (byte)Integer.valueOf(string3, 16).intValue();
            ++i;
        }
        return bytes;
    }

    private EncodeUtils() {
    }

    static {
        EncodeUtils encodeUtils;
        INSTANCE = encodeUtils = new EncodeUtils();
        ISO_8859_1 = Charset.forName("ISO-8859-1");
        UTF_8 = Charset.forName("UTF-8");
        UTF_16BE = Charset.forName("UTF-16BE");
        UTF_16LE = Charset.forName("UTF-16LE");
        UTF_16 = Charset.forName("UTF-16");
        PATTERN_UNICODE = Pattern.compile("\\\\u([0-9A-Fa-f]{4})");
    }
}

