/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.security;

import cn.imkarl.core.common.encode.EncodeUtils;
import cn.imkarl.core.common.file.IOUtilsKt;
import cn.imkarl.core.common.log.LogUtils;
import java.io.File;
import java.io.FileInputStream;
import java.nio.charset.Charset;
import java.security.DigestInputStream;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import javax.crypto.Mac;
import javax.crypto.spec.SecretKeySpec;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010\u000e\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001c\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\n\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\u000b\u001a\u0004\u0018\u00010\u00042\u0006\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u001a\u0010\f\u001a\u0004\u0018\u00010\u00062\u0006\u0010\t\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J$\u0010\r\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00042\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004H\u0002J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u000f\u001a\u0004\u0018\u00010\u0010J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0004J\u0012\u0010\u0011\u001a\u0004\u0018\u00010\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u0006\u00a8\u0006\u0012"}, d2={"Lcn/imkarl/core/common/security/EncryptUtils;", "", "()V", "hashTemplate", "", "algorithm", "", "data", "hmacMD5", "key", "hmacMD5ToString", "hmacSHA1", "hmacSHA1ToString", "hmacTemplate", "md5", "file", "Ljava/io/File;", "sha1", "common"})
public final class EncryptUtils {
    public static final EncryptUtils INSTANCE;

    @Nullable
    public final String md5(@Nullable String data) {
        if (data == null) {
            return null;
        }
        String string = data;
        EncryptUtils encryptUtils = this;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return encryptUtils.md5(byArray2);
    }

    @Nullable
    public final String md5(@Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hashTemplate("MD5", data));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public final String md5(@Nullable File file) {
        if (file == null) {
            return null;
        }
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            MessageDigest md = MessageDigest.getInstance("MD5");
            DigestInputStream digestInputStream = new DigestInputStream(fis, md);
            byte[] buffer = new byte[262144];
            while (digestInputStream.read(buffer) > 0) {
            }
            md = digestInputStream.getMessageDigest();
            String string = EncodeUtils.bytesToHexString(md.digest());
            return string;
        }
        catch (Exception e) {
            LogUtils.e(e);
            String string = null;
            return string;
        }
        finally {
            IOUtilsKt.closeQuietly(fis);
        }
    }

    @Nullable
    public final String sha1(@Nullable String data) {
        if (data == null) {
            return null;
        }
        String string = data;
        EncryptUtils encryptUtils = this;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        return encryptUtils.sha1(byArray2);
    }

    @Nullable
    public final String sha1(@Nullable byte[] data) {
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hashTemplate("SHA1", data));
    }

    @Nullable
    public final String hmacMD5ToString(@NotNull String key, @Nullable String data) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        EncryptUtils encryptUtils = this;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        string = data;
        charset = Charsets.UTF_8;
        byte[] byArray3 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray4 = byArray3;
        return encryptUtils.hmacMD5ToString(byArray2, byArray4);
    }

    @Nullable
    public final String hmacMD5ToString(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hmacMD5(key, data));
    }

    @Nullable
    public final byte[] hmacMD5(@NotNull String key, @Nullable String data) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        EncryptUtils encryptUtils = this;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        string = data;
        charset = Charsets.UTF_8;
        byte[] byArray3 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray4 = byArray3;
        return encryptUtils.hmacMD5(byArray2, byArray4);
    }

    @Nullable
    public final byte[] hmacMD5(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return this.hmacTemplate("HmacMD5", key, data);
    }

    @Nullable
    public final String hmacSHA1ToString(@NotNull String key, @Nullable String data) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        EncryptUtils encryptUtils = this;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        string = data;
        charset = Charsets.UTF_8;
        byte[] byArray3 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray4 = byArray3;
        return encryptUtils.hmacSHA1ToString(byArray2, byArray4);
    }

    @Nullable
    public final String hmacSHA1ToString(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return EncodeUtils.bytesToHexString(this.hmacSHA1(key, data));
    }

    @Nullable
    public final byte[] hmacSHA1(@NotNull String key, @Nullable String data) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        String string = key;
        EncryptUtils encryptUtils = this;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray2 = byArray;
        string = data;
        charset = Charsets.UTF_8;
        byte[] byArray3 = string.getBytes(charset);
        Intrinsics.checkExpressionValueIsNotNull((Object)byArray3, (String)"(this as java.lang.String).getBytes(charset)");
        byte[] byArray4 = byArray3;
        return encryptUtils.hmacSHA1(byArray2, byArray4);
    }

    @Nullable
    public final byte[] hmacSHA1(@NotNull byte[] key, @Nullable byte[] data) {
        Intrinsics.checkParameterIsNotNull((Object)key, (String)"key");
        if (data == null) {
            return null;
        }
        return this.hmacTemplate("HmacSHA1", key, data);
    }

    private final byte[] hashTemplate(String algorithm, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            if (data.length > 0) {
                MessageDigest md = MessageDigest.getInstance(algorithm);
                md.update(data);
                return md.digest();
            }
        }
        catch (NoSuchAlgorithmException e) {
            LogUtils.e(e);
        }
        return null;
    }

    private final byte[] hmacTemplate(String algorithm, byte[] key, byte[] data) {
        if (data == null) {
            return null;
        }
        try {
            if (key.length > 0 && data.length > 0) {
                Mac mac = Mac.getInstance(algorithm);
                SecretKeySpec secretKey = new SecretKeySpec(key, algorithm);
                mac.init(secretKey);
                return mac.doFinal(data);
            }
        }
        catch (InvalidKeyException e) {
            LogUtils.e(e);
        }
        catch (NoSuchAlgorithmException e) {
            LogUtils.e(e);
        }
        return null;
    }

    private EncryptUtils() {
    }

    static {
        EncryptUtils encryptUtils;
        INSTANCE = encryptUtils = new EncryptUtils();
    }
}

