/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.log;

import cn.imkarl.core.common.app.AppUtils;
import cn.imkarl.core.common.log.LogLevel;
import cn.imkarl.core.common.platform.Platform;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.net.UnknownHostException;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J \u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0002J\u0012\u0010\r\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010\r\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010\u000f\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010\u000f\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010\u0010\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010\u0010\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\"\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002J\"\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0007J\u001a\u0010\u0012\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\b\u0010\f\u001a\u0004\u0018\u00010\u0004H\u0007J\u0010\u0010\u0013\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u0004H\u0007J\u0010\u0010\u0014\u001a\u00020\b2\u0006\u0010\u0015\u001a\u00020\u0006H\u0007J\u0012\u0010\u0016\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0002J\u0012\u0010\u0017\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010\u0017\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u0012\u0010\u0018\u001a\u00020\b2\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007J\u001a\u0010\u0018\u001a\u00020\b2\u0006\u0010\u000b\u001a\u00020\u00042\b\u0010\u000e\u001a\u0004\u0018\u00010\u0001H\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcn/imkarl/core/common/log/LogUtils;", "", "()V", "_globalTag", "", "_maxOnceLength", "", "console", "", "level", "Lcn/imkarl/core/common/log/LogLevel;", "tag", "msg", "d", "message", "e", "i", "log", "println", "setGlobalTag", "setMaxOnceLength", "length", "toString", "v", "w", "common"})
public final class LogUtils {
    private static int _maxOnceLength;
    private static String _globalTag;
    public static final LogUtils INSTANCE;

    @JvmStatic
    public static final void setMaxOnceLength(int length) {
        _maxOnceLength = length;
    }

    @JvmStatic
    public static final void setGlobalTag(@NotNull String tag) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        _globalTag = tag;
    }

    @JvmStatic
    public static final void v(@Nullable Object message) {
        INSTANCE.log(LogLevel.VERBOSE, _globalTag, message);
    }

    @JvmStatic
    public static final void v(@NotNull String tag, @Nullable Object message) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        INSTANCE.log(LogLevel.VERBOSE, tag, message);
    }

    @JvmStatic
    public static final void d(@Nullable Object message) {
        INSTANCE.log(LogLevel.DEBUG, _globalTag, message);
    }

    @JvmStatic
    public static final void d(@NotNull String tag, @Nullable Object message) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        INSTANCE.log(LogLevel.DEBUG, tag, message);
    }

    @JvmStatic
    public static final void i(@Nullable Object message) {
        INSTANCE.log(LogLevel.INFO, _globalTag, message);
    }

    @JvmStatic
    public static final void i(@NotNull String tag, @Nullable Object message) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        INSTANCE.log(LogLevel.INFO, tag, message);
    }

    @JvmStatic
    public static final void w(@Nullable Object message) {
        INSTANCE.log(LogLevel.WARN, _globalTag, message);
    }

    @JvmStatic
    public static final void w(@NotNull String tag, @Nullable Object message) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        INSTANCE.log(LogLevel.WARN, tag, message);
    }

    @JvmStatic
    public static final void e(@Nullable Object message) {
        INSTANCE.log(LogLevel.ERROR, _globalTag, message);
    }

    @JvmStatic
    public static final void e(@NotNull String tag, @Nullable Object message) {
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        INSTANCE.log(LogLevel.ERROR, tag, message);
    }

    @JvmStatic
    public static final void println(@NotNull LogLevel level, @Nullable String msg) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        if (!AppUtils.isDebug()) {
            return;
        }
        INSTANCE.console(level, _globalTag, INSTANCE.toString(msg));
    }

    @JvmStatic
    public static final void println(@NotNull LogLevel level, @NotNull String tag, @Nullable String msg) {
        Intrinsics.checkParameterIsNotNull((Object)((Object)level), (String)"level");
        Intrinsics.checkParameterIsNotNull((Object)tag, (String)"tag");
        if (!AppUtils.isDebug()) {
            return;
        }
        INSTANCE.console(level, tag, INSTANCE.toString(msg));
    }

    private final void log(LogLevel level, String tag, Object message) {
        String className;
        StackTraceElement element;
        if (!AppUtils.isDebug()) {
            return;
        }
        StackTraceElement stackTraceElement = element = new Throwable().getStackTrace()[2];
        Intrinsics.checkExpressionValueIsNotNull((Object)stackTraceElement, (String)"element");
        String string = className = stackTraceElement.getClassName();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"className");
        String string2 = string;
        int n = StringsKt.lastIndexOf$default((CharSequence)className, (String)".", (int)0, (boolean)false, (int)6, null) + 1;
        String string3 = string2;
        if (string3 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string4 = string3.substring(n);
        Intrinsics.checkExpressionValueIsNotNull((Object)string4, (String)"(this as java.lang.String).substring(startIndex)");
        className = string4;
        String codeLine = className + '.' + element.getMethodName() + '(' + element.getFileName() + ':' + element.getLineNumber() + ')';
        this.console(level, tag, codeLine + "\n\t" + this.toString(message));
    }

    private final void console(LogLevel level, String tag, String msg) {
        if (msg.length() <= _maxOnceLength) {
            Platform.Companion.getInstance().console(level, tag, msg);
            return;
        }
        int startIndex = 0;
        int endIndex = _maxOnceLength;
        while (endIndex > startIndex) {
            String string;
            String string2 = msg;
            StringBuilder stringBuilder = new StringBuilder().append(startIndex == 0 ? "" : "\t\u2191\u2191\u2191\u2191\n");
            String string3 = tag;
            LogLevel logLevel = level;
            Platform platform = Platform.Companion.getInstance();
            String string4 = string2;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            Intrinsics.checkExpressionValueIsNotNull((Object)string4.substring(startIndex, endIndex), (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            platform.console(logLevel, string3, String.valueOf(stringBuilder.append(string).toString()));
            startIndex = endIndex;
            endIndex = Math.min(msg.length(), startIndex + _maxOnceLength);
        }
    }

    private final String toString(Object message) {
        if (message == null) {
            return "[NULL]";
        }
        if (message instanceof Throwable) {
            for (Throwable t = (Throwable)message; t != null; t = t.getCause()) {
                if (!(t instanceof UnknownHostException)) continue;
                return t.toString();
            }
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter((Writer)sw, false);
            ((Throwable)message).printStackTrace(pw);
            pw.flush();
            String string = sw.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"sw.toString()");
            return string;
        }
        return message.toString();
    }

    private LogUtils() {
    }

    static {
        LogUtils logUtils;
        INSTANCE = logUtils = new LogUtils();
        _maxOnceLength = 3000;
        _globalTag = AppUtils.getAppName();
    }
}

