/*
 * Decompiled with CFR 0.152.
 */
package cn.imkarl.core.common.file;

import cn.imkarl.core.common.encode.EncodeUtils;
import cn.imkarl.core.common.log.LogUtils;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import kotlin.Metadata;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 11}, bv={1, 0, 2}, k=1, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0007J\u001a\u0010\u000b\u001a\u00020\f2\u0006\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\r\u001a\u00020\u000eH\u0007R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcn/imkarl/core/common/file/IOUtils;", "", "()V", "BUFFER_SIZE", "", "copy", "", "source", "Ljava/io/InputStream;", "target", "Ljava/io/OutputStream;", "copyToString", "", "charset", "Ljava/nio/charset/Charset;", "common"})
public final class IOUtils {
    private static final int BUFFER_SIZE = 4096;
    public static final IOUtils INSTANCE;

    @JvmStatic
    public static final long copy(@NotNull InputStream source, @NotNull OutputStream target) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)target, (String)"target");
        try {
            long total = 0L;
            byte[] buffer = new byte[4096];
            int length = source.read(buffer);
            while (length >= 0) {
                target.write(buffer, 0, length);
                total += (long)length;
                length = source.read(buffer);
            }
            target.flush();
            return total;
        }
        catch (IOException e) {
            LogUtils.w(e);
            return -1L;
        }
    }

    @JvmStatic
    @NotNull
    public static final String copyToString(@NotNull InputStream source, @NotNull Charset charset) {
        Intrinsics.checkParameterIsNotNull((Object)source, (String)"source");
        Intrinsics.checkParameterIsNotNull((Object)charset, (String)"charset");
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        BufferedInputStream bufferedInputStream = new BufferedInputStream(source);
        IOUtils.copy(bufferedInputStream, out);
        String string = out.toString(charset.name());
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"out.toString(charset.name())");
        return string;
    }

    @JvmStatic
    @NotNull
    public static /* bridge */ /* synthetic */ String copyToString$default(InputStream inputStream, Charset charset, int n, Object object) {
        if ((n & 2) != 0) {
            Charset charset2 = EncodeUtils.INSTANCE.getUTF_8();
            Intrinsics.checkExpressionValueIsNotNull((Object)charset2, (String)"EncodeUtils.UTF_8");
            charset = charset2;
        }
        return IOUtils.copyToString(inputStream, charset);
    }

    private IOUtils() {
    }

    static {
        IOUtils iOUtils;
        INSTANCE = iOUtils = new IOUtils();
    }
}

