/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.boot.web.embedded.tompuss;

import cn.imaq.tompuss.core.TPEngine;
import cn.imaq.tompuss.servlet.TPServletContext;
import java.io.File;
import java.util.EventListener;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import javax.servlet.ServletContextListener;
import javax.servlet.ServletException;
import org.springframework.boot.web.embedded.tompuss.TomPussWebServer;
import org.springframework.boot.web.server.WebServer;
import org.springframework.boot.web.servlet.ServletContextInitializer;
import org.springframework.boot.web.servlet.server.AbstractServletWebServerFactory;

public class TomPussServletWebServerFactory
extends AbstractServletWebServerFactory {
    public WebServer getWebServer(ServletContextInitializer ... initializers) {
        TomPussWebServer webServer = new TomPussWebServer(this.getPort());
        this.prepareContext(webServer.getEngine(), initializers);
        return webServer;
    }

    private void prepareContext(TPEngine engine, final ServletContextInitializer ... initializers) {
        File documentRoot = this.getValidDocumentRoot();
        final TPServletContext context = engine.newWebApp(this.getContextPath(), this.getContextPath(), documentRoot);
        if (this.shouldRegisterJspServlet()) {
            context.enableJsp();
        }
        context.addListener((EventListener)new ServletContextListener(){

            @Override
            public void contextInitialized(ServletContextEvent sce) {
                for (ServletContextInitializer initializer : initializers) {
                    try {
                        initializer.onStartup((ServletContext)context);
                    }
                    catch (ServletException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
    }
}

