/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.server.scanner;

import cn.imaq.autumn.core.beans.BeanInfo;
import cn.imaq.autumn.core.beans.creator.BeanCreator;
import cn.imaq.autumn.core.beans.creator.NormalBeanCreator;
import cn.imaq.autumn.core.beans.scanner.BeanScanner;
import cn.imaq.autumn.core.context.AutumnContext;
import cn.imaq.autumn.cpscan.ScanResult;
import cn.imaq.autumn.rpc.server.annotation.AutumnRPCExpose;
import cn.imaq.autumn.rpc.server.annotation.AutumnRPCInterface;
import cn.imaq.autumn.rpc.server.context.RpcContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutumnRPCBeanScanner
implements BeanScanner {
    private static final Logger log = LoggerFactory.getLogger(AutumnRPCBeanScanner.class);

    public void process(ScanResult result, AutumnContext context) {
        RpcContext rpcContext = RpcContext.getFrom(context);
        result.getClassesWithAnnotation(AutumnRPCExpose.class).forEach(cls -> {
            log.info("RPC Exposing: {}", (Object)cls.getName());
            rpcContext.registerService((Class<?>)cls);
            for (Class<?> intf : cls.getInterfaces()) {
                if (!intf.isAnnotationPresent(AutumnRPCInterface.class)) continue;
                rpcContext.registerService(intf.getName(), (Class<?>)cls);
            }
            context.addBeanInfo(BeanInfo.builder().type(cls).singleton(true).creator((BeanCreator)new NormalBeanCreator(cls)).build());
        });
    }
}

