/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.server.net;

import cn.imaq.autumn.rpc.server.handler.RpcRequestHandler;
import cn.imaq.autumn.rpc.server.net.RpcHttpRequest;
import cn.imaq.autumn.rpc.server.net.RpcHttpResponse;
import cn.imaq.autumn.rpc.server.net.RpcHttpServer;
import com.sun.net.httpserver.HttpServer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.util.concurrent.Executors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SunHttpServer
implements RpcHttpServer {
    private static final Logger log = LoggerFactory.getLogger(SunHttpServer.class);
    private HttpServer httpServer;

    @Override
    public void configure(String host, int port, RpcRequestHandler requestHandler) {
        try {
            this.httpServer = HttpServer.create(new InetSocketAddress(host, port), 0);
            this.httpServer.setExecutor(Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors()));
            this.httpServer.createContext("/", req -> {
                InputStream is = req.getRequestBody();
                byte[] buf = new byte[is.available()];
                is.read(buf);
                is.close();
                RpcHttpResponse response = requestHandler.handle(RpcHttpRequest.builder().method(req.getRequestMethod()).path(req.getRequestURI().getPath()).body(buf).build());
                req.getResponseHeaders().set("Content-Type", response.getContentType());
                req.sendResponseHeaders(response.getCode(), response.getBody().length);
                OutputStream os = req.getResponseBody();
                os.write(response.getBody());
                os.close();
            });
        }
        catch (IOException e) {
            log.error("Error creating HTTP server: {}", (Object)String.valueOf(e));
        }
    }

    @Override
    public synchronized void start() {
        this.httpServer.start();
    }

    @Override
    public synchronized void stop() {
        this.httpServer.stop(0);
    }
}

