/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.server.invoke;

import cn.imaq.autumn.rpc.exception.RpcSerializationException;
import cn.imaq.autumn.rpc.serialization.RpcSerialization;
import cn.imaq.autumn.rpc.server.exception.RpcInvocationException;
import cn.imaq.autumn.rpc.server.invoke.RpcMethod;
import cn.imaq.autumn.rpc.server.invoke.RpcMethodInvoker;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectionInvoker
implements RpcMethodInvoker {
    private Map<RpcMethod, Method> methodCache = new ConcurrentHashMap<RpcMethod, Method>();

    @Override
    public Object invoke(Object instance, RpcMethod method, Object[] params, RpcSerialization serialization) throws RpcInvocationException, InvocationTargetException {
        try {
            Method realMethod = this.methodCache.get(method);
            if (realMethod == null) {
                if (method.getParamTypes() != null) {
                    realMethod = instance.getClass().getMethod(method.getName(), method.getParamTypes());
                } else {
                    for (Method m : instance.getClass().getMethods()) {
                        if (!m.getName().equals(method.getName()) || m.getParameterCount() != method.getParamCount().intValue()) continue;
                        realMethod = m;
                        break;
                    }
                    if (realMethod == null) {
                        throw new NoSuchMethodException();
                    }
                }
                this.methodCache.put(method, realMethod);
            }
            params = serialization.convertTypes(params, realMethod.getGenericParameterTypes());
            return realMethod.invoke(instance, params);
        }
        catch (RpcSerializationException | IllegalAccessException | NoSuchMethodException e) {
            throw new RpcInvocationException(e);
        }
    }
}

