/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.server.invoke;

import cn.imaq.autumn.rpc.serialization.RpcSerialization;
import cn.imaq.autumn.rpc.server.asm.MethodAccess;
import cn.imaq.autumn.rpc.server.exception.RpcInvocationException;
import cn.imaq.autumn.rpc.server.invoke.RpcMethod;
import cn.imaq.autumn.rpc.server.invoke.RpcMethodInvoker;
import java.lang.reflect.InvocationTargetException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ReflectAsmInvoker
implements RpcMethodInvoker {
    private Map<Class<?>, MethodAccess> methodAccessCache = new ConcurrentHashMap();
    private Map<RpcMethod, Integer> methodIndexCache = new ConcurrentHashMap<RpcMethod, Integer>();

    @Override
    public Object invoke(Object instance, RpcMethod method, Object[] params, RpcSerialization serialization) throws RpcInvocationException, InvocationTargetException {
        try {
            MethodAccess ma = this.methodAccessCache.computeIfAbsent(instance.getClass(), k -> MethodAccess.get(instance.getClass()));
            Integer methodIndex = this.methodIndexCache.get(method);
            if (methodIndex == null) {
                methodIndex = method.getParamTypes() != null ? Integer.valueOf(ma.getIndex(method.getName(), method.getParamTypes())) : Integer.valueOf(ma.getIndex(method.getName(), method.getParamCount()));
                this.methodIndexCache.put(method, methodIndex);
            }
            params = serialization.convertTypes(params, ma.getGenericTypes()[methodIndex]);
            return ma.invoke(instance, methodIndex, params);
        }
        catch (IllegalArgumentException e) {
            throw new RpcInvocationException(e);
        }
        catch (Throwable t) {
            throw new InvocationTargetException(t);
        }
    }
}

