/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.server.handler;

import cn.imaq.autumn.core.context.AutumnContext;
import cn.imaq.autumn.rpc.exception.RpcSerializationException;
import cn.imaq.autumn.rpc.net.RpcRequest;
import cn.imaq.autumn.rpc.net.RpcResponse;
import cn.imaq.autumn.rpc.serialization.RpcSerialization;
import cn.imaq.autumn.rpc.server.config.RpcServerConfig;
import cn.imaq.autumn.rpc.server.context.RpcContext;
import cn.imaq.autumn.rpc.server.exception.RpcInvocationException;
import cn.imaq.autumn.rpc.server.handler.RpcRequestHandler;
import cn.imaq.autumn.rpc.server.invoke.RpcMethod;
import cn.imaq.autumn.rpc.server.invoke.RpcMethodInvoker;
import cn.imaq.autumn.rpc.server.net.RpcHttpRequest;
import cn.imaq.autumn.rpc.server.net.RpcHttpResponse;
import java.lang.reflect.InvocationTargetException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutumnRpcRequestHandler
implements RpcRequestHandler {
    private static final Logger log = LoggerFactory.getLogger(AutumnRpcRequestHandler.class);
    private final byte[] INFO_400 = "<html><head><title>400 Bad Request</title></head><body><center><h1>400 Bad Request</h1></center><hr><center>AutumnRPC</center></body></html>".getBytes();
    private final byte[] INFO_500 = "<html><head><title>500 Internal Server Error</title></head><body><center><h1>500 Internal Server Error</h1></center><hr><center>AutumnRPC</center></body></html>".getBytes();
    private final RpcServerConfig config;
    private final RpcContext rpcContext;
    private final AutumnContext context;
    private final RpcMethodInvoker invoker;
    private final RpcSerialization serialization;

    public AutumnRpcRequestHandler(RpcServerConfig config, AutumnContext context) {
        this.config = config;
        this.context = context;
        this.rpcContext = RpcContext.getFrom(context);
        this.invoker = config.getMethodInvoker();
        log.info("Using invoker: {}", (Object)this.invoker.getClass().getSimpleName());
        this.serialization = config.getSerialization();
        log.info("Using serialization {}", (Object)this.serialization.getClass().getSimpleName());
    }

    @Override
    public RpcHttpResponse handle(RpcHttpRequest request) {
        String serviceName;
        Object instance;
        log.debug("Received HTTP request: {} {}", (Object)request.getMethod(), (Object)request.getPath());
        if (request.getPath().equals("/")) {
            String configStr = this.config.toConfigStr();
            return this.ok("text/plain", configStr.getBytes());
        }
        String[] paths = request.getPath().split("/");
        if (paths.length >= 2 && (instance = this.context.getBeanByType(this.rpcContext.findServiceClass(serviceName = paths[1]))) != null) {
            byte[] body = request.getBody();
            try {
                RpcRequest rpcRequest = this.serialization.deserializeRequest(body);
                try {
                    Object result = this.invoker.invoke(instance, new RpcMethod(instance.getClass(), rpcRequest.getMethodName(), rpcRequest.getParams().length, rpcRequest.getParamTypes()), rpcRequest.getParams(), this.serialization);
                    return this.ok(this.serialization.contentType(), this.serialization.serializeResponse(RpcResponse.builder().status(0).result(result).resultType(result == null ? null : result.getClass()).build()));
                }
                catch (RpcInvocationException e) {
                    log.error("Error invoking {}#{}: {}", new Object[]{serviceName, rpcRequest.getMethodName(), String.valueOf(e.getCause())});
                    return this.error();
                }
                catch (InvocationTargetException e) {
                    return this.ok(this.serialization.contentType(), this.serialization.serializeResponse(RpcResponse.builder().status(-1).result((Object)e.getCause()).resultType(e.getCause().getClass()).build()));
                }
            }
            catch (RpcSerializationException e) {
                log.error("Error parsing request: {}", (Object)e.toString());
            }
        }
        return this.badRequest();
    }

    private RpcHttpResponse ok(String contentType, byte[] body) {
        return RpcHttpResponse.builder().code(200).contentType(contentType).body(body).build();
    }

    private RpcHttpResponse badRequest() {
        return RpcHttpResponse.builder().code(400).contentType("text/html").body(this.INFO_400).build();
    }

    private RpcHttpResponse error() {
        return RpcHttpResponse.builder().code(400).contentType("text/html").body(this.INFO_500).build();
    }
}

