/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.server.context;

import cn.imaq.autumn.core.context.AutumnContext;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RpcContext {
    private static final Logger log = LoggerFactory.getLogger(RpcContext.class);
    public static final String ATTR = RpcContext.class.getName();
    private final Map<String, Class<?>> services = new HashMap();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static RpcContext getFrom(AutumnContext context) {
        RpcContext rpcContext = (RpcContext)context.getAttribute(ATTR);
        if (rpcContext == null) {
            AutumnContext autumnContext = context;
            synchronized (autumnContext) {
                rpcContext = (RpcContext)context.getAttribute(ATTR);
                if (rpcContext == null) {
                    rpcContext = new RpcContext();
                    context.setAttribute(ATTR, (Object)rpcContext);
                }
            }
        }
        return rpcContext;
    }

    public Class<?> findServiceClass(String serviceName) {
        return this.services.get(serviceName);
    }

    public void registerService(String serviceName, Class<?> serviceClass) {
        log.info("Registering service {} => {}", (Object)serviceName, (Object)serviceClass.getName());
        if (this.services.put(serviceName, serviceClass) != null) {
            log.warn("{} has multiple implementations, replacing with {}", (Object)serviceName, (Object)serviceClass.getName());
        }
    }

    public void registerService(Class<?> serviceClass) {
        this.registerService(serviceClass.getName(), serviceClass);
    }

    public List<String> getRegisteredServiceNames() {
        return Collections.unmodifiableList(new ArrayList<String>(this.services.keySet()));
    }
}

