/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.server;

import cn.imaq.autumn.core.context.AutumnContext;
import cn.imaq.autumn.rpc.server.config.RpcServerConfig;
import cn.imaq.autumn.rpc.server.handler.AutumnRpcRequestHandler;
import cn.imaq.autumn.rpc.server.net.RpcHttpServer;
import cn.imaq.autumn.rpc.util.AutumnRPCBanner;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutumnRPCServer {
    private static final Logger log = LoggerFactory.getLogger(AutumnRPCServer.class);
    private AutumnContext context;
    private RpcServerConfig config;
    private RpcHttpServer httpServer;

    public AutumnRPCServer(AutumnContext context) {
        this.context = context;
    }

    public AutumnRPCServer(AutumnContext context, RpcServerConfig config) {
        this.context = context;
        this.config = config;
    }

    public synchronized void start() throws IOException {
        this.stop();
        AutumnRPCBanner.printBanner();
        if (this.config == null) {
            this.config = (RpcServerConfig)((Object)this.context.getBeanByType(RpcServerConfig.class));
            if (this.config == null) {
                log.info("No RpcServerConfig beans found in Autumn context, using default config");
                this.config = RpcServerConfig.builder().build();
            }
        }
        AutumnRpcRequestHandler handler = new AutumnRpcRequestHandler(this.config, this.context);
        this.httpServer = this.config.getHttpServer();
        log.info("Using HTTP server: {}", (Object)this.httpServer.getClass().getSimpleName());
        this.httpServer.configure(this.config.getHost(), this.config.getPort(), handler);
        log.warn("Starting HTTP server ...");
        try {
            this.httpServer.start();
            log.warn("Bootstrap finished");
        }
        catch (IOException e) {
            log.error("Error starting server: {}", (Object)String.valueOf(e));
            throw e;
        }
    }

    public synchronized void stop() throws IOException {
        if (this.httpServer != null) {
            try {
                this.httpServer.stop();
            }
            catch (IOException e) {
                log.error("Error stopping server: {}", (Object)String.valueOf(e));
                throw e;
            }
        }
    }
}

