/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.cluster.config;

import cn.imaq.autumn.rpc.cluster.config.RpcClusterConfigBase;
import cn.imaq.autumn.rpc.server.config.RpcServerConfig;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class RpcClusterServerConfig
extends RpcClusterConfigBase {
    private RpcServerConfig serverConfig;
    private String advertiseHost;

    private static String getFirstNonLoopbackIPv4Address() {
        try {
            Enumeration<NetworkInterface> interfaces = NetworkInterface.getNetworkInterfaces();
            while (interfaces.hasMoreElements()) {
                NetworkInterface i = interfaces.nextElement();
                Enumeration<InetAddress> addresses = i.getInetAddresses();
                while (addresses.hasMoreElements()) {
                    InetAddress addr = addresses.nextElement();
                    if (addr.isLoopbackAddress() || !(addr instanceof Inet4Address)) continue;
                    return addr.getHostAddress();
                }
            }
        }
        catch (SocketException socketException) {
            // empty catch block
        }
        return null;
    }

    private static RpcServerConfig $default$serverConfig() {
        return RpcServerConfig.builder().build();
    }

    private static String $default$advertiseHost() {
        return RpcClusterServerConfig.getFirstNonLoopbackIPv4Address();
    }

    protected RpcClusterServerConfig(RpcClusterServerConfigBuilder<?, ?> b) {
        super(b);
        this.serverConfig = ((RpcClusterServerConfigBuilder)b).serverConfig$set ? ((RpcClusterServerConfigBuilder)b).serverConfig$value : RpcClusterServerConfig.$default$serverConfig();
        this.advertiseHost = ((RpcClusterServerConfigBuilder)b).advertiseHost$set ? ((RpcClusterServerConfigBuilder)b).advertiseHost$value : RpcClusterServerConfig.$default$advertiseHost();
    }

    public static RpcClusterServerConfigBuilder<?, ?> builder() {
        return new RpcClusterServerConfigBuilderImpl();
    }

    public RpcServerConfig getServerConfig() {
        return this.serverConfig;
    }

    public String getAdvertiseHost() {
        return this.advertiseHost;
    }

    public void setServerConfig(RpcServerConfig serverConfig) {
        this.serverConfig = serverConfig;
    }

    public void setAdvertiseHost(String advertiseHost) {
        this.advertiseHost = advertiseHost;
    }

    private static final class RpcClusterServerConfigBuilderImpl
    extends RpcClusterServerConfigBuilder<RpcClusterServerConfig, RpcClusterServerConfigBuilderImpl> {
        private RpcClusterServerConfigBuilderImpl() {
        }

        @Override
        protected RpcClusterServerConfigBuilderImpl self() {
            return this;
        }

        @Override
        public RpcClusterServerConfig build() {
            return new RpcClusterServerConfig(this);
        }
    }

    public static abstract class RpcClusterServerConfigBuilder<C extends RpcClusterServerConfig, B extends RpcClusterServerConfigBuilder<C, B>>
    extends RpcClusterConfigBase.RpcClusterConfigBaseBuilder<C, B> {
        private boolean serverConfig$set;
        private RpcServerConfig serverConfig$value;
        private boolean advertiseHost$set;
        private String advertiseHost$value;

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B serverConfig(RpcServerConfig serverConfig) {
            this.serverConfig$value = serverConfig;
            this.serverConfig$set = true;
            return (B)this.self();
        }

        public B advertiseHost(String advertiseHost) {
            this.advertiseHost$value = advertiseHost;
            this.advertiseHost$set = true;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "RpcClusterServerConfig.RpcClusterServerConfigBuilder(super=" + super.toString() + ", serverConfig$value=" + this.serverConfig$value + ", advertiseHost$value=" + this.advertiseHost$value + ")";
        }
    }
}

