/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.cluster;

import cn.imaq.autumn.core.context.AutumnContext;
import cn.imaq.autumn.rpc.cluster.config.RpcClusterServerConfig;
import cn.imaq.autumn.rpc.registry.ServiceProviderEntry;
import cn.imaq.autumn.rpc.registry.exception.RpcRegistryException;
import cn.imaq.autumn.rpc.server.AutumnRPCServer;
import cn.imaq.autumn.rpc.server.context.RpcContext;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutumnRPCClusterServer {
    private static final Logger log = LoggerFactory.getLogger(AutumnRPCClusterServer.class);
    private AutumnContext context;
    private RpcClusterServerConfig clusterServerConfig;
    private AutumnRPCServer rpcServer;

    public AutumnRPCClusterServer(AutumnContext context, RpcClusterServerConfig clusterServerConfig) {
        this.context = context;
        this.clusterServerConfig = clusterServerConfig;
        this.rpcServer = new AutumnRPCServer(context, clusterServerConfig.getServerConfig());
    }

    public synchronized void start() throws RpcRegistryException, IOException {
        try {
            this.clusterServerConfig.getRegistry().start();
        }
        catch (RpcRegistryException e) {
            log.error("Failed to start registry: {}", (Object)String.valueOf((Object)e));
            throw e;
        }
        this.rpcServer.start();
        RpcContext rpcContext = RpcContext.getFrom((AutumnContext)this.context);
        for (String serviceName : rpcContext.getRegisteredServiceNames()) {
            try {
                this.clusterServerConfig.getRegistry().register(ServiceProviderEntry.builder().serviceName(serviceName).host(this.clusterServerConfig.getAdvertiseHost()).port(this.clusterServerConfig.getServerConfig().getPort()).configStr(this.clusterServerConfig.getServerConfig().toConfigStr()).build());
            }
            catch (RpcRegistryException e) {
                log.error("Failed to register service {}: {}", (Object)serviceName, (Object)String.valueOf((Object)e));
            }
        }
    }

    public synchronized void stop() throws IOException {
        RpcContext rpcContext = RpcContext.getFrom((AutumnContext)this.context);
        for (String serviceName : rpcContext.getRegisteredServiceNames()) {
            try {
                this.clusterServerConfig.getRegistry().deregister(ServiceProviderEntry.builder().serviceName(serviceName).host(this.clusterServerConfig.getAdvertiseHost()).port(this.clusterServerConfig.getServerConfig().getPort()).configStr(this.clusterServerConfig.getServerConfig().toConfigStr()).build());
            }
            catch (RpcRegistryException e) {
                log.error("Failed to deregister service {}: {}", (Object)serviceName, (Object)String.valueOf((Object)e));
            }
        }
        this.rpcServer.stop();
        try {
            this.clusterServerConfig.getRegistry().stop();
        }
        catch (RpcRegistryException e) {
            log.error("Failed to stop registry: {}", (Object)String.valueOf((Object)e));
        }
    }
}

