/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.cluster;

import cn.imaq.autumn.rpc.client.AutumnRPCClient;
import cn.imaq.autumn.rpc.client.config.RpcClientConfig;
import cn.imaq.autumn.rpc.cluster.config.RpcClusterClientConfig;
import cn.imaq.autumn.rpc.cluster.loadbalance.LoadBalancer;
import cn.imaq.autumn.rpc.config.RpcConfigBase;
import cn.imaq.autumn.rpc.registry.ServiceProviderEntry;
import cn.imaq.autumn.rpc.registry.exception.RpcRegistryException;
import cn.imaq.autumn.rpc.server.exception.RpcInvocationException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutumnRPCClusterClient {
    private static final Logger log = LoggerFactory.getLogger(AutumnRPCClusterClient.class);
    private RpcClusterClientConfig config;
    private Map<ServiceProviderEntry, AutumnRPCClient> rpcClients = new ConcurrentHashMap<ServiceProviderEntry, AutumnRPCClient>();

    public AutumnRPCClusterClient(RpcClusterClientConfig config) {
        this.config = config;
        log.info("Using HTTP client: {}", (Object)config.getHttpClient().getClass().getName());
        log.info("Using proxy: {}", (Object)config.getProxy().getClass().getName());
        try {
            config.getRegistry().start();
        }
        catch (RpcRegistryException e) {
            log.error("Failed to start registry: {}", (Object)String.valueOf((Object)e));
        }
    }

    public Object invoke(Class<?> serviceClass, Method method, Object[] args, int timeoutMs, LoadBalancer loadBalancer) throws Throwable {
        String serviceName = serviceClass.getName();
        List providers = this.config.getRegistry().lookup(serviceName);
        if (providers.size() == 0) {
            throw new RpcInvocationException("No providers found for service " + serviceName);
        }
        ServiceProviderEntry provider = loadBalancer.select(providers, serviceName, method);
        AutumnRPCClient rpcClient = this.rpcClients.computeIfAbsent(provider, p -> {
            RpcClientConfig clientConfig = RpcClientConfig.builder().timeoutMs(this.config.getDefaultTimeoutMs()).httpClient(this.config.getHttpClient()).proxy(this.config.getProxy()).build();
            RpcConfigBase.applyConfigStr((String)provider.getConfigStr(), (RpcConfigBase)clientConfig);
            return new AutumnRPCClient(provider.getHost(), provider.getPort(), clientConfig, false);
        });
        return rpcClient.invoke(serviceClass, method, args, timeoutMs);
    }

    public Object invoke(Class<?> serviceClass, Method method, Object[] args) throws Throwable {
        return this.invoke(serviceClass, method, args, this.config.getDefaultTimeoutMs(), this.config.getDefaultLoadBalancer());
    }

    public <T> T getProxy(Class<T> serviceClass, int timeoutMs, LoadBalancer loadBalancer) {
        try {
            this.config.getRegistry().subscribe(serviceClass.getName());
        }
        catch (RpcRegistryException e) {
            log.error("Failed to subscribe {}: {}", (Object)serviceClass.getName(), (Object)String.valueOf((Object)e));
        }
        return (T)this.config.getProxy().create(serviceClass, (proxy, method, args) -> this.invoke(serviceClass, method, args, timeoutMs, loadBalancer));
    }

    public <T> T getProxy(Class<T> serviceClass, LoadBalancer loadBalancer) {
        return this.getProxy(serviceClass, this.config.getDefaultTimeoutMs(), loadBalancer);
    }

    public <T> T getProxy(Class<T> serviceClass) {
        return this.getProxy(serviceClass, this.config.getDefaultTimeoutMs(), this.config.getDefaultLoadBalancer());
    }
}

