/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.client;

import cn.imaq.autumn.rpc.client.config.RpcClientConfig;
import cn.imaq.autumn.rpc.client.net.RpcHttpClient;
import cn.imaq.autumn.rpc.client.proxy.RpcProxy;
import cn.imaq.autumn.rpc.config.RpcConfigBase;
import cn.imaq.autumn.rpc.net.RpcRequest;
import cn.imaq.autumn.rpc.net.RpcResponse;
import cn.imaq.autumn.rpc.serialization.RpcSerialization;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutumnRPCClient {
    private static final Logger log = LoggerFactory.getLogger(AutumnRPCClient.class);
    private String host;
    private int port;
    private RpcClientConfig config;
    private RpcHttpClient httpClient;
    private RpcProxy proxy;
    private RpcSerialization serialization;

    public AutumnRPCClient(String host, int port, RpcClientConfig config, boolean useAutoConfig) {
        this.host = host;
        this.port = port;
        this.config = config;
        this.httpClient = config.getHttpClient();
        log.info("Using HTTP client: {}", (Object)this.httpClient.getClass().getSimpleName());
        if (useAutoConfig) {
            log.info("Fetching config from server ...");
            try {
                String configStr = new String(this.httpClient.get("http://" + host + ":" + port, config.getTimeoutMs()));
                RpcConfigBase.applyConfigStr((String)configStr, (RpcConfigBase)config);
            }
            catch (Exception e) {
                log.error("Auto config error: {}", (Object)String.valueOf(e));
            }
        }
        this.proxy = config.getProxy();
        log.info("Using proxy: {}", (Object)this.proxy.getClass().getSimpleName());
        this.serialization = config.getSerialization();
        log.info("Using serialization: {}", (Object)this.serialization.getClass().getSimpleName());
    }

    public AutumnRPCClient(String host, int port) {
        this(host, port, (RpcClientConfig)RpcClientConfig.builder().build(), true);
    }

    public AutumnRPCClient(String host, int port, RpcClientConfig config) {
        this(host, port, config, false);
    }

    public Object invoke(Class<?> serviceClass, Method method, Object[] args) throws Throwable {
        return this.invoke(serviceClass, method, args, this.config.getTimeoutMs());
    }

    public Object invoke(Class<?> serviceClass, Method method, Object[] args, int timeoutMs) throws Throwable {
        Class<?> returnType;
        RpcRequest request;
        byte[] payload;
        String url = "http://" + this.host + ":" + this.port + "/" + serviceClass.getName();
        byte[] response = this.httpClient.post(url, payload = this.serialization.serializeRequest(request = RpcRequest.builder().methodName(method.getName()).paramTypes((Class[])method.getParameterTypes()).params(args).build()), this.serialization.contentType(), timeoutMs);
        RpcResponse rpcResponse = this.serialization.deserializeResponse(response, returnType = method.getReturnType());
        if (rpcResponse.getStatus() == 0) {
            if (returnType == Void.TYPE || returnType == Void.class) {
                return null;
            }
            return this.serialization.convertTypes(new Object[]{rpcResponse.getResult()}, new Type[]{method.getGenericReturnType()})[0];
        }
        throw (Throwable)rpcResponse.getResult();
    }

    public <T> T getService(Class<T> serviceClass) {
        return this.getService(serviceClass, this.config.getTimeoutMs());
    }

    public <T> T getService(Class<T> serviceClass, int timeoutMs) {
        return this.proxy.create(serviceClass, (proxy, method, args) -> this.invoke(serviceClass, method, args, timeoutMs));
    }
}

