/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rpc.client;

import cn.imaq.autumn.rpc.client.net.RPCHttpClient;
import cn.imaq.autumn.rpc.client.net.RPCHttpClientFactory;
import cn.imaq.autumn.rpc.client.proxy.AutumnProxy;
import cn.imaq.autumn.rpc.client.proxy.AutumnProxyFactory;
import cn.imaq.autumn.rpc.net.AutumnRPCRequest;
import cn.imaq.autumn.rpc.net.AutumnRPCResponse;
import cn.imaq.autumn.rpc.serialization.AutumnSerialization;
import cn.imaq.autumn.rpc.serialization.AutumnSerializationFactory;
import cn.imaq.autumn.rpc.util.PropertiesUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutumnRPCClient {
    private static final Logger log = LoggerFactory.getLogger(AutumnRPCClient.class);
    private static final String DEFAULT_CONFIG = "autumn-rpc-client-default.properties";
    private String host;
    private int port;
    private Properties config = new Properties();
    private RPCHttpClient httpClient;
    private AutumnProxy proxy;
    private AutumnSerialization serialization;

    public AutumnRPCClient(String host, int port, String configFile, boolean useAutoConfig) {
        this.host = host;
        this.port = port;
        try {
            PropertiesUtil.load((Properties)this.config, (String)DEFAULT_CONFIG, (String)configFile);
        }
        catch (IOException e) {
            log.error("Error loading config: {}", (Object)String.valueOf(e));
        }
        if (useAutoConfig) {
            log.info("Fetching config from server ...");
            try {
                JsonNode configJson = new ObjectMapper().readTree(new URL("http://" + host + ":" + port));
                log.info("Fetched {} config entries from server", (Object)configJson.size());
                Iterator it = configJson.fields();
                while (it.hasNext()) {
                    Map.Entry entry = (Map.Entry)it.next();
                    this.config.setProperty((String)entry.getKey(), ((JsonNode)entry.getValue()).textValue());
                }
            }
            catch (IOException e) {
                log.error("Auto config error: {}", (Object)String.valueOf(e));
            }
        }
        this.httpClient = RPCHttpClientFactory.getHttpClient(this.config.getProperty("autumn.httpclient"));
        log.info("Using HTTP client: {}", (Object)this.httpClient.getClass().getSimpleName());
        this.proxy = AutumnProxyFactory.getProxy(this.config.getProperty("autumn.proxy"));
        log.info("Using proxy: {}", (Object)this.proxy.getClass().getSimpleName());
        this.serialization = AutumnSerializationFactory.getSerialization((String)this.config.getProperty("autumn.serialization"));
        log.info("Using serialization: {}", (Object)this.serialization.getClass().getSimpleName());
    }

    public AutumnRPCClient(String host, int port) {
        this(host, port, null, true);
    }

    public AutumnRPCClient(String host, int port, String configFile) {
        this(host, port, configFile, false);
    }

    public AutumnRPCClient(String host, int port, boolean useAutoConfig) {
        this(host, port, null, useAutoConfig);
    }

    public <T> T getService(Class<T> interfaze) {
        return this.getService(interfaze, 3000);
    }

    public <T> T getService(Class<T> interfaze, int timeout) {
        return this.proxy.create(interfaze, (proxy, method, args) -> {
            Class<?> returnType;
            AutumnRPCRequest request;
            byte[] payload;
            String url = "http://" + this.host + ":" + this.port + "/" + interfaze.getName();
            byte[] response = this.httpClient.post(url, payload = this.serialization.serializeRequest(request = AutumnRPCRequest.builder().methodName(method.getName()).paramTypes((Class[])method.getParameterTypes()).params(args).build()), this.serialization.contentType(), timeout);
            AutumnRPCResponse rpcResponse = this.serialization.deserializeResponse(response, returnType = method.getReturnType());
            if (rpcResponse.getStatus() == 0) {
                if (returnType == Void.TYPE || returnType == Void.class) {
                    return null;
                }
                return this.serialization.convertTypes(new Object[]{rpcResponse.getResult()}, new Type[]{method.getGenericReturnType()})[0];
            }
            throw (Throwable)rpcResponse.getResult();
        });
    }
}

