/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rest.servlet;

import cn.imaq.autumn.rest.core.RestContext;
import cn.imaq.autumn.rest.message.MessageConverter;
import cn.imaq.autumn.rest.model.ExceptionHandlerModel;
import cn.imaq.autumn.rest.model.RequestMappingModel;
import cn.imaq.autumn.rest.param.resolver.MethodParamsResolver;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DispatcherServlet
extends HttpServlet {
    private static final Logger log = LoggerFactory.getLogger(DispatcherServlet.class);
    private RestContext restContext;
    private MethodParamsResolver paramsResolver = new MethodParamsResolver();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void init() throws ServletException {
        ServletContext context = this.getServletContext();
        this.restContext = (RestContext)context.getAttribute(RestContext.ATTR);
        if (this.restContext == null) {
            ServletContext servletContext = context;
            synchronized (servletContext) {
                this.restContext = (RestContext)context.getAttribute(RestContext.ATTR);
                if (this.restContext == null) {
                    this.restContext = RestContext.build();
                    context.setAttribute(RestContext.ATTR, (Object)this.restContext);
                }
            }
        }
        log.info("DispatcherServlet initialized");
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HandlerResult result;
        RequestMappingModel rmModel = this.restContext.matchRequestMapping(req);
        if (rmModel == null || rmModel.getMethod() == null) {
            resp.sendError(404);
            return;
        }
        Method rmMethod = rmModel.getMethod();
        Class<?> controllerClass = rmMethod.getDeclaringClass();
        try {
            Object[] rmParams = this.paramsResolver.resolveAll(rmMethod, req, resp);
            Object controller = this.restContext.getApplicationContext().getBeanByType(controllerClass);
            result = this.invokeHandlerMethod(controller, rmMethod, rmParams, rmModel.getProduces(), rmModel.getConverter());
        }
        catch (Throwable t) {
            log.error("Exception invoking {}: {}", (Object)rmMethod, (Object)String.valueOf(t));
            ExceptionHandlerModel ehModel = this.restContext.matchExceptionHandler(controllerClass, t.getClass());
            if (ehModel == null) {
                throw new ServletException(t);
            }
            Method ehMethod = ehModel.getMethod();
            try {
                Object[] ehParams = this.paramsResolver.resolveAllWithThrowable(ehMethod, req, resp, t);
                Object eHandler = this.restContext.getApplicationContext().getBeanByType(ehMethod.getDeclaringClass());
                result = this.invokeHandlerMethod(eHandler, ehMethod, ehParams, ehModel.getProduces(), ehModel.getConverter());
                resp.setStatus(ehModel.getStatusCode());
            }
            catch (Throwable t1) {
                log.error("Exception when handing exception {}: {}", (Object)String.valueOf(t), (Object)String.valueOf(t1));
                throw new ServletException(t1);
            }
        }
        resp.setContentType(result.getContentType());
        resp.getOutputStream().write(result.getBody());
    }

    private HandlerResult invokeHandlerMethod(Object handler, Method method, Object[] params, String produces, Class<? extends MessageConverter> converterClass) throws Throwable {
        byte[] body;
        Object result;
        String contentType = produces;
        try {
            result = method.invoke(handler, params);
        }
        catch (InvocationTargetException e) {
            throw e.getCause();
        }
        if (result instanceof String) {
            body = ((String)result).getBytes(StandardCharsets.UTF_8);
        } else if (result instanceof byte[]) {
            body = (byte[])result;
        } else {
            MessageConverter converter = this.restContext.getInstance(converterClass);
            body = converter.toBytes(result);
            contentType = converter.getContentType();
        }
        return new HandlerResult(contentType, body);
    }

    private class HandlerResult {
        private String contentType;
        private byte[] body;

        public String getContentType() {
            return this.contentType;
        }

        public byte[] getBody() {
            return this.body;
        }

        public void setContentType(String contentType) {
            this.contentType = contentType;
        }

        public void setBody(byte[] body) {
            this.body = body;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof HandlerResult)) {
                return false;
            }
            HandlerResult other = (HandlerResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$contentType = this.getContentType();
            String other$contentType = other.getContentType();
            if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
                return false;
            }
            return Arrays.equals(this.getBody(), other.getBody());
        }

        protected boolean canEqual(Object other) {
            return other instanceof HandlerResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $contentType = this.getContentType();
            result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
            result = result * 59 + Arrays.hashCode(this.getBody());
            return result;
        }

        public String toString() {
            return "DispatcherServlet.HandlerResult(contentType=" + this.getContentType() + ", body=" + Arrays.toString(this.getBody()) + ")";
        }

        public HandlerResult(String contentType, byte[] body) {
            this.contentType = contentType;
            this.body = body;
        }
    }
}

