/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rest.scanner;

import cn.imaq.autumn.core.beans.BeanInfo;
import cn.imaq.autumn.core.beans.creator.BeanCreator;
import cn.imaq.autumn.core.beans.creator.NormalBeanCreator;
import cn.imaq.autumn.core.beans.scanner.BeanScanner;
import cn.imaq.autumn.core.context.AutumnContext;
import cn.imaq.autumn.cpscan.ScanResult;
import cn.imaq.autumn.rest.annotation.ControllerAdvice;
import cn.imaq.autumn.rest.annotation.ExceptionHandler;
import cn.imaq.autumn.rest.core.RestContext;
import cn.imaq.autumn.rest.model.ControllerAdviceModel;
import cn.imaq.autumn.rest.model.ExceptionHandlerModel;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ControllerAdviceBeanScanner
implements BeanScanner {
    private static final Logger log = LoggerFactory.getLogger(ControllerAdviceBeanScanner.class);

    public void process(ScanResult result, AutumnContext context) {
        RestContext restContext = (RestContext)context.getAttribute(RestContext.ATTR);
        if (restContext != null) {
            result.getClassesWithAnnotation(ControllerAdvice.class).forEach(cls -> {
                log.info("Found controller advice {}", (Object)cls.getName());
                context.addBeanInfo(BeanInfo.builder().name(cls.getSimpleName().toLowerCase()).type(cls).singleton(true).creator((BeanCreator)new NormalBeanCreator(cls)).build());
                ControllerAdvice ca = cls.getAnnotation(ControllerAdvice.class);
                ControllerAdviceModel caModel = new ControllerAdviceModel(ca);
                for (Method method : cls.getDeclaredMethods()) {
                    if (!method.isAnnotationPresent(ExceptionHandler.class)) continue;
                    method.setAccessible(true);
                    ExceptionHandler eh = method.getAnnotation(ExceptionHandler.class);
                    restContext.addExceptionHandler(new ExceptionHandlerModel(eh, caModel, method));
                }
            });
        }
    }
}

