/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rest.param.resolver.annotated;

import cn.imaq.autumn.rest.annotation.param.RequestBody;
import cn.imaq.autumn.rest.core.RestContext;
import cn.imaq.autumn.rest.message.MessageConverter;
import cn.imaq.autumn.rest.param.resolver.AnnotatedParamResolver;
import cn.imaq.autumn.rest.param.value.ParamValue;
import cn.imaq.autumn.rest.param.value.SingleValue;
import cn.imaq.autumn.rest.util.IOUtil;
import java.io.InputStream;
import java.lang.reflect.Parameter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class RequestBodyResolver
extends AnnotatedParamResolver<RequestBody> {
    @Override
    protected ParamValue resolve(Parameter param, RequestBody anno, HttpServletRequest request, HttpServletResponse response) {
        try {
            byte[] bytes = IOUtil.readInputStream((InputStream)request.getInputStream());
            Class<Object> paramType = param.getType();
            if (paramType.isAssignableFrom(byte[].class) || paramType.isAssignableFrom(String.class)) {
                return new SingleValue<byte[]>(bytes);
            }
            RestContext restContext = (RestContext)request.getServletContext().getAttribute(RestContext.ATTR);
            if (restContext != null) {
                MessageConverter converter = restContext.getInstance(anno.converter());
                return new SingleValue<Object>(converter.fromBytes(bytes, param.getParameterizedType()));
            }
            return new SingleValue<Object>(null);
        }
        catch (Exception e) {
            return new SingleValue<byte[]>(new byte[0]);
        }
    }
}

