/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rest.param.resolver;

import cn.imaq.autumn.cpscan.AutumnClasspathScan;
import cn.imaq.autumn.cpscan.ScanResult;
import cn.imaq.autumn.rest.annotation.param.JSON;
import cn.imaq.autumn.rest.exception.ParamConvertException;
import cn.imaq.autumn.rest.exception.ParamResolveException;
import cn.imaq.autumn.rest.param.converter.CollectionConverter;
import cn.imaq.autumn.rest.param.converter.ParamConverter;
import cn.imaq.autumn.rest.param.resolver.AnnotatedParamResolver;
import cn.imaq.autumn.rest.param.resolver.ParamResolver;
import cn.imaq.autumn.rest.param.resolver.TypedParamResolver;
import cn.imaq.autumn.rest.param.value.ParamValue;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MethodParamsResolver {
    private static final Logger log = LoggerFactory.getLogger(MethodParamsResolver.class);
    private static Map<Class<? extends Annotation>, AnnotatedParamResolver> annotatedResolvers = new HashMap<Class<? extends Annotation>, AnnotatedParamResolver>();
    private static List<TypedParamResolver> typedResolvers = new ArrayList<TypedParamResolver>();
    private static Map<Class<?>, ParamConverter> typeConverters = new HashMap();
    private static CollectionConverter collectionConverter = new CollectionConverter();
    private static volatile boolean init = false;
    private ObjectMapper jsonMapper = new ObjectMapper();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void ensureInit() {
        if (init) return;
        Class<MethodParamsResolver> clazz = MethodParamsResolver.class;
        synchronized (MethodParamsResolver.class) {
            if (init) return;
            log.info("Initializing param resolvers and converters ...");
            ScanResult result = AutumnClasspathScan.getGlobalScanResult();
            result.getSubClassesOf(AnnotatedParamResolver.class).forEach(c -> {
                try {
                    AnnotatedParamResolver resolver = (AnnotatedParamResolver)c.newInstance();
                    Class annotationClass = resolver.getAnnotationClass();
                    if (annotationClass != null) {
                        annotatedResolvers.put(resolver.getAnnotationClass(), resolver);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            result.getSubClassesOf(TypedParamResolver.class).forEach(c -> {
                try {
                    typedResolvers.add((TypedParamResolver)c.newInstance());
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            result.getClassesImplementing(ParamConverter.class).forEach(c -> {
                try {
                    ParamConverter converter = (ParamConverter)c.newInstance();
                    for (Class<?> targetType : converter.getTargetTypes()) {
                        typeConverters.put(targetType, converter);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
            });
            init = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public Object[] resolveAll(Method method, HttpServletRequest req, HttpServletResponse resp) throws ParamResolveException {
        return this.resolveAllWithThrowable(method, req, resp, null);
    }

    public Object[] resolveAllWithThrowable(Method method, HttpServletRequest req, HttpServletResponse resp, Throwable throwable) throws ParamResolveException {
        MethodParamsResolver.ensureInit();
        Parameter[] params = method.getParameters();
        Object[] rawValues = new Object[params.length];
        for (int i = 0; i < params.length; ++i) {
            Object rawValue;
            Parameter param = params[i];
            if (throwable != null && param.getType().isInstance(throwable)) {
                rawValues[i] = throwable;
                continue;
            }
            ParamResolver resolver = null;
            for (Class<? extends Annotation> annoClass : annotatedResolvers.keySet()) {
                if (!param.isAnnotationPresent(annoClass)) continue;
                resolver = annotatedResolvers.get(annoClass);
                break;
            }
            if (resolver == null) {
                Class<? extends Annotation> annoClass;
                Class paramType = param.getType();
                annoClass = typedResolvers.iterator();
                while (annoClass.hasNext()) {
                    TypedParamResolver typedResolver = (TypedParamResolver)annoClass.next();
                    if (!paramType.isAssignableFrom(typedResolver.getType())) continue;
                    resolver = typedResolver;
                    break;
                }
            }
            if (resolver == null) {
                throw new ParamResolveException("No suitable resolvers found for param " + param);
            }
            ParamValue value = resolver.resolve(param, req, resp);
            if (value == null) {
                throw new ParamResolveException("No suitable resolvers found for param " + param);
            }
            try {
                rawValue = param.isAnnotationPresent(JSON.class) ? this.convertFromJson(param, value) : this.convertParam(param, value);
            }
            catch (ParamConvertException e) {
                throw new ParamResolveException(e);
            }
            rawValues[i] = rawValue;
        }
        return rawValues;
    }

    private Object convertParam(Parameter param, ParamValue value) throws ParamConvertException {
        Collection rawValue;
        Class<?> paramType = param.getType();
        if (paramType.isInstance(value.getSingleValue())) {
            return value.getSingleValue();
        }
        boolean needMultipleValues = paramType.isArray() || Collection.class.isAssignableFrom(paramType);
        Collection collection = rawValue = needMultipleValues ? value.getMultipleValues() : value.getSingleValue();
        if (rawValue != null) {
            try {
                if (needMultipleValues) {
                    Type innerType;
                    Collection valueCollection = rawValue;
                    if (paramType.isArray()) {
                        Class<?> innerType2 = paramType.getComponentType();
                        return this.convertMultiple(valueCollection, innerType2);
                    }
                    Type type = param.getParameterizedType();
                    if (type instanceof ParameterizedType && (innerType = ((ParameterizedType)type).getActualTypeArguments()[0]) instanceof Class) {
                        valueCollection = Arrays.asList((Object[])this.convertMultiple(valueCollection, (Class)innerType));
                    }
                    return collectionConverter.convert(valueCollection, paramType);
                }
                return this.convertSingle(rawValue, paramType);
            }
            catch (ParamConvertException e) {
                try {
                    return this.convertFromJson(param, value);
                }
                catch (ParamConvertException e1) {
                    throw new ParamConvertException("Cannot convert param " + param + ", tried all converters");
                }
            }
        }
        return null;
    }

    private Object convertFromJson(Parameter param, ParamValue value) throws ParamConvertException {
        Object singleValue = value.getSingleValue();
        try {
            if (singleValue instanceof String) {
                return this.jsonMapper.readValue((String)singleValue, this.jsonMapper.constructType(param.getParameterizedType()));
            }
            if (singleValue instanceof byte[]) {
                return this.jsonMapper.readValue((byte[])singleValue, this.jsonMapper.constructType(param.getParameterizedType()));
            }
            if (singleValue instanceof TreeNode) {
                return this.jsonMapper.convertValue(singleValue, this.jsonMapper.constructType(param.getParameterizedType()));
            }
        }
        catch (IOException e) {
            throw new ParamConvertException(e);
        }
        throw new ParamConvertException("Param cannot be converted as JSON");
    }

    private <T> T convertSingle(Object src, Class<T> targetType) throws ParamConvertException {
        ParamConverter converter = typeConverters.get(targetType);
        if (converter == null) {
            throw new ParamConvertException("Unable to find converter to " + targetType.getName());
        }
        return converter.convert(src, targetType);
    }

    private Object convertMultiple(Collection<?> src, Class<?> targetType) throws ParamConvertException {
        ParamConverter converter = null;
        Object results = Array.newInstance(targetType, src.size());
        int index = 0;
        for (Object o : src) {
            if (targetType.isInstance(o)) {
                Array.set(results, index, o);
            } else {
                if (converter == null) {
                    converter = typeConverters.get(targetType);
                }
                if (converter == null) {
                    throw new ParamConvertException("Unable to find converter to " + targetType.getName());
                }
                Array.set(results, index, converter.convert(o, targetType));
            }
            ++index;
        }
        return results;
    }
}

