/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rest.param.converter;

import cn.imaq.autumn.rest.exception.ParamConvertException;
import cn.imaq.autumn.rest.param.converter.ParamConverter;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.Arrays;
import java.util.List;

public class NumberConverter
implements ParamConverter {
    @Override
    public List<Class<?>> getTargetTypes() {
        return Arrays.asList(Number.class, Byte.class, Short.class, Integer.class, Long.class, Float.class, Double.class, Byte.TYPE, Short.TYPE, Integer.TYPE, Long.TYPE, Float.TYPE, Double.TYPE);
    }

    @Override
    public <T> T convert(Object src, Class<T> targetType) throws ParamConvertException {
        Number number;
        if (src instanceof Number) {
            number = (Number)src;
        } else if (src instanceof String) {
            try {
                number = NumberFormat.getInstance().parse((String)src);
            }
            catch (ParseException e) {
                throw new ParamConvertException(e);
            }
        } else {
            throw new ParamConvertException(src, targetType);
        }
        if (Byte.class == targetType || Byte.TYPE == targetType) {
            return (T)Byte.valueOf(number.byteValue());
        }
        if (Short.class == targetType || Short.TYPE == targetType) {
            return (T)Short.valueOf(number.shortValue());
        }
        if (Integer.class == targetType || Integer.TYPE == targetType) {
            return (T)Integer.valueOf(number.intValue());
        }
        if (Long.class == targetType || Long.TYPE == targetType) {
            return (T)Long.valueOf(number.longValue());
        }
        if (Float.class == targetType || Float.TYPE == targetType) {
            return (T)Float.valueOf(number.floatValue());
        }
        if (Double.class == targetType || Double.TYPE == targetType) {
            return (T)Double.valueOf(number.doubleValue());
        }
        throw new ParamConvertException(src, targetType);
    }
}

