/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rest.param.converter;

import cn.imaq.autumn.rest.exception.ParamConvertException;
import cn.imaq.autumn.rest.param.converter.ParamConverter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Deque;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.NavigableSet;
import java.util.Queue;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;

public class CollectionConverter
implements ParamConverter {
    @Override
    public List<Class<?>> getTargetTypes() {
        return Arrays.asList(Collection.class, List.class, Set.class, SortedSet.class, NavigableSet.class, Queue.class, Deque.class);
    }

    @Override
    public <T> T convert(Object src, Class<T> targetType) throws ParamConvertException {
        List<Object> srcCollection;
        if (src instanceof Collection) {
            srcCollection = (List<Object>)src;
        } else if (src instanceof Object[]) {
            srcCollection = Arrays.asList((Object[])src);
        } else {
            throw new ParamConvertException(src, targetType);
        }
        if (targetType == Collection.class) {
            return (T)srcCollection;
        }
        if (targetType == List.class) {
            return (T)new ArrayList<Object>(srcCollection);
        }
        if (targetType == Set.class) {
            return (T)new LinkedHashSet<Object>(srcCollection);
        }
        if (targetType == SortedSet.class || targetType == NavigableSet.class) {
            return (T)new TreeSet<Object>(srcCollection);
        }
        if (targetType == Queue.class || targetType == Deque.class) {
            return (T)new ArrayDeque<Object>(srcCollection);
        }
        throw new ParamConvertException(src, targetType);
    }
}

