/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rest.model;

import cn.imaq.autumn.rest.annotation.RequestMapping;
import cn.imaq.autumn.rest.core.RequestMethod;
import cn.imaq.autumn.rest.message.DefaultConverterDelegate;
import cn.imaq.autumn.rest.message.MessageConverter;
import cn.imaq.autumn.rest.util.PathUtil;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.Set;
import java.util.stream.Collectors;

public class RequestMappingModel {
    private Set<String> paths;
    private Set<RequestMethod> methods = Collections.emptySet();
    private Set<String> consumes = Collections.emptySet();
    private String produces;
    private Class<? extends MessageConverter> converter;
    private Method method;

    private RequestMappingModel() {
    }

    public static RequestMappingModel fromAnnotation(RequestMapping rm) {
        RequestMappingModel model = new RequestMappingModel();
        model.setPaths(Arrays.stream(rm.value()).map(PathUtil::transform).collect(Collectors.toSet()));
        if (rm.method().length > 0) {
            model.setMethods(EnumSet.copyOf(Arrays.asList(rm.method())));
        }
        if (rm.consumes().length > 0) {
            model.setConsumes(new HashSet<String>(Arrays.asList(rm.consumes())));
        }
        model.setProduces(rm.produces());
        model.setConverter(rm.converter());
        return model;
    }

    public void combine(RequestMappingModel parent) {
        HashSet<String> newPaths = new HashSet<String>();
        for (String parentPath : parent.getPaths()) {
            if (parentPath.equals("/")) {
                parentPath = "";
            }
            for (String path : this.getPaths()) {
                newPaths.add(parentPath + path);
            }
        }
        this.setPaths(newPaths);
        if (this.methods.isEmpty()) {
            this.methods = parent.getMethods();
        }
        if (this.consumes.isEmpty()) {
            this.consumes = parent.getConsumes();
        }
        if (this.getConverter().equals(DefaultConverterDelegate.class)) {
            this.converter = parent.converter;
        }
    }

    public Set<String> getPaths() {
        return this.paths;
    }

    public Set<RequestMethod> getMethods() {
        return this.methods;
    }

    public Set<String> getConsumes() {
        return this.consumes;
    }

    public String getProduces() {
        return this.produces;
    }

    public Class<? extends MessageConverter> getConverter() {
        return this.converter;
    }

    public Method getMethod() {
        return this.method;
    }

    public void setPaths(Set<String> paths) {
        this.paths = paths;
    }

    public void setMethods(Set<RequestMethod> methods) {
        this.methods = methods;
    }

    public void setConsumes(Set<String> consumes) {
        this.consumes = consumes;
    }

    public void setProduces(String produces) {
        this.produces = produces;
    }

    public void setConverter(Class<? extends MessageConverter> converter) {
        this.converter = converter;
    }

    public void setMethod(Method method) {
        this.method = method;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RequestMappingModel)) {
            return false;
        }
        RequestMappingModel other = (RequestMappingModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Set<String> this$paths = this.getPaths();
        Set<String> other$paths = other.getPaths();
        if (this$paths == null ? other$paths != null : !((Object)this$paths).equals(other$paths)) {
            return false;
        }
        Set<RequestMethod> this$methods = this.getMethods();
        Set<RequestMethod> other$methods = other.getMethods();
        if (this$methods == null ? other$methods != null : !((Object)this$methods).equals(other$methods)) {
            return false;
        }
        Set<String> this$consumes = this.getConsumes();
        Set<String> other$consumes = other.getConsumes();
        if (this$consumes == null ? other$consumes != null : !((Object)this$consumes).equals(other$consumes)) {
            return false;
        }
        String this$produces = this.getProduces();
        String other$produces = other.getProduces();
        if (this$produces == null ? other$produces != null : !this$produces.equals(other$produces)) {
            return false;
        }
        Class<? extends MessageConverter> this$converter = this.getConverter();
        Class<? extends MessageConverter> other$converter = other.getConverter();
        if (this$converter == null ? other$converter != null : !this$converter.equals(other$converter)) {
            return false;
        }
        Method this$method = this.getMethod();
        Method other$method = other.getMethod();
        return !(this$method == null ? other$method != null : !((Object)this$method).equals(other$method));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RequestMappingModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Set<String> $paths = this.getPaths();
        result = result * 59 + ($paths == null ? 43 : ((Object)$paths).hashCode());
        Set<RequestMethod> $methods = this.getMethods();
        result = result * 59 + ($methods == null ? 43 : ((Object)$methods).hashCode());
        Set<String> $consumes = this.getConsumes();
        result = result * 59 + ($consumes == null ? 43 : ((Object)$consumes).hashCode());
        String $produces = this.getProduces();
        result = result * 59 + ($produces == null ? 43 : $produces.hashCode());
        Class<? extends MessageConverter> $converter = this.getConverter();
        result = result * 59 + ($converter == null ? 43 : $converter.hashCode());
        Method $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : ((Object)$method).hashCode());
        return result;
    }

    public String toString() {
        return "RequestMappingModel(paths=" + this.getPaths() + ", methods=" + this.getMethods() + ", consumes=" + this.getConsumes() + ", produces=" + this.getProduces() + ", converter=" + this.getConverter() + ", method=" + this.getMethod() + ")";
    }
}

