/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rest.model;

import cn.imaq.autumn.rest.annotation.ControllerAdvice;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

public class ControllerAdviceModel {
    private List<ControllerJoinPoint> includes;
    private List<ControllerJoinPoint> excludes;

    public ControllerAdviceModel(ControllerAdvice anno) {
        this.includes = Arrays.stream(anno.include()).map(x$0 -> new ControllerJoinPoint((String)x$0)).collect(Collectors.toList());
        this.excludes = Arrays.stream(anno.exclude()).map(x$0 -> new ControllerJoinPoint((String)x$0)).collect(Collectors.toList());
    }

    public ControllerAdviceModel(String className) {
        this.includes = Collections.singletonList(new ControllerJoinPoint(className));
        this.excludes = Collections.emptyList();
    }

    public boolean matches(Class<?> clazz) {
        String targetClassName = clazz.getName();
        for (ControllerJoinPoint excludePoint : this.excludes) {
            if (!excludePoint.matchClass(targetClassName)) continue;
            return false;
        }
        for (ControllerJoinPoint includePoint : this.includes) {
            if (!includePoint.matchClass(targetClassName)) continue;
            return true;
        }
        return false;
    }

    public List<ControllerJoinPoint> getIncludes() {
        return this.includes;
    }

    public List<ControllerJoinPoint> getExcludes() {
        return this.excludes;
    }

    public void setIncludes(List<ControllerJoinPoint> includes) {
        this.includes = includes;
    }

    public void setExcludes(List<ControllerJoinPoint> excludes) {
        this.excludes = excludes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ControllerAdviceModel)) {
            return false;
        }
        ControllerAdviceModel other = (ControllerAdviceModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<ControllerJoinPoint> this$includes = this.getIncludes();
        List<ControllerJoinPoint> other$includes = other.getIncludes();
        if (this$includes == null ? other$includes != null : !((Object)this$includes).equals(other$includes)) {
            return false;
        }
        List<ControllerJoinPoint> this$excludes = this.getExcludes();
        List<ControllerJoinPoint> other$excludes = other.getExcludes();
        return !(this$excludes == null ? other$excludes != null : !((Object)this$excludes).equals(other$excludes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ControllerAdviceModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<ControllerJoinPoint> $includes = this.getIncludes();
        result = result * 59 + ($includes == null ? 43 : ((Object)$includes).hashCode());
        List<ControllerJoinPoint> $excludes = this.getExcludes();
        result = result * 59 + ($excludes == null ? 43 : ((Object)$excludes).hashCode());
        return result;
    }

    public String toString() {
        return "ControllerAdviceModel(includes=" + this.getIncludes() + ", excludes=" + this.getExcludes() + ")";
    }

    private class ControllerJoinPoint {
        private String className;
        private boolean wildcard = false;

        ControllerJoinPoint(String desc) {
            if (desc.endsWith("*")) {
                this.className = desc.substring(0, desc.length() - 1);
                this.wildcard = true;
            } else {
                this.className = desc;
            }
        }

        boolean matchClass(String targetClassName) {
            if (this.wildcard) {
                return targetClassName.startsWith(this.className);
            }
            return targetClassName.equals(this.className);
        }

        public String getClassName() {
            return this.className;
        }

        public boolean isWildcard() {
            return this.wildcard;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public void setWildcard(boolean wildcard) {
            this.wildcard = wildcard;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ControllerJoinPoint)) {
                return false;
            }
            ControllerJoinPoint other = (ControllerJoinPoint)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isWildcard() != other.isWildcard()) {
                return false;
            }
            String this$className = this.getClassName();
            String other$className = other.getClassName();
            return !(this$className == null ? other$className != null : !this$className.equals(other$className));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ControllerJoinPoint;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isWildcard() ? 79 : 97);
            String $className = this.getClassName();
            result = result * 59 + ($className == null ? 43 : $className.hashCode());
            return result;
        }

        public String toString() {
            return "ControllerAdviceModel.ControllerJoinPoint(className=" + this.getClassName() + ", wildcard=" + this.isWildcard() + ")";
        }
    }
}

