/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.rest.core;

import cn.imaq.autumn.core.context.AutumnContext;
import cn.imaq.autumn.rest.core.RequestMethod;
import cn.imaq.autumn.rest.model.ExceptionHandlerModel;
import cn.imaq.autumn.rest.model.RequestMappingModel;
import cn.imaq.autumn.rest.util.PathUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestContext {
    private static final Logger log = LoggerFactory.getLogger(RestContext.class);
    public static final String ATTR = RestContext.class.getName();
    private AutumnContext applicationContext;
    private List<RequestMappingModel> mappings = new ArrayList<RequestMappingModel>();
    private List<ExceptionHandlerModel> exceptionHandlers = new ArrayList<ExceptionHandlerModel>();
    private Map<Class<?>, Object> instances = new ConcurrentHashMap();

    private RestContext(AutumnContext applicationContext) {
        this.applicationContext = applicationContext;
        applicationContext.setAttribute(ATTR, (Object)this);
    }

    public static RestContext build() {
        AutumnContext applicationContext = new AutumnContext("applicationContext");
        RestContext restContext = new RestContext(applicationContext);
        applicationContext.scanComponents();
        return restContext;
    }

    public <T> T getInstance(Class<? extends T> clazz) {
        Object instance = this.instances.get(clazz);
        if (instance != null && clazz.isInstance(instance)) {
            return (T)instance;
        }
        try {
            instance = clazz.newInstance();
            this.instances.put(clazz, instance);
            return (T)instance;
        }
        catch (IllegalAccessException | InstantiationException e) {
            log.error("Error instantiating {}: {}", (Object)clazz.getName(), (Object)String.valueOf(e));
            return null;
        }
    }

    public void addMapping(RequestMappingModel mappingModel) {
        this.mappings.add(mappingModel);
    }

    public void addExceptionHandler(ExceptionHandlerModel exceptionHandlerModel) {
        this.exceptionHandlers.add(exceptionHandlerModel);
    }

    public RequestMappingModel matchRequestMapping(HttpServletRequest req) {
        String pathInfo = PathUtil.transform(req.getPathInfo());
        for (RequestMappingModel mapping : this.mappings) {
            if (!mapping.getPaths().contains(pathInfo) || !mapping.getMethods().isEmpty() && !mapping.getMethods().contains((Object)RequestMethod.valueOf(req.getMethod())) || !mapping.getConsumes().isEmpty() && !mapping.getConsumes().contains(req.getContentType())) continue;
            return mapping;
        }
        return null;
    }

    public ExceptionHandlerModel matchExceptionHandler(Class<?> controllerClass, Class<? extends Throwable> throwableClass) {
        for (ExceptionHandlerModel handler : this.exceptionHandlers) {
            if (!handler.getControllerAdvice().matches(controllerClass)) continue;
            for (Class<? extends Throwable> thrClass : handler.getThrowableClasses()) {
                if (!thrClass.isAssignableFrom(throwableClass)) continue;
                return handler;
            }
        }
        return null;
    }

    public AutumnContext getApplicationContext() {
        return this.applicationContext;
    }
}

