/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.integration.mybatis;

import cn.imaq.autumn.core.beans.creator.BeanCreator;
import cn.imaq.autumn.core.context.AutumnContext;
import cn.imaq.autumn.core.exception.BeanCreationException;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import org.apache.ibatis.session.SqlSessionFactory;

public class MapperCreator
implements BeanCreator {
    private Class<?> mapperType;
    private AutumnContext context;

    MapperCreator(Class<?> mapperType, AutumnContext context) {
        this.mapperType = mapperType;
        this.context = context;
    }

    public Object createBean() throws BeanCreationException {
        final SqlSessionFactory sqlSessionFactory = (SqlSessionFactory)this.context.getBeanByType(SqlSessionFactory.class);
        if (sqlSessionFactory == null) {
            throw new BeanCreationException("Cannot get SqlSessionFactory from application context");
        }
        try {
            return Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{this.mapperType}, new InvocationHandler(){
                private ThreadLocal<Object> targetLocal = new ThreadLocal();

                @Override
                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object target = this.targetLocal.get();
                    if (target == null) {
                        target = sqlSessionFactory.openSession(true).getMapper(MapperCreator.this.mapperType);
                        this.targetLocal.set(target);
                    }
                    try {
                        return method.invoke(target, args);
                    }
                    catch (InvocationTargetException e) {
                        throw e.getTargetException();
                    }
                }
            });
        }
        catch (Exception e) {
            throw new BeanCreationException((Throwable)e);
        }
    }
}

