/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.http.protocol;

import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AutumnHttpResponse {
    private String protocol;
    private int status;
    private Map<String, List<String>> headers;
    private String contentType;
    private byte[] body;

    public byte[] toHeaderBytes() {
        StringBuilder sb = new StringBuilder();
        sb.append("HTTP/1.1 ").append(this.status).append(' ').append(ResponseCodes.get(this.status)).append("\r\n");
        boolean sentContentType = false;
        boolean sentContentLength = false;
        if (this.headers != null) {
            for (Map.Entry<String, List<String>> header : this.headers.entrySet()) {
                String key = header.getKey();
                for (String value : header.getValue()) {
                    sb.append(key).append(": ").append(value).append("\r\n");
                }
                if (key.toLowerCase().equals("content-type")) {
                    sentContentType = true;
                    continue;
                }
                if (!key.toLowerCase().equals("content-length")) continue;
                sentContentLength = true;
            }
        }
        if (!sentContentType && this.contentType != null) {
            sb.append("Content-Type: ").append(this.contentType).append("\r\n");
        }
        if (!sentContentLength && this.body != null) {
            sb.append("Content-Length: ").append(this.body.length).append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString().getBytes();
    }

    AutumnHttpResponse(String protocol, int status, Map<String, List<String>> headers, String contentType, byte[] body) {
        this.protocol = protocol;
        this.status = status;
        this.headers = headers;
        this.contentType = contentType;
        this.body = body;
    }

    public static AutumnHttpResponseBuilder builder() {
        return new AutumnHttpResponseBuilder();
    }

    public String getProtocol() {
        return this.protocol;
    }

    public int getStatus() {
        return this.status;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public String getContentType() {
        return this.contentType;
    }

    public byte[] getBody() {
        return this.body;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutumnHttpResponse)) {
            return false;
        }
        AutumnHttpResponse other = (AutumnHttpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getStatus() != other.getStatus()) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        String this$contentType = this.getContentType();
        String other$contentType = other.getContentType();
        if (this$contentType == null ? other$contentType != null : !this$contentType.equals(other$contentType)) {
            return false;
        }
        return Arrays.equals(this.getBody(), other.getBody());
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutumnHttpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getStatus();
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        String $contentType = this.getContentType();
        result = result * 59 + ($contentType == null ? 43 : $contentType.hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        return result;
    }

    public String toString() {
        return "AutumnHttpResponse(protocol=" + this.getProtocol() + ", status=" + this.getStatus() + ", headers=" + this.getHeaders() + ", contentType=" + this.getContentType() + ", body=" + Arrays.toString(this.getBody()) + ")";
    }

    public static class AutumnHttpResponseBuilder {
        private String protocol;
        private int status;
        private Map<String, List<String>> headers;
        private String contentType;
        private byte[] body;

        AutumnHttpResponseBuilder() {
        }

        public AutumnHttpResponseBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public AutumnHttpResponseBuilder status(int status) {
            this.status = status;
            return this;
        }

        public AutumnHttpResponseBuilder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public AutumnHttpResponseBuilder contentType(String contentType) {
            this.contentType = contentType;
            return this;
        }

        public AutumnHttpResponseBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public AutumnHttpResponse build() {
            return new AutumnHttpResponse(this.protocol, this.status, this.headers, this.contentType, this.body);
        }

        public String toString() {
            return "AutumnHttpResponse.AutumnHttpResponseBuilder(protocol=" + this.protocol + ", status=" + this.status + ", headers=" + this.headers + ", contentType=" + this.contentType + ", body=" + Arrays.toString(this.body) + ")";
        }
    }

    public static class ResponseCodes {
        static final String[][] RESPONSE_CODES = new String[][]{{"Continue", "Switching Protocols", "Processing", "Early Hints"}, {"OK", "Created", "Accepted", "Non-authoritative Information", "No Content", "Reset Content", "Partial Content", "Multi-Status", "Already Reported"}, {"Multiple Choices", "Moved Permanently", "Found", "See Other", "Not Modified", "Use Proxy", "Switch Proxy", "Temporary Redirect", "Permanent Redirect"}, {"Bad Request", "Unauthorized", "Payment Required", "Forbidden", "Not Found", "Method Not Allowed", "Not Acceptable", "Proxy Authentication Required", "Request Timeout", "Conflict", "Gone", "Length Required", "Precondition Failed", "Payload Too Large", "Request-URI Too Long", "Unsupported Media Type", "Requested Range Not Satisfiable", "Expectation Failed", "I'm a teapot", null, null, "Misdirected Request", "Unprocessable Entity", "Locked", "Failed Dependency", "Too Early", "Upgrade Required", null, "Precondition Required", "Too Many Requests", null, "Request Header Fields Too Large", null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, "Unavailable For Legal Reasons"}, {"Internal Server Error", "Not Implemented", "Bad Gateway", "Service Unavailable", "Gateway Timeout", "HTTP Version Not Supported", "Variant Also Negotiates", "Insufficient Storage", "Loop Detected", null, "Not Extended", "Network Authentication Required"}};

        public static String get(int code) {
            try {
                return RESPONSE_CODES[code / 100 - 1][code % 100];
            }
            catch (Exception e) {
                return null;
            }
        }
    }
}

