/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.http.protocol;

import java.net.SocketAddress;
import java.util.Arrays;
import java.util.List;
import java.util.Map;

public class AutumnHttpRequest {
    private String method;
    private String path;
    private String protocol;
    private Map<String, List<String>> headers;
    private byte[] body;
    private SocketAddress localAddress;
    private SocketAddress remoteAddress;

    public byte[] toHeaderBytes() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.method).append(' ').append(this.path).append(' ').append(this.protocol).append("\r\n");
        if (this.headers != null) {
            for (Map.Entry<String, List<String>> header : this.headers.entrySet()) {
                for (String value : header.getValue()) {
                    sb.append(header.getKey()).append(": ").append(value).append("\r\n");
                }
            }
        }
        if (this.body != null) {
            sb.append("Content-Length: ").append(this.body.length).append("\r\n");
        }
        sb.append("\r\n");
        return sb.toString().getBytes();
    }

    AutumnHttpRequest(String method, String path, String protocol, Map<String, List<String>> headers, byte[] body, SocketAddress localAddress, SocketAddress remoteAddress) {
        this.method = method;
        this.path = path;
        this.protocol = protocol;
        this.headers = headers;
        this.body = body;
        this.localAddress = localAddress;
        this.remoteAddress = remoteAddress;
    }

    public static AutumnHttpRequestBuilder builder() {
        return new AutumnHttpRequestBuilder();
    }

    public String getMethod() {
        return this.method;
    }

    public String getPath() {
        return this.path;
    }

    public String getProtocol() {
        return this.protocol;
    }

    public Map<String, List<String>> getHeaders() {
        return this.headers;
    }

    public byte[] getBody() {
        return this.body;
    }

    public SocketAddress getLocalAddress() {
        return this.localAddress;
    }

    public SocketAddress getRemoteAddress() {
        return this.remoteAddress;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public void setProtocol(String protocol) {
        this.protocol = protocol;
    }

    public void setHeaders(Map<String, List<String>> headers) {
        this.headers = headers;
    }

    public void setBody(byte[] body) {
        this.body = body;
    }

    public void setLocalAddress(SocketAddress localAddress) {
        this.localAddress = localAddress;
    }

    public void setRemoteAddress(SocketAddress remoteAddress) {
        this.remoteAddress = remoteAddress;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AutumnHttpRequest)) {
            return false;
        }
        AutumnHttpRequest other = (AutumnHttpRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$method = this.getMethod();
        String other$method = other.getMethod();
        if (this$method == null ? other$method != null : !this$method.equals(other$method)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$protocol = this.getProtocol();
        String other$protocol = other.getProtocol();
        if (this$protocol == null ? other$protocol != null : !this$protocol.equals(other$protocol)) {
            return false;
        }
        Map<String, List<String>> this$headers = this.getHeaders();
        Map<String, List<String>> other$headers = other.getHeaders();
        if (this$headers == null ? other$headers != null : !((Object)this$headers).equals(other$headers)) {
            return false;
        }
        if (!Arrays.equals(this.getBody(), other.getBody())) {
            return false;
        }
        SocketAddress this$localAddress = this.getLocalAddress();
        SocketAddress other$localAddress = other.getLocalAddress();
        if (this$localAddress == null ? other$localAddress != null : !this$localAddress.equals(other$localAddress)) {
            return false;
        }
        SocketAddress this$remoteAddress = this.getRemoteAddress();
        SocketAddress other$remoteAddress = other.getRemoteAddress();
        return !(this$remoteAddress == null ? other$remoteAddress != null : !this$remoteAddress.equals(other$remoteAddress));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AutumnHttpRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $method = this.getMethod();
        result = result * 59 + ($method == null ? 43 : $method.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $protocol = this.getProtocol();
        result = result * 59 + ($protocol == null ? 43 : $protocol.hashCode());
        Map<String, List<String>> $headers = this.getHeaders();
        result = result * 59 + ($headers == null ? 43 : ((Object)$headers).hashCode());
        result = result * 59 + Arrays.hashCode(this.getBody());
        SocketAddress $localAddress = this.getLocalAddress();
        result = result * 59 + ($localAddress == null ? 43 : $localAddress.hashCode());
        SocketAddress $remoteAddress = this.getRemoteAddress();
        result = result * 59 + ($remoteAddress == null ? 43 : $remoteAddress.hashCode());
        return result;
    }

    public String toString() {
        return "AutumnHttpRequest(method=" + this.getMethod() + ", path=" + this.getPath() + ", protocol=" + this.getProtocol() + ", headers=" + this.getHeaders() + ", body=" + Arrays.toString(this.getBody()) + ", localAddress=" + this.getLocalAddress() + ", remoteAddress=" + this.getRemoteAddress() + ")";
    }

    public static class AutumnHttpRequestBuilder {
        private String method;
        private String path;
        private String protocol;
        private Map<String, List<String>> headers;
        private byte[] body;
        private SocketAddress localAddress;
        private SocketAddress remoteAddress;

        AutumnHttpRequestBuilder() {
        }

        public AutumnHttpRequestBuilder method(String method) {
            this.method = method;
            return this;
        }

        public AutumnHttpRequestBuilder path(String path) {
            this.path = path;
            return this;
        }

        public AutumnHttpRequestBuilder protocol(String protocol) {
            this.protocol = protocol;
            return this;
        }

        public AutumnHttpRequestBuilder headers(Map<String, List<String>> headers) {
            this.headers = headers;
            return this;
        }

        public AutumnHttpRequestBuilder body(byte[] body) {
            this.body = body;
            return this;
        }

        public AutumnHttpRequestBuilder localAddress(SocketAddress localAddress) {
            this.localAddress = localAddress;
            return this;
        }

        public AutumnHttpRequestBuilder remoteAddress(SocketAddress remoteAddress) {
            this.remoteAddress = remoteAddress;
            return this;
        }

        public AutumnHttpRequest build() {
            return new AutumnHttpRequest(this.method, this.path, this.protocol, this.headers, this.body, this.localAddress, this.remoteAddress);
        }

        public String toString() {
            return "AutumnHttpRequest.AutumnHttpRequestBuilder(method=" + this.method + ", path=" + this.path + ", protocol=" + this.protocol + ", headers=" + this.headers + ", body=" + Arrays.toString(this.body) + ", localAddress=" + this.localAddress + ", remoteAddress=" + this.remoteAddress + ")";
        }
    }
}

