/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.http.protocol;

import cn.imaq.autumn.http.protocol.AutumnByteArrayReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractHttpSession {
    private static final Logger log = LoggerFactory.getLogger(AbstractHttpSession.class);
    private final int maxBodyLength;
    private final byte[] buf = new byte[2048];
    private int bufLimit;
    private State state = State.START;
    protected long lastActive = System.currentTimeMillis();
    protected Map<String, List<String>> headersMap = new HashMap<String, List<String>>();
    private int contentLength = -1;
    protected boolean closeConnection = false;
    protected byte[] body;
    private int bodyLimit;

    protected AbstractHttpSession(int maxBodyLength) {
        this.maxBodyLength = maxBodyLength;
    }

    public void processByteBuffer(ByteBuffer byteBuf) throws IOException {
        if (this.bufLimit + byteBuf.limit() > this.buf.length) {
            this.bufLimit = 0;
        }
        byteBuf.get(this.buf, this.bufLimit, byteBuf.limit());
        this.bufLimit += byteBuf.limit();
        this.processBuf();
    }

    protected abstract boolean checkStart(String var1);

    protected abstract void finish() throws IOException;

    protected abstract void error() throws IOException;

    protected abstract void close() throws IOException;

    private void finishAndReset() throws IOException {
        this.finish();
        this.state = State.START;
        this.bufLimit = 0;
        this.headersMap.clear();
        this.contentLength = -1;
        this.body = null;
        this.bodyLimit = 0;
    }

    protected void tryClose() {
        try {
            this.close();
        }
        catch (IOException e) {
            log.warn("Failed to close connection: {}", (Object)String.valueOf(e));
        }
    }

    protected void refreshLastActiveTime() {
        this.lastActive = System.currentTimeMillis();
    }

    private void processBuf() throws IOException {
        int readBytes = 0;
        if (this.state == State.START || this.state == State.HEADERS) {
            String line;
            AutumnByteArrayReader reader = new AutumnByteArrayReader(this.buf, 0, this.bufLimit);
            while ((line = reader.nextLine()) != null) {
                if (this.state == State.START) {
                    if (this.checkStart(line)) {
                        this.refreshLastActiveTime();
                        this.state = State.HEADERS;
                        continue;
                    }
                    if (line.isEmpty()) continue;
                    this.error();
                    this.close();
                    return;
                }
                if (this.state != State.HEADERS) continue;
                if (line.isEmpty()) {
                    List<String> connectionHeaders;
                    this.refreshLastActiveTime();
                    List<String> contentLengthHeaders = this.headersMap.get("content-length");
                    if (contentLengthHeaders != null) {
                        this.contentLength = Integer.parseInt(contentLengthHeaders.get(0));
                        if (this.contentLength > this.maxBodyLength) {
                            this.error();
                            this.close();
                            return;
                        }
                    }
                    if ((connectionHeaders = this.headersMap.get("connection")) != null && connectionHeaders.get(0).toLowerCase().equals("close")) {
                        this.closeConnection = true;
                    }
                    if (this.contentLength <= 0) {
                        this.finishAndReset();
                        return;
                    }
                    this.body = new byte[this.contentLength];
                    this.state = State.BODY;
                    break;
                }
                String[] kv = line.split(":", 2);
                if (kv.length == 2) {
                    this.refreshLastActiveTime();
                    String key = kv[0].trim().toLowerCase();
                    String value = kv[1].trim();
                    this.headersMap.computeIfAbsent(key, k -> new LinkedList()).add(value);
                    continue;
                }
                this.error();
                this.close();
                return;
            }
            readBytes += reader.getReadBytes();
        }
        if (this.state == State.BODY) {
            this.refreshLastActiveTime();
            int canRead = this.bufLimit - readBytes;
            if (canRead >= this.contentLength - this.bodyLimit) {
                canRead = this.contentLength - this.bodyLimit;
            }
            System.arraycopy(this.buf, readBytes, this.body, this.bodyLimit, canRead);
            readBytes += canRead;
            this.bodyLimit += canRead;
            if (this.bodyLimit >= this.contentLength) {
                this.finishAndReset();
                return;
            }
        }
        if (readBytes < this.bufLimit && readBytes > 0) {
            System.arraycopy(this.buf, readBytes, this.buf, 0, this.bufLimit - readBytes);
        }
        this.bufLimit -= readBytes;
    }

    protected static enum State {
        START,
        HEADERS,
        BODY;

    }
}

