/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.http.protocol;

import cn.imaq.autumn.http.protocol.AutumnByteArrayReader;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractHttpSession {
    private static final int MAX_BODY_LENGTH = 0xA00000;
    private State state = State.START;
    protected long lastActive = System.currentTimeMillis();
    protected Map<String, List<String>> headersMap = new HashMap<String, List<String>>();
    private int contentLength = -1;
    private byte[] buf = new byte[2048];
    private int bufLimit = 0;
    protected byte[] body;
    private int bodyLimit = 0;

    public void processByteBuffer(ByteBuffer byteBuf) throws IOException {
        if (this.bufLimit + byteBuf.limit() > this.buf.length) {
            this.bufLimit = 0;
        }
        byteBuf.get(this.buf, this.bufLimit, byteBuf.limit());
        this.bufLimit += byteBuf.limit();
        this.processBuf();
    }

    protected abstract boolean checkStart(String var1);

    protected abstract void finish() throws IOException;

    protected abstract void error() throws IOException;

    private void processBuf() throws IOException {
        int readBytes = 0;
        if (this.state == State.START || this.state == State.HEADERS) {
            String line;
            AutumnByteArrayReader reader = new AutumnByteArrayReader(this.buf, 0, this.bufLimit);
            while ((line = reader.nextLine()) != null) {
                readBytes += line.getBytes().length + 2;
                if (this.state == State.START) {
                    if (!this.checkStart(line)) continue;
                    this.lastActive = System.currentTimeMillis();
                    this.state = State.HEADERS;
                    this.headersMap.clear();
                    continue;
                }
                if (this.state != State.HEADERS) continue;
                if (line.isEmpty()) {
                    if (this.contentLength < 0) {
                        this.lastActive = System.currentTimeMillis();
                        this.finish();
                        this.state = State.START;
                        break;
                    }
                    this.state = State.BODY;
                    break;
                }
                String[] kv = line.split(":", 2);
                if (kv.length == 2) {
                    this.lastActive = System.currentTimeMillis();
                    String key = kv[0].trim().toLowerCase();
                    String value = kv[1].trim();
                    this.headersMap.computeIfAbsent(key, k -> new ArrayList()).add(value);
                    if (!key.equals("content-length")) continue;
                    this.contentLength = Integer.valueOf(value);
                    if (this.contentLength > 0xA00000) {
                        this.error();
                        this.state = State.START;
                        continue;
                    }
                    this.body = new byte[this.contentLength];
                    this.bodyLimit = 0;
                    continue;
                }
                this.error();
                this.state = State.START;
            }
        }
        if (this.state == State.BODY) {
            this.lastActive = System.currentTimeMillis();
            int canRead = this.bufLimit - readBytes;
            if (canRead >= this.contentLength - this.bodyLimit) {
                canRead = this.contentLength - this.bodyLimit;
            }
            System.arraycopy(this.buf, readBytes, this.body, this.bodyLimit, canRead);
            readBytes += canRead;
            this.bodyLimit += canRead;
            if (this.bodyLimit >= this.contentLength) {
                readBytes = this.bufLimit;
                this.finish();
                this.state = State.START;
            }
        }
        if (readBytes < this.bufLimit) {
            System.arraycopy(this.buf, readBytes, this.buf, 0, this.bufLimit - readBytes);
        }
        this.bufLimit -= readBytes;
    }

    protected static enum State {
        START,
        HEADERS,
        BODY;

    }
}

