/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.http.client.protocol;

import cn.imaq.autumn.http.client.protocol.HttpClientSession;
import cn.imaq.autumn.http.protocol.AutumnHttpResponse;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.SocketChannel;
import java.util.Iterator;

public class HttpConnection {
    private InetSocketAddress remote;
    private Selector selector;
    private SocketChannel channel;
    private ByteBuffer buf;

    public HttpConnection(InetSocketAddress remote) throws IOException {
        this.remote = remote;
        this.selector = Selector.open();
        this.channel = SocketChannel.open();
        this.channel.configureBlocking(false);
        this.buf = ByteBuffer.allocateDirect(1024);
    }

    public void checkConnected(long deadline) throws IOException {
        if (!this.channel.isConnected()) {
            this.channel.register(this.selector, 8);
            this.channel.connect(this.remote);
            block0: while (true) {
                SelectionKey key;
                int count;
                if ((count = this.selector.select(deadline - System.currentTimeMillis())) <= 0) {
                    this.channel.close();
                    throw new IOException("Connect timed out: " + this.remote);
                }
                Iterator<SelectionKey> keyIter = this.selector.selectedKeys().iterator();
                do {
                    if (!keyIter.hasNext()) continue block0;
                    key = keyIter.next();
                    keyIter.remove();
                } while (!key.isValid() || !key.isConnectable());
                break;
            }
            if (!this.channel.finishConnect()) {
                throw new IOException("Failed to connect: " + this.remote);
            }
            this.channel.register(this.selector, 1);
            return;
        }
    }

    public void writeBytes(byte[] data) throws IOException {
        this.channel.write(ByteBuffer.wrap(data));
    }

    public AutumnHttpResponse readResponse(long deadline) throws IOException {
        HttpClientSession session = new HttpClientSession();
        block0: while (true) {
            int count;
            if ((count = this.selector.select(deadline - System.currentTimeMillis())) <= 0) {
                this.channel.close();
                this.selector.close();
                throw new IOException("Read timed out: " + this.remote);
            }
            Iterator<SelectionKey> keyIter = this.selector.selectedKeys().iterator();
            while (true) {
                if (!keyIter.hasNext()) continue block0;
                SelectionKey key = keyIter.next();
                keyIter.remove();
                if (!key.isValid() || !key.isReadable()) continue;
                this.buf.clear();
                int readBytes = ((SocketChannel)key.channel()).read(this.buf);
                if (readBytes <= 0) continue;
                this.buf.flip();
                session.processByteBuffer(this.buf);
                if (session.isFinished()) break block0;
            }
            break;
        }
        return session.getResponse();
    }
}

