/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.http.client.protocol;

import cn.imaq.autumn.http.protocol.AbstractHttpSession;
import cn.imaq.autumn.http.protocol.AutumnHttpResponse;
import java.io.IOException;
import java.util.List;

public class HttpClientSession
extends AbstractHttpSession {
    private int responseCode;
    private String protocol;
    private boolean finished = false;

    public HttpClientSession() {
        super(0x100000);
    }

    public boolean isFinished() {
        return this.finished;
    }

    public AutumnHttpResponse getResponse() {
        String contentType = this.headersMap != null ? (String)((List)this.headersMap.get("content-type")).get(0) : null;
        return AutumnHttpResponse.builder().protocol(this.protocol).status(this.responseCode).headers(this.headersMap).contentType(contentType).body(this.body).build();
    }

    protected boolean checkStart(String line) {
        String[] words = line.split(" ", 3);
        if (words.length == 3 && words[0].startsWith("HTTP")) {
            this.protocol = words[0];
            try {
                this.responseCode = Integer.parseInt(words[1]);
            }
            catch (NumberFormatException e) {
                return false;
            }
            return true;
        }
        return false;
    }

    protected void finish() {
        this.finished = true;
    }

    protected void error() {
        System.err.println("Error parsing HTTP response");
    }

    protected void close() throws IOException {
    }
}

