/*
 * Decompiled with CFR 0.152.
 */
package cn.imaq.autumn.aop.scanner;

import cn.imaq.autumn.aop.AopContext;
import cn.imaq.autumn.aop.advice.Advice;
import cn.imaq.autumn.aop.advice.AfterAdvice;
import cn.imaq.autumn.aop.advice.AfterReturningAdvice;
import cn.imaq.autumn.aop.advice.AfterThrowingAdvice;
import cn.imaq.autumn.aop.advice.AroundAdvice;
import cn.imaq.autumn.aop.advice.BeforeAdvice;
import cn.imaq.autumn.aop.annotation.Aspect;
import cn.imaq.autumn.core.beans.BeanInfo;
import cn.imaq.autumn.core.beans.creator.BeanCreator;
import cn.imaq.autumn.core.beans.creator.NormalBeanCreator;
import cn.imaq.autumn.core.beans.scanner.BeanScanner;
import cn.imaq.autumn.core.context.AutumnContext;
import cn.imaq.autumn.cpscan.ScanResult;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Parameter;
import java.util.HashMap;
import java.util.Map;
import org.aspectj.lang.annotation.After;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.AfterThrowing;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Before;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AspectBeanScanner
implements BeanScanner {
    private static final Logger log = LoggerFactory.getLogger(AspectBeanScanner.class);
    private static final Map<Class<? extends Annotation>, AdviceAnnotationParser<?>> annotationParsers = new HashMap();

    private static int getArgIndex(String name, String argNames, Method method) {
        Parameter[] params = method.getParameters();
        String[] names = argNames.split(",");
        for (int i = 0; i < params.length; ++i) {
            if ((names.length <= i || !names[i].trim().equals(name)) && (!params[i].isNamePresent() || !params[i].getName().equals(name))) continue;
            return i;
        }
        return -1;
    }

    public void process(ScanResult result, AutumnContext context) {
        AopContext aopContext = AopContext.getFrom(context);
        result.getClassesWithAnnotation(Aspect.class).forEach(cls -> {
            Aspect anno = cls.getAnnotation(Aspect.class);
            String name = anno.value();
            if (name.isEmpty()) {
                name = cls.getSimpleName().toLowerCase();
            }
            context.addBeanInfo(BeanInfo.builder().name(name).type(cls).singleton(true).creator((BeanCreator)new NormalBeanCreator(cls)).build());
            block0: for (Method method : cls.getDeclaredMethods()) {
                for (Class<? extends Annotation> annotationClass : annotationParsers.keySet()) {
                    if (!method.isAnnotationPresent(annotationClass)) continue;
                    method.setAccessible(true);
                    Annotation annotation = method.getAnnotation(annotationClass);
                    log.info("Adding advice {} {}", (Object)annotation, (Object)method);
                    aopContext.addAdvice(annotationParsers.get(annotationClass).parse(annotation, context, method));
                    continue block0;
                }
            }
        });
    }

    static {
        annotationParsers.put(Before.class, (annotation, context, adviceMethod) -> new BeforeAdvice(context, annotation.value(), adviceMethod));
        annotationParsers.put(After.class, (annotation, context, adviceMethod) -> new AfterAdvice(context, annotation.value(), adviceMethod));
        annotationParsers.put(Around.class, (annotation, context, adviceMethod) -> new AroundAdvice(context, annotation.value(), adviceMethod));
        annotationParsers.put(AfterReturning.class, (annotation, context, adviceMethod) -> {
            String expr = annotation.pointcut();
            if (expr.isEmpty()) {
                expr = annotation.value();
            }
            return new AfterReturningAdvice(context, expr, adviceMethod, AspectBeanScanner.getArgIndex(annotation.returning(), annotation.argNames(), adviceMethod));
        });
        annotationParsers.put(AfterThrowing.class, (annotation, context, adviceMethod) -> {
            String expr = annotation.pointcut();
            if (expr.isEmpty()) {
                expr = annotation.value();
            }
            return new AfterThrowingAdvice(context, expr, adviceMethod, AspectBeanScanner.getArgIndex(annotation.throwing(), annotation.argNames(), adviceMethod));
        });
    }

    @FunctionalInterface
    private static interface AdviceAnnotationParser<T extends Annotation> {
        default public Advice parse(Object annotation, AutumnContext context, Method adviceMethod) {
            return this.parse((T)((Annotation)annotation), context, adviceMethod);
        }

        public Advice parse(T var1, AutumnContext var2, Method var3);
    }
}

